/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.image.LookupTable;
import org.dcm4che2.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOIUtils {
    private static final Logger log = LoggerFactory.getLogger(VOIUtils.class);

    public static boolean containsVOIAttributes(DicomObject dobj) {
        return dobj.containsValue(2625616) && dobj.containsValue(2625617) || VOIUtils.getLUT(dobj, 2633744) != null;
    }

    public static DicomObject getLUT(DicomObject dobj, int sqTag) {
        DicomObject lut = dobj.getNestedDicomObject(sqTag);
        if (lut != null) {
            if (!lut.containsValue(2633734)) {
                log.info("Ignore " + TagUtils.toString((int)sqTag) + " with missing LUT Data (0028,3006)");
                return null;
            }
            if (!lut.containsValue(2633730)) {
                log.info("Ignore " + TagUtils.toString((int)sqTag) + " with missing LUT Descriptor (0028,3002)");
                return null;
            }
        }
        return lut;
    }

    public static boolean isModalityLUTcontainsPixelIntensityRelationshipLUT(DicomObject img) {
        return VOIUtils.isModalityLUTcontainsPixelIntensityRelationshipLUT(img.getString(524310));
    }

    public static boolean isModalityLUTcontainsPixelIntensityRelationshipLUT(String uid) {
        return "1.2.840.10008.5.1.4.1.1.12.1".equals(uid) || "1.2.840.10008.5.1.4.1.1.12.3".equals(uid) || "1.2.840.10008.5.1.4.1.1.12.2".equals(uid);
    }

    public static DicomObject selectModalityLUTObject(DicomObject img, DicomObject pr, int frame) {
        if (pr != null) {
            return pr;
        }
        if (VOIUtils.isModalityLUTcontainsPixelIntensityRelationshipLUT(img)) {
            return new BasicDicomObject();
        }
        DicomElement framed = img.get(1375769136);
        if (framed != null) {
            DicomObject mlutObj;
            DicomObject frameObj;
            int size = framed.countItems();
            log.debug("Looking in enhanced multi-frame Perframe object for VOI lut information, frames=" + size);
            if (frame >= 1 && frame <= size && (frameObj = framed.getDicomObject(frame - 1)) != null && (mlutObj = frameObj.getNestedDicomObject(2658629)) != null) {
                log.debug("Found a per-frame mlut info.");
                return mlutObj;
            }
        }
        try {
            DicomObject mlutObj;
            DicomObject shared = img.getNestedDicomObject(1375769129);
            if (shared != null && (mlutObj = shared.getNestedDicomObject(2658629)) != null) {
                log.debug("Found a shared mLut information object ");
                return mlutObj;
            }
        }
        catch (UnsupportedOperationException e) {
            log.warn("Shared functional groups is the wrong VR type:" + e);
        }
        return img;
    }

    public static DicomObject selectVoiObject(DicomObject img, DicomObject pr, int frame) {
        DicomObject voiObj;
        DicomObject shared;
        String iuid = img.getString(524312);
        DicomObject voi = VOIUtils.selectVoiItemFromPr(iuid, pr, frame);
        if (voi != null) {
            return voi;
        }
        if (pr != null) {
            return pr;
        }
        DicomElement framed = img.get(1375769136);
        if (framed != null) {
            DicomObject voiObj2;
            DicomObject frameObj;
            int size = framed.countItems();
            if (frame >= 1 && frame <= size && (frameObj = framed.getDicomObject(frame - 1)) != null && (voiObj2 = frameObj.getNestedDicomObject(2658610)) != null && VOIUtils.containsVOIAttributes(voiObj2)) {
                return voiObj2;
            }
        }
        if ((shared = img.getNestedDicomObject(1375769129)) != null && (voiObj = shared.getNestedDicomObject(2658610)) != null && VOIUtils.containsVOIAttributes(voiObj)) {
            return voiObj;
        }
        if (VOIUtils.containsVOIAttributes(img)) {
            return img;
        }
        return null;
    }

    public static DicomObject selectVoiItemFromPr(String iuid, DicomObject pr, int frame) {
        if (pr == null) {
            return null;
        }
        DicomElement voisq = pr.get(2634000);
        if (voisq == null) {
            return pr;
        }
        int n = voisq.countItems();
        for (int i = 0; i < n; ++i) {
            DicomObject item = voisq.getDicomObject(i);
            DicomElement refImgs = item.get(528704);
            if (refImgs == null) {
                return item;
            }
            int m = refImgs.countItems();
            for (int j = 0; j < m; ++j) {
                DicomObject refImage = refImgs.getDicomObject(j);
                if (!iuid.equals(refImage.getString(528725))) continue;
                int[] frames = refImage.getInts(528736);
                if (frames == null || frames.length == 0) {
                    return item;
                }
                if (frame == 0) {
                    return null;
                }
                for (int k = 0; k < frames.length; ++k) {
                    if (frames[k] != frame) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public static float[] getMinMaxWindowCenterWidth(DicomObject img, DicomObject pr, int frame, Raster raster) {
        int[] minMax;
        float intercept;
        float slope;
        DicomObject mObj = VOIUtils.selectModalityLUTObject(img, pr, frame);
        DicomObject mLut = VOIUtils.getLUT(mObj, 2633728);
        if (mLut != null) {
            slope = 1.0f;
            intercept = 0.0f;
            minMax = VOIUtils.calcMinMax(mLut);
        } else {
            slope = mObj.getFloat(2625619, 1.0f);
            intercept = mObj.getFloat(2625618, 0.0f);
            if (img.containsValue(2621702) && img.containsValue(2621703)) {
                minMax = new int[]{img.getInt(2621702), img.getInt(2621703)};
            } else if (raster == null || !(raster.getSampleModel() instanceof ComponentSampleModel)) {
                String rescaleType;
                boolean signed;
                log.debug("Using min/max possible values to compute WL range, as we don't have data buffer to use.");
                int stored = img.getInt(2621697);
                boolean bl = signed = img.getInt(2621699) == 1;
                if (stored == 16 && "HU".equalsIgnoreCase(rescaleType = mObj.getString(2625620))) {
                    stored = 12;
                }
                minMax = new int[]{signed ? -(1 << stored - 1) : 0, signed ? (1 << stored - 1) - 1 : (1 << stored) - 1};
            } else {
                minMax = VOIUtils.calcMinMax(img, raster);
            }
        }
        if (minMax[0] == minMax[1]) {
            if (minMax[0] > 0) {
                minMax[0] = 0;
            } else {
                minMax[1] = minMax[0] + 1;
            }
        }
        return new float[]{(float)(minMax[1] + minMax[0]) / 2.0f * slope + intercept + 0.5f, Math.abs((float)(minMax[1] - minMax[0]) * slope) + 1.0f};
    }

    public static int[] calcMinMax(DicomObject img, Raster raster) {
        int[] ret;
        int allocated = img.getInt(2621696, 8);
        int stored = img.getInt(2621697, allocated);
        boolean signed = img.getInt(2621699) != 0;
        int range = 1 << stored;
        int mask = range - 1;
        int signbit = signed ? 1 << stored - 1 : 0;
        int w = raster.getWidth();
        int h = raster.getHeight();
        int scanlineStride = ((ComponentSampleModel)raster.getSampleModel()).getScanlineStride();
        Integer pixelPaddingValue = LookupTable.getIntPixelValue(img, 2621728, signed, stored);
        Integer pixelPaddingRangeLimit = LookupTable.getIntPixelValue(img, 2621729, signed, stored);
        int paddingMin = Integer.MIN_VALUE;
        int paddingMax = Integer.MIN_VALUE;
        if (pixelPaddingValue != null) {
            Integer[] pixelPaddingMinMax = LookupTable.getMinMaxPixelPadding(pixelPaddingValue, pixelPaddingRangeLimit);
            paddingMin = pixelPaddingMinMax[0];
            paddingMax = pixelPaddingMinMax[1];
        }
        DataBuffer data = raster.getDataBuffer();
        switch (data.getDataType()) {
            case 0: {
                ret = VOIUtils.calcMinMax(signbit, mask, w, h, scanlineStride, ((DataBufferByte)data).getData(), paddingMin, paddingMax);
                break;
            }
            case 1: {
                ret = VOIUtils.calcMinMax(signbit, mask, w, h, scanlineStride, ((DataBufferUShort)data).getData(), paddingMin, paddingMax);
                break;
            }
            case 2: {
                ret = VOIUtils.calcMinMax(signbit, mask, w, h, scanlineStride, ((DataBufferShort)data).getData(), paddingMin, paddingMax);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of DataBuffer: " + raster);
            }
        }
        return ret;
    }

    static int[] calcMinMax(int signbit, int mask, int w, int h, int scanlineStride, short[] data, int paddingMin, int paddingMax) {
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        for (int x = 0; x < h; ++x) {
            int y = 0;
            int i = x * scanlineStride;
            while (y < w) {
                int val = data[i] & mask;
                if ((val & signbit) != 0) {
                    val |= ~mask;
                }
                if (val < paddingMin || val > paddingMax) {
                    if (minVal > val) {
                        minVal = val;
                    }
                    if (maxVal < val) {
                        maxVal = val;
                    }
                }
                ++y;
                ++i;
            }
        }
        return new int[]{minVal, maxVal};
    }

    static int[] calcMinMax(int signbit, int mask, int w, int h, int scanlineStride, byte[] data, int paddingMin, int paddingMax) {
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        for (int x = 0; x < h; ++x) {
            int y = 0;
            int i = x * scanlineStride;
            while (y < w) {
                int val = data[i] & mask;
                if ((val & signbit) != 0) {
                    val |= ~mask;
                }
                if (val < paddingMin || val > paddingMax) {
                    if (minVal > val) {
                        minVal = val;
                    }
                    if (maxVal < val) {
                        maxVal = val;
                    }
                }
                ++y;
                ++i;
            }
        }
        return new int[]{minVal, maxVal};
    }

    static int[] calcMinMax(DicomObject lut) {
        int[] desc = lut.getInts(2633730);
        byte[] data = lut.getBytes(2633734);
        if (desc == null) {
            throw new IllegalArgumentException("Missing LUT Descriptor!");
        }
        if (desc.length != 3) {
            throw new IllegalArgumentException("Illegal number of LUT Descriptor values: " + desc.length);
        }
        if (data == null) {
            throw new IllegalArgumentException("Missing LUT Data!");
        }
        int len = desc[0] == 0 ? 65536 : desc[0];
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        if (data.length == len) {
            for (int i = 0; i < len; ++i) {
                int val = data[i] & 0xFF;
                if (minVal > val) {
                    minVal = val;
                }
                if (maxVal >= val) continue;
                maxVal = val;
            }
        } else if (data.length == len << 1) {
            int hibyte = lut.bigEndian() ? 0 : 1;
            int lobyte = 1 - hibyte;
            int i = 0;
            int j = 0;
            while (i < len) {
                int val = (data[j + hibyte] & 0xFF) << 8 | data[j + lobyte] & 0xFF;
                if (minVal > val) {
                    minVal = val;
                }
                if (maxVal < val) {
                    maxVal = val;
                }
                ++i;
                ++j;
                ++j;
            }
        } else {
            throw new IllegalArgumentException("LUT Data length: " + data.length + " mismatch entry value: " + len + " in LUT Descriptor");
        }
        return new int[]{minVal, maxVal};
    }
}

