/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.util.Arrays;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.image.ByteLookupTable;
import org.dcm4che2.image.ShortLookupTable;
import org.dcm4che2.image.VOIUtils;
import org.dcm4che2.util.ByteUtils;
import org.dcm4che2.util.GenericNumericArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LookupTable {
    private static final Logger log = LoggerFactory.getLogger(LookupTable.class);
    public static final String LINEAR = "LINEAR";
    public static final String SIGMOID = "SIGMOID";
    private static final int OPAQUE = 255;
    protected final int inBits;
    protected final int andmask;
    protected final int ormask;
    protected final int signbit;
    protected final boolean preserve;
    protected int outBits;
    protected int off;

    protected LookupTable(int inBits, boolean signed, int off, int outBits, boolean preserve) {
        this.inBits = inBits;
        this.outBits = outBits;
        this.andmask = (1 << inBits) - 1;
        this.ormask = ~this.andmask;
        this.signbit = signed ? 1 << inBits - 1 : 0;
        this.off = (off & this.signbit) != 0 ? off | this.ormask : off;
        this.preserve = preserve;
    }

    public final int getOffset() {
        return this.off;
    }

    public abstract int length();

    public abstract byte lookupByte(int var1);

    public abstract short lookupShort(int var1);

    public abstract int lookup(int var1);

    public abstract byte[] lookup(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7);

    public abstract short[] lookup(byte[] var1, int var2, short[] var3, int var4, int var5);

    public abstract int[] lookup(byte[] var1, int var2, int[] var3, int var4, int var5, int var6);

    public abstract byte[] lookup(short[] var1, int var2, byte[] var3, int var4, int var5);

    public abstract short[] lookup(short[] var1, int var2, short[] var3, int var4, int var5);

    public abstract int[] lookup(short[] var1, int var2, int[] var3, int var4, int var5, int var6);

    public byte[] lookup(byte[] src, byte[] dst) {
        return this.lookup(src, 0, dst, 0, src.length, 1, 0);
    }

    public short[] lookup(byte[] src, short[] dst) {
        return this.lookup(src, 0, dst, 0, src.length);
    }

    public int[] lookup(byte[] src, int[] dst, int alpha) {
        return this.lookup(src, 0, dst, 0, src.length, alpha);
    }

    public byte[] lookup(short[] src, byte[] dst) {
        return this.lookup(src, 0, dst, 0, src.length);
    }

    public short[] lookup(short[] src, int srcPos, short[] dst) {
        return this.lookup(src, 0, dst, 0, src.length);
    }

    public int[] lookup(short[] src, int[] dst, int alpha) {
        return this.lookup(src, 0, dst, 0, src.length, alpha);
    }

    public void lookup(Raster src, Raster dst) {
        this.lookup(src, dst, 255);
    }

    public void lookup(Raster src, Raster dst, int alpha) {
        this.lookup(src, dst, alpha, 1, 0);
    }

    public void lookup(Raster src, Raster dst, int alpha, int channels, int skip) {
        int dstScanlineStride;
        int srcScanlineStride;
        int srcWidth = src.getWidth();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int dstHeight = dst.getHeight();
        SampleModel sourceSm = src.getSampleModel();
        SampleModel destSm = src.getSampleModel();
        if (sourceSm instanceof MultiPixelPackedSampleModel) {
            srcScanlineStride = ((MultiPixelPackedSampleModel)sourceSm).getScanlineStride();
            dstScanlineStride = ((MultiPixelPackedSampleModel)destSm).getScanlineStride();
        } else {
            srcScanlineStride = ((ComponentSampleModel)sourceSm).getScanlineStride();
            dstScanlineStride = ((ComponentSampleModel)destSm).getScanlineStride();
        }
        DataBuffer srcdata = src.getDataBuffer();
        DataBuffer dstdata = dst.getDataBuffer();
        if (srcWidth != dstWidth) {
            throw new IllegalArgumentException("src.width:" + srcWidth + " != dst.width:" + dstWidth);
        }
        if (srcHeight != dstHeight) {
            throw new IllegalArgumentException("src.height:" + srcHeight + " != dst.height:" + dstHeight);
        }
        if (srcHeight * srcScanlineStride != srcdata.getSize()) {
            throw new IllegalArgumentException("srcHeight:" + srcHeight + " * srcScanlineStride:" + srcScanlineStride + " != src.length:" + srcdata.getSize());
        }
        if (srcHeight * dstScanlineStride != dstdata.getSize()) {
            throw new IllegalArgumentException("srcHeight:" + srcHeight + " * dstScanlineStride:" + dstScanlineStride + " != dst.length:" + dstdata.getSize());
        }
        switch (dstdata.getDataType()) {
            case 0: {
                byte[][] data = ((DataBufferByte)dstdata).getBankData();
                for (int bank = 0; bank < data.length; ++bank) {
                    this.lookup(srcdata, srcWidth, srcHeight, srcScanlineStride, data[bank], dstScanlineStride, channels, skip, bank);
                }
                break;
            }
            case 1: {
                this.lookup(srcdata, srcScanlineStride, srcHeight, srcScanlineStride, ((DataBufferUShort)dstdata).getData(), dstScanlineStride);
                break;
            }
            case 2: {
                this.lookup(srcdata, srcScanlineStride, srcHeight, srcScanlineStride, ((DataBufferShort)dstdata).getData(), dstScanlineStride);
                break;
            }
            case 3: {
                this.lookup(srcdata, srcScanlineStride, srcHeight, srcScanlineStride, ((DataBufferInt)dstdata).getData(), dstScanlineStride, alpha);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Destination DataBuffer: " + dst);
            }
        }
    }

    public void lookup(DataBuffer src, int srcWidth, int srcHeight, int srcScanlineStride, byte[] dst, int dstScanlineStride, int channels, int skip, int bank) {
        if (srcScanlineStride < srcWidth * (channels + skip)) {
            srcWidth = srcScanlineStride / (channels + skip);
        }
        switch (src.getDataType()) {
            case 0: {
                this.lookup(((DataBufferByte)src).getData(bank), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride, channels, skip);
                break;
            }
            case 1: {
                this.lookup(((DataBufferUShort)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride);
                break;
            }
            case 2: {
                this.lookup(((DataBufferShort)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Source DataBuffer: " + src);
            }
        }
    }

    public void lookup(DataBuffer src, int srcWidth, int srcHeight, int srcScanlineStride, short[] dst, int dstScanlineStride) {
        switch (src.getDataType()) {
            case 0: {
                this.lookup(((DataBufferByte)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride);
                break;
            }
            case 1: {
                this.lookup(((DataBufferUShort)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride);
                break;
            }
            case 2: {
                this.lookup(((DataBufferShort)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Source DataBuffer: " + src);
            }
        }
    }

    public void lookup(DataBuffer src, int srcWidth, int srcHeight, int srcScanlineStride, int[] dst, int dstScanlineStride, int alpha) {
        switch (src.getDataType()) {
            case 0: {
                this.lookup(((DataBufferByte)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride, alpha);
                break;
            }
            case 1: {
                this.lookup(((DataBufferUShort)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride, alpha);
                break;
            }
            case 2: {
                this.lookup(((DataBufferShort)src).getData(), srcWidth, srcHeight, srcScanlineStride, dst, dstScanlineStride, alpha);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Source DataBuffer: " + src);
            }
        }
    }

    public void lookup(byte[] src, int srcWidth, int srcHeight, int srcScanlineStride, byte[] dst, int dstScanlineStride, int channels, int skip) {
        for (int y = 0; y < srcHeight; ++y) {
            this.lookup(src, y * srcScanlineStride, dst, y * dstScanlineStride, srcWidth, channels, skip);
        }
    }

    public void lookup(short[] src, int srcWidth, int srcHeight, int srcScanlineStride, byte[] dst, int dstScanlineStride) {
        for (int x = 0; x < srcHeight; ++x) {
            this.lookup(src, x * srcScanlineStride, dst, x * dstScanlineStride, srcWidth);
        }
    }

    public void lookup(byte[] src, int srcWidth, int srcHeight, int srcScanlineStride, short[] dst, int dstScanlineStride) {
        for (int x = 0; x < srcHeight; ++x) {
            this.lookup(src, x * srcScanlineStride, dst, x * dstScanlineStride, srcWidth);
        }
    }

    public void lookup(short[] src, int srcWidth, int srcHeight, int srcScanlineStride, short[] dst, int dstScanlineStride) {
        for (int x = 0; x < srcHeight; ++x) {
            this.lookup(src, x * srcScanlineStride, dst, x * dstScanlineStride, srcWidth);
        }
    }

    public void lookup(byte[] src, int srcWidth, int srcHeight, int srcScanlineStride, int[] dst, int dstScanlineStride, int alpha) {
        for (int x = 0; x < srcHeight; ++x) {
            this.lookup(src, x * srcScanlineStride, dst, x * dstScanlineStride, srcWidth, alpha);
        }
    }

    public void lookup(short[] src, int srcWidth, int srcHeight, int srcScanlineStride, int[] dst, int dstScanlineStride, int alpha) {
        for (int x = 0; x < srcHeight; ++x) {
            this.lookup(src, x * srcScanlineStride, dst, x * dstScanlineStride, srcWidth, alpha);
        }
    }

    protected abstract LookupTable scale(int var1, boolean var2, short[] var3);

    protected abstract LookupTable combine(LookupTable var1, int var2, boolean var3, short[] var4);

    protected abstract LookupTable combine(LookupTable var1, LookupTable var2, int var3, boolean var4, short[] var5);

    protected final int toIndex(int in) {
        return ((in & this.signbit) != 0 ? in | this.ormask : in & this.andmask) - this.off;
    }

    static int inBits(short[] pval2out) {
        switch (pval2out.length) {
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
        }
        throw new IllegalArgumentException("pval2out.length: " + pval2out.length + " != 2^[8..16]");
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, String vlutFct, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        log.debug("Creating a slope/intercept LUT  " + slope + "/" + intercept + " WL c/w= " + center + "/" + width);
        if (width == 0.0f || vlutFct == null || LINEAR.equals(vlutFct)) {
            return LookupTable.createRampLut(inBits, signed, outBits, slope, intercept, center, width, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
        }
        if (SIGMOID.equals(vlutFct)) {
            return LookupTable.createSigmoidLut(inBits, signed, outBits, slope, intercept, center, width, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
        }
        throw new UnsupportedOperationException("Unsupported VOI LUT function: " + vlutFct);
    }

    private static LookupTable createRampLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        int out2;
        int out1;
        int in2;
        int in1;
        log.debug("Ramp LUT " + slope + "/" + intercept + " c/w=" + center + "/" + width + " inverse " + inverse);
        if (slope < 0.0f) {
            slope = -slope;
            intercept = -intercept;
            center = 1.0f - center;
            boolean bl = inverse = !inverse;
        }
        if (width < 0.0f) {
            width = -width;
            inverse = !inverse;
        }
        int inRange = 1 << inBits;
        int inMin = signed ? -inRange / 2 : 0;
        int inMax = inMin + inRange - 1;
        if (width == 1.0f) {
            width = 2.0f;
            center = (float)Math.ceil(center);
        }
        if (width == 0.0f) {
            in1 = inMin;
            in2 = inMax;
        } else {
            float c_05 = center - 0.5f;
            float w_2 = (width - 1.0f) / 2.0f;
            in1 = (int)((c_05 - w_2 - intercept) / slope);
            in2 = (int)((c_05 + w_2 - intercept) / slope);
        }
        int off = Math.min(inMax, Math.max(in1, inMin));
        int iMax = Math.max(1, Math.max(inMin, Math.min(in2, inMax)) - off);
        int size = iMax + 1;
        int wlOff = off;
        Integer[] minMaxPixelPadding = LookupTable.getMinMaxPixelPadding(pixelPaddingValue, pixelPaddingRange);
        if (pixelPaddingValue != null) {
            off = Math.min(minMaxPixelPadding[0], off);
            if (minMaxPixelPadding[1] > size) {
                size = Math.max(size, minMaxPixelPadding[1] - off + 1);
            }
            if (minMaxPixelPadding[0] < wlOff) {
                size += wlOff - minMaxPixelPadding[0];
            }
        }
        int outBits1 = pval2out == null ? outBits : LookupTable.inBits(pval2out);
        int outRange = 1 << outBits1;
        int pval2outShift = 16 - outBits;
        if (inverse) {
            out1 = outRange - 1;
            out2 = 0;
        } else {
            out1 = 0;
            out2 = outRange - 1;
        }
        float m = (float)(out2 - out1) / (float)(in2 - in1);
        float b = (float)out1 + m * (float)(wlOff - in1) + 0.5f;
        GenericNumericArray data = null;
        data = outBits <= 8 ? GenericNumericArray.getByteArray((int)size) : GenericNumericArray.getShortArray((int)size);
        for (int i = 0; i <= iMax; ++i) {
            if (pval2out == null) {
                data.setArrayItem(i + wlOff - off, (Number)Float.valueOf(m * (float)i + b));
                continue;
            }
            data.setArrayItem(i + wlOff - off, (Number)((pval2out[(int)(m * (float)i + b)] & 0xFFFF) >>> pval2outShift));
        }
        int iMaxVal = data.getArrayItem(iMax + wlOff - off).intValue();
        if (iMax + wlOff == in2) {
            iMaxVal = pval2out == null ? out2 : (pval2out[out2] & 0xFFFF) >>> pval2outShift;
        }
        for (int i = iMax + wlOff - off; i < size; ++i) {
            data.setArrayItem(i, (Number)iMaxVal);
        }
        LookupTable.applyPixelPadding(data, out1, minMaxPixelPadding[0], minMaxPixelPadding[1], off);
        if (outBits <= 8) {
            return new ByteLookupTable(inBits, signed, off, outBits, (byte[])data.getArray());
        }
        return new ShortLookupTable(inBits, signed, off, outBits, (short[])data.getArray());
    }

    private static LookupTable createSigmoidLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        int size = 1 << inBits;
        int off = signed ? -size / 2 : 0;
        int outBits1 = pval2out == null ? outBits : LookupTable.inBits(pval2out);
        int outRange = 1 << outBits1;
        int outMax = outRange - 1;
        int pval2outShift = 16 - outBits;
        float ic = (center - intercept) / slope - (float)off;
        float k = -4.0f * slope / width;
        GenericNumericArray data = null;
        data = outBits <= 8 ? GenericNumericArray.getByteArray((int)size) : GenericNumericArray.getShortArray((int)size);
        for (int i = 0; i < size; ++i) {
            int tmp = (int)((double)outRange / (1.0 + Math.exp(((float)i - ic) * k)));
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            data.setArrayItem(i, (Number)tmp);
        }
        int padVal = inverse ? 0 : outMax;
        Integer[] minMaxPixelPadding = LookupTable.getMinMaxPixelPadding(pixelPaddingValue, pixelPaddingRange);
        LookupTable.applyPixelPadding(data, padVal, minMaxPixelPadding[0], minMaxPixelPadding[1], off);
        if (outBits <= 8) {
            return new ByteLookupTable(inBits, signed, off, outBits, (byte[])data.getArray());
        }
        return new ShortLookupTable(inBits, signed, off, outBits, (short[])data.getArray());
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, float center, float width, String vlutFct, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        log.debug("Creating MLUT WL c/w=" + center + "/" + width);
        LookupTable mlut = LookupTable.createLut(inBits, signed, mLut, null, null, inverse);
        if (width == 0.0f) {
            return mlut.scale(outBits, inverse, pval2out);
        }
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, outBits, 1.0f, 0.0f, center, width, vlutFct, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
        return mlut.combine(vlut, outBits, false, null);
    }

    private static LookupTable createLut(int inBits, boolean signed, DicomObject ds, Integer pixelPaddingValue, Integer pixelPaddingRange, boolean inverse) {
        int[] desc = ds.getInts(2633730);
        byte[] data = ds.getBytes(2633734);
        if (desc == null) {
            throw new IllegalArgumentException("Missing LUT Descriptor!");
        }
        if (desc.length != 3) {
            throw new IllegalArgumentException("Illegal number of LUT Descriptor values: " + desc.length);
        }
        if (data == null) {
            throw new IllegalArgumentException("Missing LUT Data!");
        }
        int len = desc[0] == 0 ? 65536 : desc[0];
        int off = desc[1];
        int bits = desc[2];
        if (off > 32512 && (signed || inBits < 16)) {
            off -= 65536;
        }
        if (inBits == 0) {
            off = 0;
            for (int i = len - 1; i != 0; i >>>= 1) {
                ++inBits;
            }
        }
        Integer[] minMaxPixelPadding = LookupTable.getMinMaxPixelPadding(pixelPaddingValue, pixelPaddingRange);
        if (data.length == len) {
            if (pixelPaddingValue != null) {
                int t = minMaxPixelPadding[1] - off - len;
                if (t > 0) {
                    data = Arrays.copyOf(data, len + t + 1);
                }
                GenericNumericArray array = GenericNumericArray.create((byte[])data);
                int padVal = inverse ? 255 : 0;
                LookupTable.applyPixelPadding(array, padVal, minMaxPixelPadding[0], minMaxPixelPadding[1], off);
            }
            return new ByteLookupTable(inBits, signed, off, bits, data, true);
        }
        if (data.length == len << 1) {
            short[] sdata = ds.bigEndian() ? ByteUtils.bytesBE2shorts((byte[])data) : ByteUtils.bytesLE2shorts((byte[])data);
            bits = 0;
            for (int maxVal = Math.max(sdata[0] & 0xFFFF, sdata[sdata.length - 1] & 0xFFFF); maxVal != 0; maxVal >>>= 1) {
                ++bits;
            }
            if (pixelPaddingValue != null) {
                len = sdata.length;
                int t = minMaxPixelPadding[1] - off - len;
                if (t > 0) {
                    sdata = Arrays.copyOf(sdata, len + t + 1);
                }
                GenericNumericArray array = GenericNumericArray.create((short[])sdata);
                int padVal = inverse ? 65535 : 0;
                LookupTable.applyPixelPadding(array, padVal, minMaxPixelPadding[0], minMaxPixelPadding[1], off);
            }
            ShortLookupTable ret = new ShortLookupTable(inBits, signed, off, bits, sdata, true);
            return ret;
        }
        throw new IllegalArgumentException("LUT Data length: " + data.length + " mismatch entry value: " + len + " in LUT Descriptor");
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, DicomObject voiLut, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        return LookupTable.createLut(inBits, signed, slope, intercept, voiLut, pixelPaddingValue, pixelPaddingRange, inverse).scale(outBits, inverse, pval2out);
    }

    private static LookupTable createLut(int inBits, boolean signed, float slope, float intercept, DicomObject voiLut, Integer pixelPaddingValue, Integer pixelPaddingRange, boolean inverse) {
        log.debug("Creating slope/intercept LUT with V-LUT " + slope + "/" + intercept);
        if (slope == 1.0f) {
            LookupTable lut = LookupTable.createLut(inBits, signed, voiLut, pixelPaddingValue, pixelPaddingRange, inverse);
            lut.off = (int)((float)lut.off - intercept);
            return lut;
        }
        LookupTable vlut = LookupTable.createLut(inBits, signed, voiLut, pixelPaddingValue, pixelPaddingRange, inverse);
        vlut.off = (int)((float)vlut.off - intercept);
        float in1 = (float)vlut.off / slope;
        float in2 = in1 + (float)vlut.length() / slope;
        int off = (int)Math.floor(Math.min(in1, in2));
        int len = (int)Math.ceil(Math.max(in1, in2)) - off;
        short[] data = new short[len];
        for (int i = 0; i < data.length; ++i) {
            data[i] = vlut.lookupRawShort(Math.round((float)i * slope + (float)off));
        }
        GenericNumericArray dataArray = GenericNumericArray.create((short[])data);
        Integer[] minMaxPixelPadding = LookupTable.getMinMaxPixelPadding(pixelPaddingValue, pixelPaddingRange);
        LookupTable.applyPixelPadding(dataArray, 0, minMaxPixelPadding[0], minMaxPixelPadding[1], off);
        return new ShortLookupTable(inBits, signed, off, vlut.outBits, (short[])dataArray.getArray());
    }

    public abstract short lookupRawShort(int var1);

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, String vlutFct, DicomObject pLut, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        log.debug("Creating LUT for slope/intercept=" + slope + "/" + intercept + " center/width=" + center + "/" + width);
        LookupTable plut = LookupTable.createLut(0, false, pLut, null, null, inverse);
        LookupTable vlut = LookupTable.createLut(inBits, signed, plut.inBits, slope, intercept, center, width, vlutFct, false, null, pixelPaddingValue, pixelPaddingRange);
        return vlut.combine(plut, outBits, inverse, pval2out);
    }

    @Deprecated
    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, String vlutFct, DicomObject pLut, boolean inverse, short[] pval2out) {
        return LookupTable.createLut(inBits, signed, outBits, slope, intercept, center, width, vlutFct, pLut, inverse, pval2out, null, null);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, DicomObject voiLut, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        log.debug("Creating a combined m/v LUT, assuming MLUT output is unsigned.");
        LookupTable mlut = LookupTable.createLut(inBits, signed, mLut, null, null, inverse);
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, voiLut, pixelPaddingValue, pixelPaddingRange, inverse);
        return mlut.combine(vlut, outBits, inverse, pval2out);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, DicomObject voiLut, DicomObject pLut, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        LookupTable vlut = LookupTable.createLut(inBits, signed, slope, intercept, voiLut, pixelPaddingValue, pixelPaddingRange, inverse);
        LookupTable plut = LookupTable.createLut(0, false, pLut, null, null, inverse);
        return vlut.combine(plut, outBits, inverse, pval2out);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, float center, float width, String vlutFct, DicomObject pLut, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        LookupTable mlut = LookupTable.createLut(inBits, signed, mLut, null, null, inverse);
        LookupTable plut = LookupTable.createLut(0, false, pLut, null, null, inverse);
        if (width == 0.0f) {
            return mlut.combine(plut, outBits, inverse, pval2out);
        }
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, plut.inBits, 1.0f, 0.0f, center, width, vlutFct, false, null, pixelPaddingValue, pixelPaddingRange);
        return mlut.combine(vlut, plut, outBits, inverse, pval2out);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, DicomObject voiLut, DicomObject pLut, boolean inverse, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        LookupTable mlut = LookupTable.createLut(inBits, signed, mLut, null, null, inverse);
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, voiLut, pixelPaddingValue, pixelPaddingRange, inverse);
        LookupTable plut = LookupTable.createLut(0, false, pLut, null, null, inverse);
        return mlut.combine(vlut, plut, outBits, inverse, pval2out);
    }

    public static LookupTable createLutForImage(DicomObject img, int outBits, short[] pval2out) {
        return LookupTable.createLutForImageWithPR(img, null, 1, 0.0f, 0.0f, null, outBits, pval2out);
    }

    @Deprecated
    public static LookupTable createLutFromWL(DicomObject img, DicomObject mLut, float center, float width, String vlutFct, boolean inverse, int outBits, short[] pval2out) {
        return LookupTable.createLutFromWL(img, mLut, center, width, vlutFct, inverse, outBits, pval2out, null, null);
    }

    public static LookupTable createLutFromWL(DicomObject img, DicomObject mLut, float center, float width, String vlutFct, boolean inverse, int outBits, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        int allocated = img.getInt(2621696, 8);
        int stored = img.getInt(2621697, allocated);
        boolean signed = img.getInt(2621699) != 0;
        float slope = mLut.getFloat(2625619, 1.0f);
        float intercept = mLut.getFloat(2625618, 0.0f);
        DicomObject tableMLut = VOIUtils.getLUT(mLut, 2633728);
        if (tableMLut != null) {
            return LookupTable.createLut(stored, signed, outBits, tableMLut, center, width, vlutFct, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
        }
        return LookupTable.createLut(stored, signed, outBits, slope, intercept, center, width, vlutFct, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
    }

    private static boolean isInverse(DicomObject img) {
        String shape = img.getString(0x20500020);
        return shape != null ? "INVERSE".equals(shape) : "MONOCHROME1".equals(img.getString(2621444));
    }

    @Deprecated
    public static LookupTable createLutFromVOISequence(DicomObject img, DicomObject mLut, DicomObject voiLut, boolean inverse, int outBits, short[] pval2out) {
        return LookupTable.createLutFromVOISequence(img, mLut, voiLut, inverse, outBits, pval2out, null, null);
    }

    public static LookupTable createLutFromVOISequence(DicomObject img, DicomObject mLut, DicomObject voiLut, boolean inverse, int outBits, short[] pval2out, Integer pixelPaddingValue, Integer pixelPaddingRange) {
        int allocated = img.getInt(2621696, 8);
        int stored = img.getInt(2621697, allocated);
        boolean signed = img.getInt(2621699) != 0;
        float slope = mLut.getFloat(2625619, 1.0f);
        float intercept = mLut.getFloat(2625618, 0.0f);
        DicomObject tableMLut = VOIUtils.getLUT(img, 2633728);
        if (tableMLut != null) {
            return LookupTable.createLut(stored, signed, outBits, tableMLut, voiLut, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
        }
        return LookupTable.createLut(stored, signed, outBits, slope, intercept, voiLut, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
    }

    public static LookupTable createLutForImageWithPR(DicomObject img, DicomObject pr, int frame, float center, float width, String vlutFct, int outBits, short[] pval2out) {
        DicomObject mlutObj = VOIUtils.selectModalityLUTObject(img, pr, frame);
        DicomObject voiObj = VOIUtils.selectVoiObject(img, pr, frame);
        boolean inverse = pr != null ? "INVERSE".equals(pr.getString(0x20500020)) : LookupTable.isInverse(img);
        DicomObject pLut = pr != null ? VOIUtils.getLUT(pr, 542113808) : null;
        return LookupTable.createLutForImage(img, mlutObj, voiObj, pLut, center, width, vlutFct, inverse, outBits, pval2out);
    }

    public static Integer getIntPixelValue(DicomObject ds, int tag, boolean signed, int stored) {
        DicomElement de = ds.get(tag);
        if (de == null) {
            return null;
        }
        VR vr = de.vr();
        if (vr == VR.OB || vr == VR.OW) {
            int ret = ByteUtils.bytesLE2ushort((byte[])de.getBytes(), (int)0);
            if (signed && (ret & 1 << stored - 1) != 0) {
                int andmask = (1 << stored) - 1;
                int ormask = ~andmask;
                ret |= ormask;
            }
            return ret;
        }
        return de.getInt(true);
    }

    public static LookupTable createLutForImage(DicomObject img, DicomObject mlutObj, DicomObject voiObj, DicomObject pLut, float center, float width, String vlutFct, boolean inverse, int outBits, short[] pval2out) {
        DicomObject voiLut;
        int allocated = img.getInt(2621696, 8);
        int stored = img.getInt(2621697, allocated);
        boolean signed = img.getInt(2621699) != 0;
        float slope = mlutObj.getFloat(2625619, 1.0f);
        float intercept = mlutObj.getFloat(2625618, 0.0f);
        Integer pixelPaddingValue = LookupTable.getIntPixelValue(img, 2621728, signed, stored);
        Integer pixelPaddingRange = LookupTable.getIntPixelValue(img, 2621729, signed, stored);
        DicomObject mLut = VOIUtils.getLUT(mlutObj, 2633728);
        DicomObject dicomObject = voiLut = voiObj != null && vlutFct == null ? VOIUtils.getLUT(voiObj, 2633744) : null;
        if (voiLut == null && width == 0.0f && voiObj != null) {
            vlutFct = LookupTable.getVlutFct(voiObj);
            center = voiObj.getFloat(2625616, 0.0f);
            width = voiObj.getFloat(2625617, 0.0f);
        }
        if (mLut == null) {
            if (voiLut == null) {
                if (pLut == null) {
                    return LookupTable.createLut(stored, signed, outBits, slope, intercept, center, width, vlutFct, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
                }
                return LookupTable.createLut(stored, signed, outBits, slope, intercept, center, width, vlutFct, pLut, false, pval2out, pixelPaddingValue, pixelPaddingRange);
            }
            if (pLut == null) {
                return LookupTable.createLut(stored, signed, outBits, slope, intercept, voiLut, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
            }
            return LookupTable.createLut(stored, signed, outBits, slope, intercept, voiLut, pLut, false, pval2out, pixelPaddingValue, pixelPaddingRange);
        }
        if (voiLut == null) {
            if (pLut == null) {
                return LookupTable.createLut(stored, signed, outBits, mLut, center, width, vlutFct, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
            }
            return LookupTable.createLut(stored, signed, outBits, mLut, center, width, vlutFct, pLut, false, pval2out, pixelPaddingValue, pixelPaddingRange);
        }
        if (pLut == null) {
            return LookupTable.createLut(stored, signed, outBits, mLut, voiLut, inverse, pval2out, pixelPaddingValue, pixelPaddingRange);
        }
        return LookupTable.createLut(stored, signed, outBits, mLut, voiLut, pLut, false, pval2out, pixelPaddingValue, pixelPaddingRange);
    }

    private static void applyPixelPadding(GenericNumericArray array, int padValue, Integer minPad, Integer maxPad, int offset) {
        if (minPad == null) {
            return;
        }
        if (minPad - offset < 0) {
            log.warn("Error in calculation of offset wrt pixel padding data. pixel padding range from " + minPad + " to " + maxPad + ", offset=" + offset);
            minPad = offset;
        }
        if (maxPad - offset + 1 < 0) {
            return;
        }
        if (minPad - offset > array.length()) {
            return;
        }
        array.fillRange(minPad - offset, maxPad - offset + 1, (Number)padValue);
    }

    public static Integer[] getMinMaxPixelPadding(Integer pixelPaddingValue, Integer pixelPaddingRange) {
        Integer[] info = new Integer[2];
        if (pixelPaddingValue == null) {
            return info;
        }
        Integer minPad = pixelPaddingValue;
        Integer maxPad = pixelPaddingValue;
        if (pixelPaddingRange != null) {
            if (pixelPaddingRange > pixelPaddingValue) {
                maxPad = pixelPaddingRange;
            } else {
                minPad = pixelPaddingRange;
            }
        }
        info[0] = minPad;
        info[1] = maxPad;
        return info;
    }

    private static String getVlutFct(DicomObject voiObj) {
        String vlutFct = voiObj.getString(2625622);
        if (vlutFct != null && vlutFct.trim().length() > 0 && !vlutFct.equals(SIGMOID) && !vlutFct.equals(LINEAR)) {
            vlutFct = new String(voiObj.getBytes(2625622));
            vlutFct = vlutFct.trim();
        }
        return vlutFct;
    }
}

