/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.janino.JavaSourceClassLoader;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class CachingJavaSourceClassLoader
extends JavaSourceClassLoader {
    private final ResourceFinder classFileCacheResourceFinder;
    private final ResourceCreator classFileCacheResourceCreator;
    private final ResourceFinder sourceFinder;

    public CachingJavaSourceClassLoader(ClassLoader classLoader, ResourceFinder resourceFinder, String string, ResourceFinder resourceFinder2, ResourceCreator resourceCreator, EnumeratorSet enumeratorSet) {
        super(classLoader, resourceFinder, string, enumeratorSet);
        this.classFileCacheResourceFinder = resourceFinder2;
        this.classFileCacheResourceCreator = resourceCreator;
        this.sourceFinder = resourceFinder;
    }

    public CachingJavaSourceClassLoader(ClassLoader classLoader, File[] fileArray, String string, File file, EnumeratorSet enumeratorSet) {
        this(classLoader, fileArray == null ? new DirectoryResourceFinder(new File(".")) : new PathResourceFinder(fileArray), string, new DirectoryResourceFinder(file), new DirectoryResourceCreator(file), enumeratorSet);
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Object object;
        Object object2;
        block19: {
            byte[] byArray;
            Resource resource = this.classFileCacheResourceFinder.findResource(ClassFile.getClassFileResourceName(string));
            if (resource == null) break block19;
            object2 = this.sourceFinder.findResource(ClassFile.getSourceResourceName(string));
            if (object2 == null) {
                throw new ClassNotFoundException(string);
            }
            if (object2.lastModified() >= resource.lastModified()) break block19;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = resource.open();
                    byArray = CachingJavaSourceClassLoader.readInputStream(inputStream);
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException("Reading class file from \"" + resource + "\"", iOException);
                }
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return this.defineBytecode(string, byArray);
        }
        if ((object2 = this.generateBytecodes(string)) == null) {
            throw new ClassNotFoundException(string);
        }
        Iterator iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object var10_15;
            object = iterator.next();
            String string2 = (String)object.getKey();
            byte[] byArray = (byte[])object.getValue();
            OutputStream outputStream = null;
            try {
                try {
                    outputStream = this.classFileCacheResourceCreator.createResource(ClassFile.getClassFileResourceName(string2));
                    outputStream.write(byArray);
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException("Writing class file to \"" + ClassFile.getClassFileResourceName(string2) + "\"", iOException);
                }
                var10_15 = null;
                if (outputStream == null) continue;
            }
            catch (Throwable throwable) {
                var10_15 = null;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        object = this.defineBytecodes(string, (Map)object2);
        if (object == null) {
            throw new RuntimeException("Scanning, parsing and compiling class \"" + string + "\" did not create a class file!?");
        }
        return object;
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CachingJavaSourceClassLoader.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

