/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Escapable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.PropertyFactoryImpl;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class Property
extends Content {
    public static final String PRODID = "PRODID";
    public static final String VERSION = "VERSION";
    public static final String CALSCALE = "CALSCALE";
    public static final String METHOD = "METHOD";
    public static final String CLASS = "CLASS";
    public static final String CREATED = "CREATED";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String DTSTART = "DTSTART";
    public static final String GEO = "GEO";
    public static final String LAST_MODIFIED = "LAST-MODIFIED";
    public static final String LOCATION = "LOCATION";
    public static final String ORGANIZER = "ORGANIZER";
    public static final String PERCENT_COMPLETE = "PERCENT-COMPLETE";
    public static final String PRIORITY = "PRIORITY";
    public static final String DTSTAMP = "DTSTAMP";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String STATUS = "STATUS";
    public static final String SUMMARY = "SUMMARY";
    public static final String TRANSP = "TRANSP";
    public static final String UID = "UID";
    public static final String URL = "URL";
    public static final String RECURRENCE_ID = "RECURRENCE-ID";
    public static final String COMPLETED = "COMPLETED";
    public static final String DUE = "DUE";
    public static final String FREEBUSY = "FREEBUSY";
    public static final String TZID = "TZID";
    public static final String TZNAME = "TZNAME";
    public static final String TZOFFSETFROM = "TZOFFSETFROM";
    public static final String TZOFFSETTO = "TZOFFSETTO";
    public static final String TZURL = "TZURL";
    public static final String ACTION = "ACTION";
    public static final String REPEAT = "REPEAT";
    public static final String TRIGGER = "TRIGGER";
    public static final String REQUEST_STATUS = "REQUEST-STATUS";
    public static final String DTEND = "DTEND";
    public static final String DURATION = "DURATION";
    public static final String ATTACH = "ATTACH";
    public static final String ATTENDEE = "ATTENDEE";
    public static final String CATEGORIES = "CATEGORIES";
    public static final String COMMENT = "COMMENT";
    public static final String CONTACT = "CONTACT";
    public static final String EXDATE = "EXDATE";
    public static final String EXRULE = "EXRULE";
    public static final String RELATED_TO = "RELATED-TO";
    public static final String RESOURCES = "RESOURCES";
    public static final String RDATE = "RDATE";
    public static final String RRULE = "RRULE";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    private String name;
    private ParameterList parameters;

    protected Property(String aName) {
        this(aName, new ParameterList());
    }

    protected Property(String aName, ParameterList aList) {
        this.name = aName;
        this.parameters = aList;
    }

    protected Property(Property property) throws IOException, URISyntaxException, ParseException {
        this.name = property.getName();
        this.parameters = new ParameterList(property.getParameters(), false);
        this.setValue(property.getValue());
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(this.getParameters());
        buffer.append(':');
        if (this instanceof Escapable) {
            buffer.append(Strings.escape(Strings.valueOf(this.getValue())));
        } else {
            buffer.append(Strings.valueOf(this.getValue()));
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    public boolean isCalendarProperty() {
        return PRODID.equalsIgnoreCase(this.getName()) || VERSION.equalsIgnoreCase(this.getName()) || CALSCALE.equalsIgnoreCase(this.getName()) || METHOD.equalsIgnoreCase(this.getName());
    }

    public final boolean isComponentProperty() {
        return false;
    }

    public final String getName() {
        return this.name;
    }

    public final ParameterList getParameters() {
        return this.parameters;
    }

    public final ParameterList getParameters(String name) {
        return this.getParameters().getParameters(name);
    }

    public final Parameter getParameter(String name) {
        return this.getParameters().getParameter(name);
    }

    public abstract void setValue(String var1) throws IOException, URISyntaxException, ParseException;

    public abstract String getValue();

    public abstract void validate() throws ValidationException;

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Property) {
            Property p = (Property)arg0;
            return ObjectUtils.equals((Object)this.getName(), (Object)p.getName()) && ObjectUtils.equals((Object)this.getValue(), (Object)p.getValue()) && ObjectUtils.equals((Object)this.getParameters(), (Object)p.getParameters());
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName().toUpperCase()).append((Object)this.getValue()).append((Object)this.getParameters()).toHashCode();
    }

    public Property copy() throws IOException, URISyntaxException, ParseException {
        ParameterList params = new ParameterList(this.getParameters(), false);
        return PropertyFactoryImpl.getInstance().createProperty(this.getName(), params, this.getValue());
    }
}

