/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import java.io.File;
import org.artofsolving.jodconverter.office.OfficeConnectionProtocol;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeUtils;
import org.artofsolving.jodconverter.office.ProcessPoolOfficeManager;
import org.artofsolving.jodconverter.office.UnoUrl;
import org.artofsolving.jodconverter.process.LinuxProcessManager;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.PureJavaProcessManager;
import org.artofsolving.jodconverter.process.SigarProcessManager;
import org.artofsolving.jodconverter.util.PlatformUtils;

public class DefaultOfficeManagerConfiguration {
    public static final long DEFAULT_RETRY_TIMEOUT = 120000L;
    private File officeHome = OfficeUtils.getDefaultOfficeHome();
    private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
    private int[] portNumbers = new int[]{2002};
    private String[] pipeNames = new String[]{"office"};
    private String[] runAsArgs = null;
    private File templateProfileDir = null;
    private File workDir = new File(System.getProperty("java.io.tmpdir"));
    private long taskQueueTimeout = 30000L;
    private long taskExecutionTimeout = 120000L;
    private int maxTasksPerProcess = 200;
    private long retryTimeout = 120000L;
    private ProcessManager processManager = null;

    public DefaultOfficeManagerConfiguration setOfficeHome(String officeHome) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("officeHome", officeHome);
        return this.setOfficeHome(new File(officeHome));
    }

    public DefaultOfficeManagerConfiguration setOfficeHome(File officeHome) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("officeHome", officeHome);
        this.checkArgument("officeHome", officeHome.isDirectory(), "must exist and be a directory");
        this.officeHome = officeHome;
        return this;
    }

    public DefaultOfficeManagerConfiguration setConnectionProtocol(OfficeConnectionProtocol connectionProtocol) throws NullPointerException {
        this.checkArgumentNotNull("connectionProtocol", (Object)connectionProtocol);
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public DefaultOfficeManagerConfiguration setPortNumber(int portNumber) {
        this.portNumbers = new int[]{portNumber};
        return this;
    }

    public DefaultOfficeManagerConfiguration setPortNumbers(int ... portNumbers) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("portNumbers", portNumbers);
        this.checkArgument("portNumbers", portNumbers.length > 0, "must not be empty");
        this.portNumbers = portNumbers;
        return this;
    }

    public DefaultOfficeManagerConfiguration setPipeName(String pipeName) throws NullPointerException {
        this.checkArgumentNotNull("pipeName", pipeName);
        this.pipeNames = new String[]{pipeName};
        return this;
    }

    public DefaultOfficeManagerConfiguration setPipeNames(String ... pipeNames) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("pipeNames", pipeNames);
        this.checkArgument("pipeNames", pipeNames.length > 0, "must not be empty");
        this.pipeNames = pipeNames;
        return this;
    }

    public DefaultOfficeManagerConfiguration setRunAsArgs(String ... runAsArgs) {
        this.runAsArgs = runAsArgs;
        return this;
    }

    public DefaultOfficeManagerConfiguration setTemplateProfileDir(File templateProfileDir) throws IllegalArgumentException {
        if (templateProfileDir != null) {
            this.checkArgument("templateProfileDir", templateProfileDir.isDirectory(), "must exist and be a directory");
        }
        this.templateProfileDir = templateProfileDir;
        return this;
    }

    public DefaultOfficeManagerConfiguration setWorkDir(File workDir) {
        this.checkArgumentNotNull("workDir", workDir);
        this.workDir = workDir;
        return this;
    }

    public DefaultOfficeManagerConfiguration setTaskQueueTimeout(long taskQueueTimeout) {
        this.taskQueueTimeout = taskQueueTimeout;
        return this;
    }

    public DefaultOfficeManagerConfiguration setTaskExecutionTimeout(long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout;
        return this;
    }

    public DefaultOfficeManagerConfiguration setMaxTasksPerProcess(int maxTasksPerProcess) {
        this.maxTasksPerProcess = maxTasksPerProcess;
        return this;
    }

    public DefaultOfficeManagerConfiguration setProcessManager(ProcessManager processManager) throws NullPointerException {
        this.checkArgumentNotNull("processManager", processManager);
        this.processManager = processManager;
        return this;
    }

    public DefaultOfficeManagerConfiguration setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public OfficeManager buildOfficeManager() throws IllegalStateException {
        if (this.officeHome == null) {
            throw new IllegalStateException("officeHome not set and could not be auto-detected");
        }
        if (!this.officeHome.isDirectory()) {
            throw new IllegalStateException("officeHome doesn't exist or is not a directory: " + this.officeHome);
        }
        if (!OfficeUtils.getOfficeExecutable(this.officeHome).isFile()) {
            throw new IllegalStateException("invalid officeHome: it doesn't contain soffice.bin: " + this.officeHome);
        }
        if (this.templateProfileDir != null && !this.isValidProfileDir(this.templateProfileDir)) {
            throw new IllegalStateException("templateProfileDir doesn't appear to contain a user profile: " + this.templateProfileDir);
        }
        if (!this.workDir.isDirectory()) {
            throw new IllegalStateException("workDir doesn't exist or is not a directory: " + this.workDir);
        }
        if (this.processManager == null) {
            this.processManager = this.findBestProcessManager();
        }
        int numInstances = this.connectionProtocol == OfficeConnectionProtocol.PIPE ? this.pipeNames.length : this.portNumbers.length;
        UnoUrl[] unoUrls = new UnoUrl[numInstances];
        int i = 0;
        while (i < numInstances) {
            unoUrls[i] = this.connectionProtocol == OfficeConnectionProtocol.PIPE ? UnoUrl.pipe(this.pipeNames[i]) : UnoUrl.socket(this.portNumbers[i]);
            ++i;
        }
        return new ProcessPoolOfficeManager(this.officeHome, unoUrls, this.runAsArgs, this.templateProfileDir, this.workDir, this.retryTimeout, this.taskQueueTimeout, this.taskExecutionTimeout, this.maxTasksPerProcess, this.processManager);
    }

    private ProcessManager findBestProcessManager() {
        if (this.isSigarAvailable()) {
            return new SigarProcessManager();
        }
        if (PlatformUtils.isLinux()) {
            LinuxProcessManager processManager = new LinuxProcessManager();
            if (this.runAsArgs != null) {
                processManager.setRunAsArgs(this.runAsArgs);
            }
            return processManager;
        }
        return new PureJavaProcessManager();
    }

    private boolean isSigarAvailable() {
        try {
            Class.forName("org.hyperic.sigar.Sigar", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void checkArgumentNotNull(String argName, Object argValue) throws NullPointerException {
        if (argValue == null) {
            throw new NullPointerException(String.valueOf(argName) + " must not be null");
        }
    }

    private void checkArgument(String argName, boolean condition, String message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(String.valueOf(argName) + " " + message);
        }
    }

    private boolean isValidProfileDir(File profileDir) {
        return new File(profileDir, "user").isDirectory();
    }
}

