/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.javagroups.protocols;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;

public class EVENT_TRACE
extends Protocol {
    private String name = "EVENT_TRACE";
    private Logger log;

    public String getName() {
        return this.name;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.name = props.getProperty("name", this.name);
        this.log = Logger.getLogger((String)("org.jboss.jgroups." + this.name));
        return true;
    }

    public void up(Event event) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("up, event=" + event));
            if (event.getType() == 1) {
                Message msg = (Message)event.getArg();
                msg.getHeaders();
                this.log.trace((Object)("up, MsgHeader: " + this.printEventMsg(msg)));
            }
        }
        this.passUp(event);
    }

    public void down(Event event) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("down, event=" + event));
            if (event.getType() == 1) {
                Message msg = (Message)event.getArg();
                this.log.trace((Object)("down, MsgHeader: " + this.printEventMsg(msg)));
            }
        }
        this.passDown(event);
    }

    public String printEventMsg(Message msg) {
        StringBuffer sb = new StringBuffer();
        Map headers = msg.getHeaders();
        if (headers != null) {
            Iterator iter = headers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                sb.append(key);
                sb.append(", value(");
                sb.append(value.getClass());
                sb.append("): ");
                sb.append(value.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

