/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.jndi.HAJNDI;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.server.NamingServer;

public class TreeHead
extends NamingServer
implements Serializable,
Naming {
    private static final long serialVersionUID = 6342802270002172451L;
    private static Logger log = Logger.getLogger((Class)TreeHead.class);
    private transient HAPartition partition;
    private transient HAJNDI father;

    public void init() throws Exception {
        log.debug((Object)"registerRPCHandler");
        this.partition.registerRPCHandler("HAJNDI", this);
    }

    public void stop() throws Exception {
    }

    public void destroy() throws Exception {
        log.debug((Object)"unregisterRPCHandler");
        this.partition.unregisterRPCHandler("HAJNDI", this);
    }

    public void setPartition(HAPartition partition) {
        this.partition = partition;
    }

    public void setHARMIHead(HAJNDI father) {
        this.father = father;
    }

    public void _bind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("_bind, name=" + name));
        }
        super.bind(name, obj, className);
    }

    public void bind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("bind, name=" + name));
        }
        super.bind(name, obj, className);
        Object[] args = new Object[]{name, obj, className};
        try {
            this.partition.callMethodOnCluster("HAJNDI", "_bind", args, new Class[]{Name.class, Object.class, String.class}, true);
        }
        catch (Exception e) {
            CommunicationException ce = new CommunicationException("Failed to _bind on cluster");
            ce.setRootCause(e);
            throw ce;
        }
    }

    public void _rebind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("_rebind, name=" + name));
        }
        super.rebind(name, obj, className);
    }

    public void rebind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("rebind, name=" + name));
        }
        super.rebind(name, obj, className);
        Object[] args = new Object[]{name, obj, className};
        try {
            this.partition.callMethodOnCluster("HAJNDI", "_rebind", args, new Class[]{Name.class, Object.class, String.class}, true);
        }
        catch (Exception e) {
            CommunicationException ce = new CommunicationException("Failed to _rebind on cluster");
            ce.setRootCause(e);
            throw ce;
        }
    }

    public void _unbind(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.debug((Object)("_unbind, name=" + name));
        }
        super.unbind(name);
    }

    public void unbind(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("unbind, name=" + name));
        }
        super.unbind(name);
        Object[] args = new Object[]{name};
        try {
            this.partition.callMethodOnCluster("HAJNDI", "_unbind", args, new Class[]{Name.class}, true);
        }
        catch (Exception e) {
            CommunicationException ce = new CommunicationException("Failed to _unbind on cluster");
            ce.setRootCause(e);
            throw ce;
        }
    }

    public Object lookup(Name name) throws NamingException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookup, name=" + name));
        }
        Object result = null;
        try {
            result = super.lookup(name);
        }
        catch (NameNotFoundException ex) {
            try {
                result = this.lookupLocally(name);
            }
            catch (NameNotFoundException nnfe) {
                Object[] args = new Object[]{name};
                ArrayList rsp = null;
                Exception cause = null;
                try {
                    if (trace) {
                        log.trace((Object)("calling lookupLocally(" + name + ") on cluster"));
                    }
                    rsp = this.partition.callMethodOnCluster("HAJNDI", "lookupLocally", args, new Class[]{Name.class}, true);
                }
                catch (Exception ignored) {
                    if (trace) {
                        log.trace((Object)("Clusterd lookupLocally(" + name + ") failed"), (Throwable)ignored);
                    }
                    cause = ignored;
                }
                if (trace) {
                    log.trace((Object)("Returned results size: " + (rsp != null ? rsp.size() : 0)));
                }
                if (rsp == null || rsp.size() == 0) {
                    NameNotFoundException nnfe2 = new NameNotFoundException(name.toString());
                    nnfe2.setRootCause(cause);
                    throw nnfe2;
                }
                for (int i = 0; i < rsp.size(); ++i) {
                    result = rsp.get(i);
                    if (trace) {
                        String type = result != null ? result.getClass().getName() : "null";
                        log.trace((Object)("_lookupLocally, i=" + i + ", value=" + result + ", type=" + type));
                    }
                    if (result == null || result instanceof Exception) continue;
                    return result;
                }
                throw nnfe;
            }
        }
        return result;
    }

    public Object _lookupLocally(Name name) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("_lookupLocally, name=" + name));
        }
        try {
            return this.lookupLocally(name);
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"_lookupLocally failed", (Throwable)e);
            }
            return e;
        }
    }

    public Object lookupLocally(Name name) throws NamingException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookupLocally, name=" + name));
        }
        try {
            if (NamingContext.localServer != null) {
                return NamingContext.localServer.lookup(name);
            }
            InitialContext ctx = new InitialContext();
            return ctx.lookup(name);
        }
        catch (NamingException e) {
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw e;
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException("unknown remote exception");
            ne.setRootCause(e);
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw ne;
        }
        catch (RuntimeException e) {
            if (trace) {
                log.trace((Object)("lookupLocally failed, name=" + name), (Throwable)e);
            }
            throw e;
        }
    }

    protected ArrayList enum2list(NamingEnumeration en) {
        ArrayList rtn = new ArrayList();
        try {
            while (en.hasMore()) {
                rtn.add(en.next());
            }
            en.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return rtn;
    }

    public Collection list(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("list, name=" + name));
        }
        Collection result = null;
        try {
            result = super.list(name);
        }
        catch (NameNotFoundException ex) {
            result = this.enum2list(new InitialContext().list(name));
        }
        return result;
    }

    public Collection listBindings(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("listBindings, name=" + name));
        }
        Collection result = null;
        try {
            result = super.listBindings(name);
        }
        catch (NameNotFoundException ex) {
            result = this.enum2list(new InitialContext().listBindings(name));
        }
        return result;
    }

    public Context _createSubcontext(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("_createSubcontext, name=" + name));
        }
        return super.createSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("createSubcontext, name=" + name));
        }
        Context result = super.createSubcontext(name);
        Object[] args = new Object[]{name};
        try {
            this.partition.callMethodOnCluster("HAJNDI", "_createSubcontext", args, new Class[]{Name.class}, true);
        }
        catch (Exception e) {
            CommunicationException ce = new CommunicationException("Failed to _createSubcontext on cluster");
            ce.setRootCause(e);
            throw ce;
        }
        return result;
    }

    public Naming getRoot() {
        return this.father.getHAStub();
    }
}

