/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.Serializable;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.EntityInstanceCache;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.metadata.ClusterConfigMetaData;
import org.jboss.system.Registry;

public class ClusterSyncEntityInstanceCache
extends EntityInstanceCache
implements DistributedState.DSListenerEx {
    protected DistributedState ds = null;
    protected String DS_CATEGORY = null;

    public void create() throws Exception {
        super.create();
        ClusterConfigMetaData config = this.getContainer().getBeanMetaData().getClusterConfigMetaData();
        String partitionName = config.getPartitionName();
        String name = "jboss:service=DistributedState,partitionName=" + partitionName;
        this.ds = (DistributedState)Registry.lookup((Object)name);
        if (this.ds == null) {
            throw new DeploymentException("Failed to find DistributedState service: " + name);
        }
    }

    public void start() throws Exception {
        super.start();
        String ejbName = this.getContainer().getBeanMetaData().getEjbName();
        this.DS_CATEGORY = "CMPClusteredInMemoryPersistenceManager-" + ejbName;
        this.ds.registerDSListenerEx(this.DS_CATEGORY, this);
    }

    public void stop() {
        super.stop();
        this.ds.unregisterDSListenerEx(this.DS_CATEGORY, this);
    }

    public void keyHasBeenRemoved(String category, Serializable key, Serializable previousContent, boolean locallyModified) {
        if (!locallyModified) {
            this.cacheMiss((String)((Object)key));
        }
    }

    public void valueHasChanged(String category, Serializable key, Serializable value, boolean locallyModified) {
        if (!locallyModified) {
            this.cacheMiss((String)((Object)key));
        }
    }

    public void cacheMiss(String key) {
        try {
            this.remove(key);
        }
        catch (Exception e) {
            log.warn((Object)"failed to remove key", (Throwable)e);
        }
    }
}

