/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class ColoredCheckBox
extends JCheckBox {
    private boolean drawBackground;
    private Color bgColor;
    private ColorCheckBoxIcon cbi;
    private boolean big;
    private static final long serialVersionUID = 1L;

    public ColoredCheckBox(String text, Color c, boolean big, boolean drawBackground) {
        super(text);
        this.drawBackground = drawBackground;
        this.big = big;
        this.setOpaque(false);
        this.setColor(c);
    }

    public ColoredCheckBox(String text, Color c, boolean big) {
        this(text, c, big, false);
    }

    public ColoredCheckBox(String text, Color c) {
        this(text, c, false, false);
    }

    public void setColor(Color c) {
        this.bgColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), 50);
        this.cbi = new ColorCheckBoxIcon(c, this.big);
        this.setIcon(this.cbi);
    }

    public void setSelected(boolean b) {
        super.setSelected(b);
        this.model.setSelected(b);
    }

    protected void paintComponent(Graphics g) {
        if (this.drawBackground) {
            g.setColor(this.bgColor);
            g.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 8, 8);
        }
        super.paintComponent(g);
    }

    public class ColorCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private Color color;
        private boolean big;
        private static final long serialVersionUID = 1L;

        public ColorCheckBoxIcon(Color color, boolean bigCheck) {
            this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 120);
            this.big = bigCheck;
        }

        protected int getControlSize() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            int controlSize = this.getControlSize();
            boolean drawCheck = model.isSelected();
            if (model.isEnabled()) {
                g.setColor(this.color);
                g.fillRoundRect(x, y + 1, controlSize - 1, controlSize - 1, 3, 3);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, controlSize - 1, controlSize - 1);
            }
            if (drawCheck) {
                g.setColor(Color.DARK_GRAY);
                if (this.big) {
                    this.drawBigCheck(c, g, x, y);
                } else {
                    this.drawCheck(c, g, x, y);
                }
            }
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        protected void drawBigCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect((x += 2) + 2, y + 3, 3, controlSize - 4);
            g.drawLine(x + controlSize, y - 2, x + 5, y + (controlSize - 7));
            g.drawLine(x + controlSize, y - 2, x + 5, y + (controlSize - 6));
            g.drawLine(x + controlSize, y - 2, x + 5, y + (controlSize - 5));
            g.drawLine(x + controlSize, y - 2, x + 5, y + (controlSize - 4));
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

