/*
 * Decompiled with CFR 0.152.
 */
package bizcal.web;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.util.DateInterval;
import bizcal.web.WebCalendarCallback;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ecs.Element;
import org.apache.ecs.html.Font;
import org.apache.ecs.html.Script;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;

public abstract class CalendarView {
    private CalendarViewConfig config;
    private CalendarModel _callback;
    private DateInterval interval;
    private WebCalendarCallback webCallback;

    public DateInterval getInterval() {
        return this.interval;
    }

    public void setInterval(DateInterval interval) {
        this.interval = interval;
    }

    public void setDescriptor(CalendarViewConfig desc) {
        CalendarViewConfig calD = desc;
        this.setCalendarCallback(calD.getCallback());
    }

    public void setCalendarCallback(CalendarModel callback) {
        this._callback = callback;
    }

    protected CalendarModel getCalendarCallback() {
        return this._callback;
    }

    public abstract Element getContent() throws Exception;

    protected String fixLength(String str, int len) {
        if (str.length() > len) {
            return str.substring(0, len);
        }
        int i = str.length();
        while (i < len) {
            str = String.valueOf(str) + "&nbsp;";
            ++i;
        }
        return str;
    }

    public TD createCell(Event event, DateInterval interval, Calendar cal, Date time) throws Exception {
        TD td = new TD();
        Font font = new Font();
        td.addElement((Element)font);
        font.addElement(event.getSummary());
        td.setBgColor(this.toHTML(event.getColor()));
        if (event.isEditable()) {
            td.setOnClick("openOld('eventid=" + event.getId() + "')");
            td.setOnMouseOver("this.style.cursor='pointer'");
        } else if (event.isBackground()) {
            td.setOnClick(this.getOpenNewStatement(cal, time));
        }
        DateInterval eventInterv = new DateInterval(event.getStart(), event.getEnd());
        if (interval.getStartDate().after(eventInterv.getStartDate())) {
            eventInterv.setStartDate(interval.getStartDate());
        }
        if (interval.getEndDate().before(eventInterv.getEndDate())) {
            eventInterv.setEndDate(interval.getEndDate());
        }
        if (!event.isBackground()) {
            int span = (int)(eventInterv.getDuration() / this.getResolution());
            td.setRowSpan(span);
        }
        return td;
    }

    public TD createFreeCell(Calendar cal, Date time) throws Exception {
        TD td = new TD();
        td.setBgColor(this.toHTML(cal.getColor()));
        if (cal.isBlankIsAvailible()) {
            td.setOnClick(this.getOpenNewStatement(cal, time));
            td.setOnMouseOver("this.style.cursor='pointer'");
        }
        return td;
    }

    private String getOpenNewStatement(Calendar cal, Date time) throws Exception {
        String startParam = this.getWebCallback().getStarttimeParamName();
        String calParam = this.getWebCallback().getCalendarParamName();
        String href_new = String.valueOf(calParam) + "=" + cal.getId();
        href_new = String.valueOf(href_new) + "&" + startParam;
        href_new = String.valueOf(href_new) + "=\\\"" + time.getTime() + "\\\"";
        return "openNew('" + href_new + "')";
    }

    public Script getScript() throws Exception {
        Script script = new Script();
        script.setLanguage("JavaScript");
        String eventFormId = "newEvent";
        String url = this.getWebCallback().getDetailURL();
        StringBuffer str = new StringBuffer();
        str.append("function openNew(keys)\n");
        str.append("{\n");
        str.append("\thref = '" + url + "?detail=true&popup=true&' + keys;\n");
        str.append("\twindow.open(href, 'detail');\n");
        str.append("}\n");
        str.append("function openOld(keys)\n");
        str.append("{\n");
        str.append("\thref = '" + url + "?detail=true&popup=true&' + keys;\n");
        str.append("\twindow.open(href, 'detail');\n");
        str.append("}\n");
        script.addElement(str.toString());
        return script;
    }

    protected List createSlots(List events, DateInterval interval) throws Exception {
        int noOfSlots = (int)(interval.getDuration() / this.getResolution());
        ArrayList<Event> slots = new ArrayList<Event>(noOfSlots);
        int i = 0;
        while (i < noOfSlots) {
            slots.add(null);
            ++i;
        }
        for (Event event : events) {
            long time = event.getStart().getTime();
            int slotno = this.getSlotNo(time, interval);
            while (time < event.getEnd().getTime()) {
                if (slotno >= 0 && slotno < noOfSlots) {
                    Event slotEvent = (Event)slots.get(slotno);
                    if (slotEvent != null) {
                        if (slotEvent.getLevel() < event.getLevel()) {
                            slots.set(slotno, event);
                        }
                    } else {
                        slots.set(slotno, event);
                    }
                }
                time += this.getResolution();
                ++slotno;
            }
        }
        return slots;
    }

    public int getSlotNo(long date, DateInterval interval) throws Exception {
        long time = date - interval.getStartDate().getTime();
        return (int)(time / this.getResolution());
    }

    protected long getResolution() throws Exception {
        return this.getCalendarCallback().getResolution();
    }

    private String toHTML(Color color) {
        StringBuffer str = new StringBuffer();
        str.append("#");
        str.append(Integer.toString(color.getRed(), 16));
        str.append(Integer.toString(color.getGreen(), 16));
        str.append(Integer.toString(color.getBlue(), 16));
        return str.toString();
    }

    public void setStartDate(Date date) throws Exception {
        this.setInterval(new DateInterval(date, 6));
    }

    protected TR createHeaderRow() throws Exception {
        TR tr = new TR();
        return tr;
    }

    protected TH createHeaderCell(String str) throws Exception {
        TH th = new TH();
        Font font = new Font();
        font.addElement(str);
        th.addElement((Element)font);
        return th;
    }

    public void setWebCallback(WebCalendarCallback webCallback) {
        this.webCallback = webCallback;
    }

    protected WebCalendarCallback getWebCallback() {
        return this.webCallback;
    }

    protected CalendarViewConfig getConfig() {
        return this.config;
    }

    protected CalendarModel getModel() {
        return this._callback;
    }
}

