/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import bizcal.common.Event;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameArea
extends JComponent
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private String itsHeadLine;
    private String itsDescription;
    private Color fontColor;
    private List<Listener> listeners = new ArrayList<Listener>();
    private boolean border;
    private boolean roundedRectangle;
    private boolean selected;
    private ImageIcon icon;
    private ImageIcon upperRightIcon;
    private Date endTime = null;
    private Date startTime = null;
    private boolean isMoving = false;
    private String movingString = "";
    private Date moveDate;
    private Event event = null;
    private List<FrameArea> children = null;
    private Color bgColor;
    public double xPosition = 0.0;
    public double yPosition = 54.0;
    private Color alphaFontColor;
    private Font normalFont;
    private float ALPHA_DEFAULT = 0.6f;
    private float SELECT_OFFSET = 0.2f;
    private float alphaValue = this.ALPHA_DEFAULT;
    private int lineDistance = 4;
    private static int HEADER_HEIGHT = 20;
    private boolean showHeader = true;
    private int lineWrap = -1;
    private boolean isBackgroundMarker = false;
    private int boundX;
    private int boundY;
    private int boundWidth;
    private int boundHeight;
    private static Color backgroundMarkColor = new Color(205, 207, 255);
    public final DateFormat timeFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());

    public FrameArea() {
        this.normalFont = new Font("Verdana", 0, 10);
        this.setFont(this.normalFont);
        this.setBackground(new Color(100, 100, 245));
        this.alphaFontColor = this.fontColor = Color.WHITE;
        this.border = true;
        this.roundedRectangle = true;
        this.selected = false;
        this.addComponentListener(this);
    }

    public FrameArea(boolean backgroundMarker) {
        this();
        this.isBackgroundMarker = backgroundMarker;
        if (this.isBackgroundMarker) {
            this.setBackground(backgroundMarkColor);
        }
    }

    public void setEvent(Event event) {
        this.event = event;
        if (this.event != null) {
            this.bgColor = event.getColor();
        }
        this.fontColor = this.event != null && this.event.isBackground() ? Color.BLACK : FrameArea.computeForeground(this.bgColor);
        this.alphaFontColor = new Color(this.fontColor.getRed(), this.fontColor.getGreen(), this.fontColor.getBlue(), 220);
        try {
            this.setBackground(event.getColor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Event getEvent() {
        return this.event;
    }

    public void addChild(FrameArea fa) {
        if (this.children == null) {
            this.children = Collections.synchronizedList(new ArrayList(1));
        }
        this.children.add(fa);
    }

    public void removeChild(FrameArea fa) {
        if (this.children != null) {
            this.children.remove(fa);
        }
    }

    public List<FrameArea> getChildren() {
        if (this.children == null) {
            this.children = Collections.synchronizedList(new ArrayList(0));
        }
        return this.children;
    }

    public void setIsMoving(boolean b) {
        this.isMoving = b;
    }

    public synchronized void setMovingTimeString(Date moveStartDate, Date moveEndDate) {
        this.moveDate = (Date)moveStartDate.clone();
        this.movingString = String.valueOf(this.timeFormat.format(this.moveDate)) + " - " + this.timeFormat.format(moveEndDate);
    }

    public void setEndTime(Date endTime) {
        this.endTime = (Date)endTime.clone();
    }

    public void setStartTime(Date startTime) {
        this.startTime = (Date)startTime.clone();
    }

    @Deprecated
    public void setAlphaValue(float aValue) {
        if (aValue > 1.0f) {
            aValue = 1.0f;
        }
    }

    public float getAlphaValue() {
        return this.alphaValue;
    }

    private synchronized String getMovingTimeString() {
        return this.movingString;
    }

    @Override
    public void paint(Graphics g) {
        AlphaComposite ac;
        Color backGroundColor = this.getBackground();
        Color headerColor = this.getBackground();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.event != null) {
            backGroundColor = this.event.getColor();
            headerColor = this.event.getColor();
        }
        if (this.event != null && this.event.isBackground()) {
            headerColor = Color.LIGHT_GRAY;
            this.alphaValue = this.ALPHA_DEFAULT + this.SELECT_OFFSET - 0.55f;
        }
        if (!this.getBackground().equals(backGroundColor)) {
            this.setBackground(backGroundColor);
        }
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D graphicBuffImgHandle = bufferedImage.createGraphics();
        graphicBuffImgHandle.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphicBuffImgHandle.setStroke(new BasicStroke(1.0f));
        Composite compositeDefault = graphicBuffImgHandle.getComposite();
        if (this.isBackgroundMarker) {
            this.event.setSelectable(false);
            this.event.setBackground(true);
            AlphaComposite ac2 = null;
            ac2 = AlphaComposite.getInstance(4, this.alphaValue);
            graphicBuffImgHandle.setComposite(ac2);
            graphicBuffImgHandle.setPaint(this.getBackground());
            graphicBuffImgHandle.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
            g2.drawImage(bufferedImage, null, 0, 0);
            return;
        }
        if (this.roundedRectangle || this.event != null && this.event.get("eventProposalState") != null && ((Boolean)this.event.get("eventProposalState")).booleanValue()) {
            ac = AlphaComposite.getInstance(4, this.alphaValue);
            graphicBuffImgHandle.setComposite(ac);
            graphicBuffImgHandle.setPaint(this.getBackground());
            graphicBuffImgHandle.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, 20.0, 20.0));
            graphicBuffImgHandle.setPaint(headerColor);
            if (this.showHeader) {
                graphicBuffImgHandle.fill(new RoundRectangle2D.Double(0.0, 0.0, width, 20.0, 20.0, 20.0));
            }
            graphicBuffImgHandle.fill(new RoundRectangle2D.Double(0.0, height - 18, width, 18.0, 20.0, 20.0));
            if (this.border && (this.event == null || !this.event.isBackground())) {
                graphicBuffImgHandle.setComposite(compositeDefault);
                graphicBuffImgHandle.setPaint(Color.DARK_GRAY);
                graphicBuffImgHandle.draw(new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, 18.0, 18.0));
            }
        } else {
            ac = null;
            ac = AlphaComposite.getInstance(4, this.alphaValue);
            graphicBuffImgHandle.setComposite(ac);
            graphicBuffImgHandle.setPaint(this.getBackground());
            graphicBuffImgHandle.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
            graphicBuffImgHandle.setPaint(headerColor);
            if (this.showHeader) {
                graphicBuffImgHandle.fill(new Rectangle2D.Double(0.0, 0.0, width, 20.0));
            }
            graphicBuffImgHandle.fill(new Rectangle2D.Double(0.0, height - 18, width, 18.0));
            if (this.border && this.event != null) {
                graphicBuffImgHandle.setComposite(compositeDefault);
                graphicBuffImgHandle.setPaint(Color.GRAY);
                graphicBuffImgHandle.draw(new Rectangle2D.Double(1.0, 1.0, width - 2, height - 2));
            }
        }
        int xpos = 5;
        if (this.icon != null) {
            graphicBuffImgHandle.drawImage(this.icon.getImage(), xpos, 2, this);
            xpos += this.icon.getIconWidth() + 3;
        }
        if (this.upperRightIcon != null) {
            graphicBuffImgHandle.drawImage(this.upperRightIcon.getImage(), this.getWidth() - 20, 2, this);
        }
        if (this.event == null || !this.event.isBackground()) {
            graphicBuffImgHandle.setPaint(this.fontColor);
        } else {
            graphicBuffImgHandle.setPaint(this.alphaFontColor);
        }
        Font timeFont = this.getFont().deriveFont(1);
        graphicBuffImgHandle.setFont(timeFont);
        int ypos = 15;
        if (this.itsHeadLine != null) {
            graphicBuffImgHandle.drawString(this.itsHeadLine, xpos, ypos);
            ypos += 15;
            xpos = 5;
        }
        if (this.itsDescription != null) {
            Font descriptionFont = this.getFont();
            int fontHeight = (int)descriptionFont.getSize2D();
            graphicBuffImgHandle.setFont(descriptionFont);
            FontMetrics fontMetrics = graphicBuffImgHandle.getFontMetrics();
            if (this.showHeader && this.itsHeadLine == null) {
                ypos = HEADER_HEIGHT + 15;
            }
            int splitWidth = this.getWidth() - 15;
            if (this.lineWrap < 0 || fontMetrics.stringWidth(this.itsDescription.substring(0, this.lineWrap)) < splitWidth - 15 || fontMetrics.stringWidth(this.itsDescription.substring(0, this.lineWrap)) > splitWidth) {
                String s = this.itsDescription;
                this.lineWrap = s.length();
                while (fontMetrics.stringWidth(s) > splitWidth && this.lineWrap > -1) {
                    s = this.itsDescription.substring(0, this.lineWrap);
                    --this.lineWrap;
                }
                if (this.lineWrap < 0) {
                    this.lineWrap = 0;
                }
            }
            int yposString = ypos;
            int posInStr = 0;
            int posOfNL = 0;
            String pieceStr = null;
            int count = 0;
            String newStr = this.itsDescription;
            while (posInStr < this.itsDescription.length()) {
                posOfNL = newStr.indexOf("\n");
                if (posOfNL == -1) {
                    posOfNL = newStr.length();
                } else {
                    ++count;
                    ++posOfNL;
                }
                pieceStr = newStr.substring(0, posOfNL);
                int pos = 0;
                while (pos < pieceStr.length() && this.lineWrap > 0) {
                    if (yposString > this.getHeight() - 18) break;
                    if (pos + this.lineWrap >= pieceStr.length()) {
                        graphicBuffImgHandle.drawString(pieceStr.substring(pos, pieceStr.length()).trim(), xpos, yposString);
                    } else {
                        try {
                            graphicBuffImgHandle.drawString(pieceStr.substring(pos, pos + this.lineWrap).trim(), xpos, yposString);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        yposString = yposString + fontHeight + 5;
                    }
                    pos += this.lineWrap;
                }
                yposString = yposString + fontHeight + 5;
                if (posOfNL != newStr.length()) {
                    newStr = newStr.substring(posOfNL, newStr.length());
                }
                posInStr += posOfNL;
            }
        }
        if (this.isMoving) {
            graphicBuffImgHandle.setFont(timeFont);
            graphicBuffImgHandle.drawString(this.getMovingTimeString(), xpos + this.getBounds().width - 85, ypos + this.getBounds().height - 35);
        } else if (this.startTime != null && this.endTime != null) {
            String s = String.valueOf(this.timeFormat.format(this.startTime)) + " - " + this.timeFormat.format(this.endTime);
            graphicBuffImgHandle.drawString(s, xpos + this.getBounds().width - 85, ypos + this.getBounds().height - 35);
        }
        if (this.selected) {
            graphicBuffImgHandle.setPaint(Color.black);
            graphicBuffImgHandle.setStroke(new BasicStroke(1.5f));
            if (this.roundedRectangle) {
                graphicBuffImgHandle.draw(new RoundRectangle2D.Double(1.0, 1.0, width - 3, height - 3, 18.0, 18.0));
            } else {
                graphicBuffImgHandle.draw(new Rectangle2D.Double(1.0, 1.0, width - 3, height - 3));
            }
        }
        if (this.event != null && this.event.get("eventProposalState") != null && ((Boolean)this.event.get("eventProposalState")).booleanValue()) {
            graphicBuffImgHandle.setPaint(Color.red);
            graphicBuffImgHandle.setStroke(new BasicStroke(1.5f));
            graphicBuffImgHandle.draw(new RoundRectangle2D.Double(1.0, 1.0, width - 3, height - 3, 18.0, 18.0));
        }
        g2.drawImage(bufferedImage, null, 0, 0);
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void setRoundedRectangle(boolean rounded) {
        this.roundedRectangle = rounded;
    }

    public boolean isRoundedRectangle() {
        return this.roundedRectangle;
    }

    public void setHeadLine(String aHeadLine) {
        this.itsHeadLine = aHeadLine;
        if (aHeadLine == null) {
            this.itsHeadLine = "";
        }
    }

    public void setDescription(String aDescription) {
        this.itsDescription = aDescription;
        if (aDescription == null) {
            this.itsDescription = "";
        }
    }

    public void setFontColor(Color aColor) {
        this.fontColor = aColor;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void setSelected(boolean flag) {
        this.selected = flag;
        this.setBrightness(flag);
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setBrightness(boolean b) {
        this.alphaValue = b ? this.ALPHA_DEFAULT + this.SELECT_OFFSET : this.ALPHA_DEFAULT - this.SELECT_OFFSET;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public ImageIcon getUpperRightIcon() {
        return this.upperRightIcon;
    }

    public void setUpperRightIcon(ImageIcon upperRightIcon) {
        this.upperRightIcon = upperRightIcon;
    }

    public void setLineDistance(int dst) {
        this.lineDistance = dst;
    }

    public int getLineDistance() {
        return this.lineDistance;
    }

    public void showHeader(boolean b) {
        this.showHeader = b;
    }

    public void commitBounds() {
        super.setBounds(this.boundX, this.boundY, this.boundWidth, this.boundHeight);
    }

    public void drawHatchedRect(Graphics g, int x, int y, int width, int height, boolean round) {
        int DST = this.lineDistance;
        if (round) {
            g.drawRoundRect(x, y, width, height, 20, 20);
        } else {
            g.drawRect(x, y, width, height);
        }
        int i = DST;
        while (i < width + height) {
            int p1x = i <= height ? x : x + i - height;
            int p1y = i <= height ? y + i : y + height;
            int p2x = i <= width ? x + i : x + width;
            int p2y = i <= width ? y : y + i - width;
            g.drawLine(p1x, p1y, p2x, p2y);
            i += DST;
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static Color computeForeground(Color bg) {
        if (bg == null) {
            return Color.WHITE;
        }
        int[] labWhite = new int[3];
        int[] labBlack = new int[3];
        int[] labBg = new int[3];
        FrameArea.rgb2lab(Color.WHITE.getRed(), Color.WHITE.getGreen(), Color.WHITE.getBlue(), labWhite);
        FrameArea.rgb2lab(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue(), labBlack);
        FrameArea.rgb2lab(bg.getRed(), bg.getGreen(), bg.getBlue(), labBg);
        int deltaBgWhite = FrameArea.deltaE(labBg, labWhite);
        int deltaBgBlack = FrameArea.deltaE(labBg, labBlack);
        if (deltaBgBlack > deltaBgWhite) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    private static int deltaE(int[] lab1, int[] lab2) {
        int deltaE = 0;
        double deltaL = lab2[0] - lab1[0];
        double deltaA = lab2[1] - lab1[1];
        double deltaB = lab2[2] - lab1[2];
        deltaE = (int)Math.sqrt(Math.pow(deltaL, 2.0) + Math.pow(deltaA, 2.0) + Math.pow(deltaB, 2.0));
        return deltaE;
    }

    public static void rgb2lab(int R, int G, int B, int[] lab) {
        float eps = 0.008856452f;
        float k = 903.2963f;
        float Xr = 0.964221f;
        float Yr = 1.0f;
        float Zr = 0.825211f;
        float r = (float)R / 255.0f;
        float g = (float)G / 255.0f;
        float b = (float)B / 255.0f;
        r = (double)r <= 0.04045 ? (r /= 12.0f) : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g = (double)g <= 0.04045 ? (g /= 12.0f) : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.04045 ? (b /= 12.0f) : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        float X = 0.43605202f * r + 0.3850816f * g + 0.14308742f * b;
        float Y = 0.22249159f * r + 0.71688604f * g + 0.060621485f * b;
        float Z = 0.013929122f * r + 0.097097f * g + 0.7141855f * b;
        float xr = X / Xr;
        float yr = Y / Yr;
        float zr = Z / Zr;
        float fx = xr > eps ? (float)Math.pow(xr, 0.3333333333333333) : (float)(((double)(k * xr) + 16.0) / 116.0);
        float fy = yr > eps ? (float)Math.pow(yr, 0.3333333333333333) : (float)(((double)(k * yr) + 16.0) / 116.0);
        float fz = zr > eps ? (float)Math.pow(zr, 0.3333333333333333) : (float)(((double)(k * zr) + 16.0) / 116.0);
        float Ls = 116.0f * fy - 16.0f;
        float as = 500.0f * (fx - fy);
        float bs = 200.0f * (fy - fz);
        lab[0] = (int)(2.55 * (double)Ls + 0.5);
        lab[1] = (int)((double)as + 0.5);
        lab[2] = (int)((double)bs + 0.5);
    }

    public static interface Listener
    extends EventListener {
        public void selected(FrameArea var1) throws Exception;

        public void mouseOver(FrameArea var1) throws Exception;

        public void mouseOut(FrameArea var1) throws Exception;

        public void popupMenu(FrameArea var1) throws Exception;

        public void moved(Point var1, Point var2) throws Exception;
    }
}

