/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.CalendarViewConfig;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.DayView;
import bizcal.swing.util.GradientArea;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeLabelPanel {
    private JPanel panel;
    private List<JLabel> hourLabels = new ArrayList<JLabel>();
    private List<JLabel> minuteLabels = new ArrayList<JLabel>();
    private List<JLabel> hourLines = new ArrayList<JLabel>();
    private List<JLabel> minuteLines = new ArrayList<JLabel>();
    private Font font = new Font("Verdana", 0, 11);
    private GradientArea gradientArea;
    private int width = 40;
    private int hourCount;
    private int footerHeight = 0;
    private CalendarViewConfig config;
    private TimeOfDay start;
    private TimeOfDay end;
    private SimpleDateFormat hourFormat;
    private Font hourFont;
    private int timeslots;

    public TimeLabelPanel(CalendarViewConfig config, TimeOfDay start, TimeOfDay end, int timeslots) throws Exception {
        this.config = config;
        this.start = start;
        this.end = end;
        this.timeslots = timeslots;
        this.panel = new JPanel();
        this.panel.setLayout(new Layout());
        this.hourFormat = new SimpleDateFormat("HH");
        this.hourFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.hourFont = this.font.deriveFont(12.0f);
        this.hourFont = this.hourFont.deriveFont(1);
        this.refresh();
    }

    public void refresh() {
        try {
            this.hourCount = this.end.getHour() - this.start.getHour();
            if (this.hourCount == 0) {
                this.hourCount = 24;
            }
            this.hourLabels.clear();
            this.minuteLabels.clear();
            this.hourLines.clear();
            this.minuteLines.clear();
            this.panel.removeAll();
            long pos = this.start.getValue();
            while (pos < this.end.getValue()) {
                Date date = new Date(pos);
                String timeTxt = this.hourFormat.format(date);
                JLabel timeLabel = new JLabel(timeTxt);
                timeLabel.setVerticalTextPosition(0);
                timeLabel.setFont(this.hourFont);
                this.panel.add(timeLabel);
                this.hourLabels.add(timeLabel);
                JLabel line = new JLabel();
                line.setBackground(this.config.getLineColor());
                line.setOpaque(true);
                this.panel.add(line);
                this.hourLines.add(line);
                switch (this.timeslots) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.createTimeLabel("30");
                        this.createMinuteLine();
                        break;
                    }
                    case 3: {
                        this.createTimeLabel("20");
                        this.createTimeLabel("40");
                        this.createMinuteLine();
                        this.createMinuteLine();
                        break;
                    }
                    case 4: {
                        this.createTimeLabel("30");
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        break;
                    }
                    case 6: {
                        this.createTimeLabel("20");
                        this.createTimeLabel("40");
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        this.createMinuteLine();
                        break;
                    }
                }
                pos += 3600000L;
            }
            this.gradientArea = new GradientArea("LEFT_RIGHT", Color.WHITE, ColumnHeaderPanel.GRADIENT_COLOR);
            this.gradientArea.setOpaque(true);
            this.gradientArea.setBorder(false);
            this.panel.add(this.gradientArea);
            this.panel.validate();
            this.panel.updateUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JLabel createTimeLabel(String time) {
        JLabel timeLabel = new JLabel(time);
        timeLabel.setFont(this.font);
        this.panel.add(timeLabel);
        this.minuteLabels.add(timeLabel);
        return timeLabel;
    }

    private void createMinuteLine() {
        JLabel line = new JLabel();
        line.setBackground(this.config.getLineColor());
        line.setOpaque(true);
        this.minuteLines.add(line);
        this.panel.add(line);
    }

    public void setStartEnd(TimeOfDay start, TimeOfDay end, int timeslots) {
        this.start = start;
        this.end = end;
        this.timeslots = timeslots;
        this.refresh();
    }

    private int getPreferredHeight() {
        return DayView.PIXELS_PER_HOUR * this.hourCount + this.footerHeight;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setFooterHeight(int footerHeight) {
        this.footerHeight = footerHeight;
    }

    private class Layout
    implements LayoutManager {
        private int colWidth;
        private double rowHeight;

        private Layout() {
            this.colWidth = TimeLabelPanel.this.width / 2;
            this.rowHeight = 0.0;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(TimeLabelPanel.this.width, TimeLabelPanel.this.getPreferredHeight());
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(50, 50);
        }

        public void layoutContainer(Container parent) {
            try {
                double totHeight = parent.getHeight() - TimeLabelPanel.this.footerHeight;
                this.rowHeight = totHeight / (double)TimeLabelPanel.this.hourCount;
                double minuteRowHeight = this.rowHeight / 2.0;
                this.colWidth = TimeLabelPanel.this.width / 2;
                Integer iMinute = 0;
                int iLine = 0;
                int i = 0;
                while (i < TimeLabelPanel.this.hourLabels.size()) {
                    JLabel hourLabel = (JLabel)TimeLabelPanel.this.hourLabels.get(i);
                    hourLabel.setBounds(0, (int)((double)i * this.rowHeight) - 7, this.colWidth, 15);
                    JLabel hourLine = (JLabel)TimeLabelPanel.this.hourLines.get(i);
                    hourLine.setBounds(this.colWidth, (int)((double)(i + 1) * this.rowHeight), TimeLabelPanel.this.width, 1);
                    switch (TimeLabelPanel.this.timeslots) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            iMinute = this.layoutMinuteLabel(i, iMinute);
                            iLine = this.layoutMinuteLine(i, iLine);
                            break;
                        }
                        case 3: {
                            iMinute = this.layoutMinuteLabel(i, iMinute, (int)(this.rowHeight / 6.0), (int)(this.rowHeight / 6.0 * 2.0));
                            iMinute = this.layoutMinuteLabel(i, iMinute, (int)(this.rowHeight / 6.0 * 3.0), (int)(this.rowHeight / 6.0 * 2.0));
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 3.0), 10);
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 3.0 * 2.0), 10);
                            break;
                        }
                        case 4: {
                            iMinute = this.layoutMinuteLabel(i, iMinute);
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 4.0), 10);
                            iLine = this.layoutMinuteLine(i, iLine);
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 4.0 * 3.0), 10);
                            break;
                        }
                        case 6: {
                            iMinute = this.layoutMinuteLabel(i, iMinute, (int)(this.rowHeight / 6.0), (int)(this.rowHeight / 6.0 * 2.0));
                            iMinute = this.layoutMinuteLabel(i, iMinute, (int)(this.rowHeight / 6.0 * 3.0), (int)(this.rowHeight / 6.0 * 2.0));
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 6.0), 10);
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 6.0 * 2.0), 5);
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 6.0 * 3.0), 10);
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 6.0 * 4.0), 5);
                            iLine = this.layoutMinuteLine(i, iLine, (int)(this.rowHeight / 6.0 * 5.0), 10);
                            break;
                        }
                    }
                    ++i;
                }
                TimeLabelPanel.this.gradientArea.setBounds(0, 0, parent.getWidth(), parent.getHeight());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private int layoutMinuteLabel(int hourPosition, int minutePosition) {
            return this.layoutMinuteLabel(hourPosition, minutePosition, 0, (int)this.rowHeight);
        }

        private int layoutMinuteLabel(int hourPosition, int minutePosition, int yInside, int height) {
            JLabel minuteLabel = (JLabel)TimeLabelPanel.this.minuteLabels.get(minutePosition);
            minuteLabel.setBounds(this.colWidth - 15, (int)((double)hourPosition * this.rowHeight) + yInside, this.colWidth, height);
            return ++minutePosition;
        }

        private int layoutMinuteLine(int hourPosition, int linePostion) {
            return this.layoutMinuteLine(hourPosition, linePostion, (int)(this.rowHeight / 2.0), 5);
        }

        private int layoutMinuteLine(int hourPosition, int linePostion, int yInside, int length) {
            JLabel minuteLine = (JLabel)TimeLabelPanel.this.minuteLines.get(linePostion);
            minuteLine.setBounds(this.colWidth + length, (int)((double)hourPosition * this.rowHeight + (double)yInside), this.colWidth, 1);
            return ++linePostion;
        }
    }
}

