/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.swing.CalendarListener;
import bizcal.swing.PopupMenuCallback;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.ResourceIcon;
import bizcal.swing.util.TrueGridLayout;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.LocaleBroker;
import bizcal.util.TextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ColumnHeaderPanel {
    public static final Color GRADIENT_COLOR = new Color(230, 230, 230);
    private PopupMenuCallback popupMenuCallback;
    private JPanel panel;
    private List calHeaders = new ArrayList();
    private List dateHeaders = new ArrayList();
    private List dateHeaders2 = new ArrayList();
    private List dateList = new ArrayList();
    private List dateLines = new ArrayList();
    private GradientArea gradientArea;
    private JLabel referenceLabel = new JLabel("AAA");
    private int rowCount;
    private int dayCount;
    private CalendarModel model;
    private Color lineColor = Color.LIGHT_GRAY;
    private int fixedDayCount = -1;
    private CalendarListener listener;
    private boolean showExtraDateHeaders = false;
    private CalendarViewConfig config;
    private boolean isMonthView = false;
    private static Font headerFont = new Font("Arial", 0, 12);
    private static Color todayColor = new Color(111, 236, 82);
    private static Color sundayColor = new Color(255, 106, 106);

    public ColumnHeaderPanel(CalendarViewConfig config) {
        this.config = config;
        this.panel = new JPanel();
        this.panel.setLayout(new Layout());
        this.gradientArea = new GradientArea("TOP_BOTTOM", Color.WHITE, GRADIENT_COLOR);
        this.gradientArea.setBorder(false);
    }

    public ColumnHeaderPanel(CalendarViewConfig config, int fixedDayCount) {
        this(config);
        this.fixedDayCount = fixedDayCount;
    }

    public void refresh() throws Exception {
        this.calHeaders.clear();
        this.dateHeaders.clear();
        this.dateHeaders2.clear();
        this.dateList.clear();
        this.dateLines.clear();
        this.panel.removeAll();
        java.util.Calendar calendar = DateUtil.newCalendar();
        this.dayCount = DateUtil.getDateDiff(this.model.getInterval().getEndDate(), this.model.getInterval().getStartDate());
        if (this.fixedDayCount > 0) {
            this.dayCount = this.fixedDayCount;
        }
        int calCount = this.model.getSelectedCalendars().size();
        if (this.dayCount >= 1 || calCount > 1) {
            this.rowCount = this.dayCount > 1 && calCount > 1 ? 2 : 1;
            SimpleDateFormat toolTipFormat = new SimpleDateFormat("EEEE d MMMM", LocaleBroker.getLocale());
            int j = 0;
            while (j < calCount) {
                Calendar cal = (Calendar)this.model.getSelectedCalendars().get(j);
                if (calCount >= 1) {
                    JLabel headerLabel = new JLabel(cal.getSummary(), 0);
                    headerLabel.addMouseListener(new CalHeaderMouseListener(cal.getId()));
                    headerLabel.setCursor(new Cursor(12));
                    JComponent header = headerLabel;
                    if (cal.isCloseable()) {
                        JPanel panel = new JPanel();
                        panel.setOpaque(false);
                        panel.setLayout(new BorderLayout());
                        panel.add((Component)headerLabel, "Center");
                        JLabel iconLabel = new JLabel(new ResourceIcon("/bizcal/res/cancel.gif"));
                        iconLabel.addMouseListener(new CloseListener(cal.getId()));
                        panel.add((Component)iconLabel, "East");
                        header = panel;
                    }
                    this.calHeaders.add(header);
                    this.panel.add(header);
                }
                JPanel dateHeaderPanel = new JPanel();
                dateHeaderPanel.setLayout(new TrueGridLayout(1, this.dayCount));
                dateHeaderPanel.setOpaque(false);
                Date date = this.model.getInterval().getStartDate();
                if (this.fixedDayCount > 0) {
                    date = DateUtil.round2Week(date);
                }
                int i = 0;
                while (i < this.dayCount) {
                    String dateStr = "";
                    dateStr = this.dayCount == 1 ? TextUtil.formatCase(this.config.getDayFormat().format(date)) : (this.isMonthView ? this.config.getMonthDateFormat().format(date) : this.config.getWeekDateFormat().format(date));
                    JLabel header = new JLabel(dateStr, 0);
                    header.setAlignmentY(2.0f);
                    header.setToolTipText(toolTipFormat.format(date));
                    header.setFont(headerFont);
                    if (this.model.isRedDay(date)) {
                        header.setBackground(sundayColor);
                        header.setBorder(BorderFactory.createLineBorder(sundayColor.darker()));
                        header.setOpaque(true);
                    }
                    this.dateHeaders.add(header);
                    this.panel.add(header);
                    if (this.showExtraDateHeaders) {
                        JLabel header2 = new JLabel(this.model.getDateHeader(cal.getId(), date), 0);
                        this.dateHeaders2.add(header2);
                        this.panel.add(header2);
                    }
                    this.dateList.add(date);
                    if (i > 0 || j > 0) {
                        JLabel line = new JLabel();
                        line.setBackground(this.lineColor);
                        line.setOpaque(true);
                        line.setBackground(this.lineColor);
                        if (DateUtil.getDayOfWeek(date) == calendar.getFirstDayOfWeek()) {
                            line.setBackground(this.config.getLineColor2());
                        }
                        if (this.model.getSelectedCalendars().size() > 1 && i == 0) {
                            line.setBackground(this.config.getLineColor3());
                        }
                        this.panel.add(line);
                        this.dateLines.add(line);
                    }
                    date = DateUtil.getDiffDay(date, 1);
                    ++i;
                }
                ++j;
            }
        } else {
            this.rowCount = 0;
        }
        if (this.showExtraDateHeaders) {
            ++this.rowCount;
        }
        this.panel.add(this.gradientArea);
        this.panel.updateUI();
    }

    public JComponent getComponent() {
        return this.panel;
    }

    private void resizeDates(int width) throws Exception {
        Date today = DateUtil.round2Day(new Date());
        int charCount = 12;
        FontMetrics metrics = this.referenceLabel.getFontMetrics(this.referenceLabel.getFont());
        if (this.maxWidth(charCount, metrics) > width && this.maxWidth(charCount = 3, metrics) > width && this.maxWidth(charCount = 2, metrics) > width) {
            charCount = 1;
        }
        int i = 0;
        while (i < this.dateHeaders.size()) {
            JLabel label = (JLabel)this.dateHeaders.get(i);
            Date date = (Date)this.dateList.get(i);
            String str = "";
            str = this.isMonthView ? this.config.getMonthDateFormat().format(date) : this.config.getWeekDateFormat().format(date);
            if (str.length() > charCount) {
                str = str.substring(0, charCount);
            }
            str = TextUtil.formatCase(str);
            if (today.equals(DateUtil.round2Day(date))) {
                str = "<html><b>" + str + "</b> </html>";
                label.setBackground(todayColor);
                label.setBorder(BorderFactory.createLineBorder(todayColor.darker()));
                label.setOpaque(true);
            }
            label.setText(str);
            ++i;
        }
    }

    private int maxWidth(int charCount, FontMetrics metrics) {
        SimpleDateFormat format = new SimpleDateFormat("EEEEE", LocaleBroker.getLocale());
        java.util.Calendar cal = DateUtil.newCalendar();
        cal.set(7, 1);
        int maxWidth = 0;
        int i = 0;
        while (i < 7) {
            int width;
            String str = format.format(cal.getTime());
            if (str.length() > charCount) {
                str = str.substring(0, charCount);
            }
            if ((width = metrics.stringWidth(str)) > maxWidth) {
                maxWidth = width;
            }
            cal.add(7, 1);
            ++i;
        }
        return maxWidth;
    }

    public void setModel(CalendarModel model) {
        this.model = model;
    }

    public void setPopupMenuCallback(PopupMenuCallback popupMenuCallback) {
        this.popupMenuCallback = popupMenuCallback;
    }

    public void addCalendarListener(CalendarListener listener) {
        this.listener = listener;
    }

    public void setShowExtraDateHeaders(boolean showExtraDateHeaders) {
        this.showExtraDateHeaders = showExtraDateHeaders;
    }

    public boolean isMonthView() {
        return this.isMonthView;
    }

    public void setMonthView(boolean isMonthView) {
        this.isMonthView = isMonthView;
    }

    protected class CalHeaderMouseListener
    extends MouseAdapter {
        private Object calId;

        public CalHeaderMouseListener(Object calId) {
            this.calId = calId;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    JPopupMenu popup = ColumnHeaderPanel.this.popupMenuCallback.getCalendarPopupMenu(this.calId);
                    if (popup == null) {
                        return;
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
            catch (Exception exc) {
                throw BizcalException.create(exc);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class CloseListener
    extends MouseAdapter {
        private Object calId;

        public CloseListener(Object calId) {
            this.calId = calId;
        }

        public void mouseClicked(MouseEvent event) {
            try {
                ColumnHeaderPanel.this.listener.closeCalendar(this.calId);
            }
            catch (Exception e) {
                ErrorHandler.handleError(e);
            }
        }
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            try {
                int height = ((ColumnHeaderPanel)ColumnHeaderPanel.this).referenceLabel.getPreferredSize().height;
                height = ColumnHeaderPanel.this.rowCount * height;
                int calenderSize = 1;
                if (ColumnHeaderPanel.this.model != null && ColumnHeaderPanel.this.model.getSelectedCalendars() != null) {
                    calenderSize = ColumnHeaderPanel.this.model.getSelectedCalendars().size();
                }
                int width = ColumnHeaderPanel.this.dayCount * calenderSize * 10;
                return new Dimension(width, height);
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(50, 100);
        }

        public void layoutContainer(Container parent) {
            try {
                if (ColumnHeaderPanel.this.rowCount == 0) {
                    return;
                }
                double totWidth = parent.getWidth();
                double dateColWidth = totWidth / (double)ColumnHeaderPanel.this.dateHeaders.size();
                double calColWidth = totWidth / (double)ColumnHeaderPanel.this.calHeaders.size();
                double rowHeight = parent.getHeight() / ColumnHeaderPanel.this.rowCount;
                double dateYPos = 0.0;
                if (ColumnHeaderPanel.this.calHeaders.size() > 0) {
                    dateYPos = rowHeight;
                }
                int dateI = 0;
                int dateLineI = 0;
                int dayRowCount = ColumnHeaderPanel.this.showExtraDateHeaders ? 2 : 1;
                int i = 0;
                while (i < ColumnHeaderPanel.this.model.getSelectedCalendars().size()) {
                    if (ColumnHeaderPanel.this.calHeaders.size() > 0) {
                        JComponent label = (JComponent)ColumnHeaderPanel.this.calHeaders.get(i);
                        label.setBounds((int)((double)i * calColWidth), 0, (int)calColWidth, (int)rowHeight);
                    }
                    if (ColumnHeaderPanel.this.dayCount >= 1) {
                        int j = 0;
                        while (j < ColumnHeaderPanel.this.dayCount) {
                            JLabel dateLabel = (JLabel)ColumnHeaderPanel.this.dateHeaders.get(dateI);
                            int xpos = (int)((double)dateI * dateColWidth);
                            dateLabel.setBounds(xpos, (int)dateYPos, (int)dateColWidth, (int)rowHeight);
                            if (ColumnHeaderPanel.this.showExtraDateHeaders) {
                                dateLabel = (JLabel)ColumnHeaderPanel.this.dateHeaders2.get(dateI);
                                dateLabel.setBounds(xpos, (int)(dateYPos + rowHeight), (int)dateColWidth, (int)rowHeight);
                            }
                            if (j > 0 || i > 0) {
                                JLabel line = (JLabel)ColumnHeaderPanel.this.dateLines.get(dateLineI);
                                int ypos = (int)dateYPos;
                                int height = (int)rowHeight * dayRowCount;
                                if (j == 0) {
                                    ypos = 0;
                                    height = (int)(rowHeight * (double)(dayRowCount + 1));
                                }
                                line.setBounds(xpos, ypos, 1, height);
                                ++dateLineI;
                            }
                            ++dateI;
                            ++j;
                        }
                    }
                    ++i;
                }
                ColumnHeaderPanel.this.gradientArea.setBounds(0, 0, parent.getWidth(), parent.getHeight());
                ColumnHeaderPanel.this.resizeDates((int)dateColWidth);
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }
    }
}

