/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.util.GradientArea;
import bizcal.util.BizcalException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class CalendarRowHeader {
    private JLayeredPane panel;
    private List<JLabel> calLabels = new ArrayList<JLabel>();
    private List<JLabel> calLines = new ArrayList<JLabel>();
    private GradientArea gradientArea;
    private int width = 100;
    private int footerHeight = 0;
    private CalendarModel model;
    private CalendarViewConfig config;

    public CalendarRowHeader(CalendarModel model, CalendarViewConfig config) throws Exception {
        this.model = model;
        this.config = config;
        this.panel = new JLayeredPane();
        this.panel.setLayout(new Layout());
    }

    public void refresh() throws Exception {
        this.panel.removeAll();
        this.calLabels.clear();
        this.calLines.clear();
        JLabel line = new JLabel();
        line.setBackground(this.config.getLineColor());
        line.setOpaque(true);
        this.calLines.add(line);
        this.panel.add((Component)line, (Object)2);
        for (Calendar cal : this.model.getSelectedCalendars()) {
            JLabel label = new JLabel(cal.getSummary());
            label.setVerticalTextPosition(0);
            this.panel.add((Component)label, (Object)2);
            this.calLabels.add(label);
            line = new JLabel();
            line.setBackground(this.config.getLineColor());
            line.setOpaque(true);
            this.calLines.add(line);
            this.panel.add((Component)line, (Object)2);
        }
        this.gradientArea = new GradientArea("LEFT_RIGHT", Color.WHITE, ColumnHeaderPanel.GRADIENT_COLOR);
        this.gradientArea.setOpaque(true);
        this.gradientArea.setBorder(false);
        this.panel.add((Component)this.gradientArea, (Object)1);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setFooterHeight(int footerHeight) {
        this.footerHeight = footerHeight;
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            try {
                return new Dimension(CalendarRowHeader.this.width, 40 * CalendarRowHeader.this.model.getSelectedCalendars().size() + CalendarRowHeader.this.footerHeight);
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(50, 50);
        }

        public void layoutContainer(Container parent) {
            try {
                double rowHeight = 40.0;
                JLabel calLine = (JLabel)CalendarRowHeader.this.calLines.get(0);
                calLine.setBounds(0, 0, CalendarRowHeader.this.width, 1);
                int i = 0;
                while (i < CalendarRowHeader.this.calLabels.size()) {
                    JLabel calLabel = (JLabel)CalendarRowHeader.this.calLabels.get(i);
                    calLabel.setBounds(5, (int)((double)i * rowHeight), CalendarRowHeader.this.width - 5, (int)rowHeight);
                    calLine = (JLabel)CalendarRowHeader.this.calLines.get(i + 1);
                    calLine.setBounds(0, (int)((double)(i + 1) * rowHeight), CalendarRowHeader.this.width, 1);
                    ++i;
                }
                CalendarRowHeader.this.gradientArea.setBounds(0, 0, parent.getWidth(), parent.getHeight());
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }
    }
}

