/*
 * Decompiled with CFR 0.152.
 */
package bizcal.demo;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.DayView;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;

public class BizcalDemo {
    public static void main(String[] args) throws Exception {
        DayView dayView = new DayView(new DayViewConfig());
        dayView.setModel(new ThisModel());
        JFrame frame = new JFrame("Bizcal Demo");
        dayView.refresh();
        frame.setContentPane(dayView.getComponent());
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThisModel
    extends CalendarModel.BaseImpl {
        private List<Event> events = new ArrayList<Event>();
        private DateInterval interval;
        private Calendar cal;

        public ThisModel() throws Exception {
            Date date = DateUtil.round2Week(new Date());
            date = new Date(date.getTime() + 28800000L);
            int i = 0;
            while (i < 7) {
                Event event = new Event();
                event.setStart(date);
                event.setEnd(new Date(date.getTime() + 5400000L));
                event.setSummary("Test " + i);
                this.events.add(event);
                date = DateUtil.getDiffDay(date, 1);
                date = new Date(date.getTime() + 3600000L);
                ++i;
            }
            Date start = DateUtil.round2Week(new Date());
            Date end = DateUtil.getDiffDay(start, 5);
            this.interval = new DateInterval(start, end);
            this.cal = new Calendar();
            this.cal.setId(1);
            this.cal.setSummary("Peter");
        }

        @Override
        public List<Event> getEvents(Object calId) throws Exception {
            return this.events;
        }

        @Override
        public List getSelectedCalendars() throws Exception {
            return Collections.nCopies(1, this.cal);
        }

        @Override
        public DateInterval getInterval() {
            return this.interval;
        }
    }
}

