/*
 * Decompiled with CFR 0.152.
 */
package bizcal.common;

import bizcal.common.CalendarViewConfig;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;

public class DayViewConfig
extends CalendarViewConfig {
    public static final int FRAG_HOUR = 1;
    public static final int FRAG_HALF = 2;
    public static final int FRAG_THIRD = 3;
    public static final int FRAG_QUARTER = 4;
    public static final int FRAG_SIXTHT = 6;
    private boolean showExtraDateHeaders = true;
    private boolean showDateFooter = false;
    private TimeOfDay endView;
    private int gridAlpha = 50;
    private int numberOfTimeSlots = 6;
    public int DAY_START_DEFAULT = 0;
    public int DAY_END_DEFAULT = 18;
    private int dayStartHour = this.DAY_START_DEFAULT;
    private int dayEndHour = this.DAY_END_DEFAULT;
    private int breakHour = 12;
    private int dayViewStart = 7;
    private int dayViewEnd = 12;
    private int weekStart = 2;
    private int weekEnd = 1;

    public DayViewConfig() {
        this.endView = new TimeOfDay(this.dayViewEnd, 0);
        this.setCaption("Calendar");
    }

    public DayViewConfig(CalendarViewConfig calViewD) {
        this.copy(calViewD);
    }

    public int getDayCount() {
        return DateUtil.getDiffDay(this.weekStart, this.weekEnd);
    }

    @Deprecated
    public void setDayCount(int dayCount) {
    }

    public boolean isShowExtraDateHeaders() {
        return this.showExtraDateHeaders;
    }

    public void setShowExtraDateHeaders(boolean showExtraDateHeaders) {
        this.showExtraDateHeaders = showExtraDateHeaders;
    }

    public void setShowDateFooter(boolean showDateFooter) {
        this.showDateFooter = showDateFooter;
    }

    public boolean isShowDateFooter() {
        return this.showDateFooter;
    }

    public TimeOfDay getEndView() {
        return this.endView;
    }

    public void setEndView(TimeOfDay endView) {
        this.endView = endView;
    }

    public int getNumberOfTimeSlots() {
        return this.numberOfTimeSlots;
    }

    public void setNumberOfTimeSlots(int numberOfTimeSlots) {
        this.numberOfTimeSlots = numberOfTimeSlots;
    }

    public int getDefaultDayEndHour() {
        return this.DAY_END_DEFAULT;
    }

    public int getDefaultDayStartHour() {
        return this.DAY_START_DEFAULT;
    }

    public void setDefaultDayEndHour(int hour) {
        this.DAY_END_DEFAULT = hour;
    }

    public void setDefaultDayStartHour(int hour) {
        this.DAY_START_DEFAULT = hour;
    }

    public int getDayEndHour() {
        return this.dayEndHour;
    }

    public void setDayEndHour(int dayEndHour) {
        this.dayEndHour = dayEndHour;
    }

    public int getDayStartHour() {
        return this.dayStartHour;
    }

    public void setDayStartHour(int dayStartHour) {
        this.dayStartHour = dayStartHour;
    }

    public int getHours() {
        return this.getDayEndHour() - this.getDayStartHour();
    }

    public int getMinimumTimeSlotHeight() {
        return super.getMinimumTimeSlotHeight();
    }

    public int getDayViewEnd() {
        return this.dayViewEnd;
    }

    public void setDayViewEnd(int dayViewEnd) {
        this.dayViewEnd = dayViewEnd;
        this.endView = new TimeOfDay(dayViewEnd, 0);
    }

    public int getDayViewStart() {
        return this.dayViewStart;
    }

    public void setDayViewStart(int dayViewStart) {
        this.dayViewStart = dayViewStart;
    }

    public int getWeekEnd() {
        return this.weekEnd;
    }

    public void setWeekStop(int weekEnd) {
        this.weekEnd = weekEnd;
    }

    public int getWeekStart() {
        return this.weekStart;
    }

    public void setWeekStart(int weekStart) {
        this.weekStart = weekStart;
    }

    public void setDayBreak(int breakHour) {
        this.breakHour = breakHour;
    }

    public int getDayBreak() {
        return this.breakHour;
    }

    public int getGridAlpha() {
        return this.gridAlpha;
    }

    public void setGridAlpha(int gridAlpha) {
        this.gridAlpha = gridAlpha;
    }
}

