/*
 * Decompiled with CFR 0.152.
 */
package bizcal.common;

import bizcal.common.CalendarModel;
import bizcal.util.LocaleBroker;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class CalendarViewConfig {
    private CalendarModel callback;
    private boolean showTopHeader = true;
    private Font font = new Font("Verdana", 0, 10);
    private Color primaryColor = new Color(100, 100, 245);
    private Color secondaryColor = new Color(255, 255, 255);
    private String caption;
    private Color lineColor = new Color(200, 200, 200);
    private Color lineColor2 = new Color(150, 150, 150);
    private Color lineColor3 = new Color(100, 100, 100);
    private TimeOfDay startView;
    private TimeOfDay endView;
    private DateFormat monthDateFormat = new SimpleDateFormat("EEEE", LocaleBroker.getLocale());
    private DateFormat weekDateFormat = new SimpleDateFormat("EE - dd.MM.", LocaleBroker.getLocale());
    private DateFormat dayFormat = new SimpleDateFormat("EEEE dd.MM.yyyy", LocaleBroker.getLocale());

    public CalendarViewConfig() {
        this.startView = new TimeOfDay(2, 0);
        this.endView = new TimeOfDay(18, 0);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public CalendarModel getCallback() {
        return this.callback;
    }

    public void setCallback(CalendarModel callback) {
        this.callback = callback;
    }

    public boolean isShowTopHeader() {
        return this.showTopHeader;
    }

    public void setShowTopHeader(boolean showTopHeader) {
        this.showTopHeader = showTopHeader;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void copy(CalendarViewConfig other) {
        this.callback = other.callback;
        this.font = other.font;
        this.showTopHeader = other.showTopHeader;
        this.startView = other.startView;
        this.endView = other.endView;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(Color primaryColor) {
        this.primaryColor = primaryColor;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(Color secondaryColor) {
        this.secondaryColor = secondaryColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public TimeOfDay getEndView() {
        return this.endView;
    }

    public void setEndView(TimeOfDay endView) {
        this.endView = endView;
    }

    public TimeOfDay getStartView() {
        return this.startView;
    }

    public void setStartView(TimeOfDay startView) {
        this.startView = startView;
    }

    public Color getLineColor2() {
        return this.lineColor2;
    }

    public void setLineColor2(Color lineColor2) {
        this.lineColor2 = lineColor2;
    }

    public Color getLineColor3() {
        return this.lineColor3;
    }

    public void setLineColor3(Color lineColor3) {
        this.lineColor3 = lineColor3;
    }

    public int getMinimumTimeSlotHeight() {
        return 20;
    }

    public DateFormat getDayFormat() {
        return this.dayFormat;
    }

    public void setDayFormat(DateFormat dayFormat) {
        this.dayFormat = dayFormat;
    }

    public DateFormat getMonthDateFormat() {
        return this.monthDateFormat;
    }

    public void setMonthDateFormat(DateFormat monthDateFormat) {
        this.monthDateFormat = monthDateFormat;
    }

    public DateFormat getWeekDateFormat() {
        return this.weekDateFormat;
    }

    public void setWeekDateFormat(DateFormat weekDateFormat) {
        this.weekDateFormat = weekDateFormat;
    }
}

