/*
 * Decompiled with CFR 0.152.
 */
package bizcal.common;

import bizcal.common.Event;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CalendarModel {
    public List<Event> getEvents(Object var1) throws Exception;

    public List getCalendars() throws Exception;

    public List getSelectedCalendars() throws Exception;

    public void refresh() throws Exception;

    public void deleteCalendar(Object var1) throws Exception;

    public long getResolution() throws Exception;

    public DateInterval getInterval() throws Exception;

    public List getColorDescriptions() throws Exception;

    public boolean isInsertable(Object var1, Date var2) throws Exception;

    public boolean isRedDay(Date var1) throws Exception;

    public TimeOfDay getViewStart() throws Exception;

    public TimeOfDay getViewEnd() throws Exception;

    public String getDateHeader(Object var1, Date var2) throws Exception;

    public String getDateFooter(Object var1, Date var2, List var3) throws Exception;

    public static abstract class BaseImpl
    implements CalendarModel {
        private int sunday = 1;
        private TimeOfDay viewStart;
        private TimeOfDay viewEnd;
        private DateInterval interval;

        public BaseImpl() {
            try {
                this.viewStart = new TimeOfDay(7, 0);
                this.viewEnd = new TimeOfDay(18, 0);
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        public List getCalendars() throws Exception {
            return new ArrayList();
        }

        public List getSelectedCalendars() throws Exception {
            return new ArrayList();
        }

        public void refresh() throws Exception {
        }

        public void deleteCalendar(Object id) throws Exception {
        }

        public long getResolution() {
            return 900000L;
        }

        public List getColorDescriptions() throws Exception {
            return new ArrayList();
        }

        public boolean isInsertable(Object id, Date date) throws Exception {
            return true;
        }

        public boolean isRedDay(Date date) throws Exception {
            return DateUtil.getDayOfWeek(date) == this.sunday;
        }

        public TimeOfDay getViewStart() throws Exception {
            return this.viewStart;
        }

        public TimeOfDay getViewEnd() throws Exception {
            return this.viewEnd;
        }

        public void setViewStart(TimeOfDay value) {
            this.viewStart = value;
        }

        public void setViewEnd(TimeOfDay value) {
            this.viewEnd = value;
        }

        public DateInterval getInterval() {
            return this.interval;
        }

        public void setInterval(DateInterval interval) throws Exception {
            this.interval = interval;
        }

        public String getDateHeader(Object calId, Date date) throws Exception {
            return "mops";
        }

        public String getDateFooter(Object calId, Date date, List events) throws Exception {
            return "Puuups";
        }
    }
}

