/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.tool.GrammarAST;

public abstract class SemanticContext {
    public static final SemanticContext EMPTY_SEMANTIC_CONTEXT = new Predicate();

    public abstract SemanticContext reduce();

    public abstract SemanticContext getGatedPredicateContext();

    public abstract StringTemplate genExpr(CodeGenerator var1, StringTemplateGroup var2, DFA var3);

    public abstract boolean isSyntacticPredicate();

    public static SemanticContext and(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == EMPTY_SEMANTIC_CONTEXT || semanticContext == null) {
            return semanticContext2;
        }
        if (semanticContext2 == EMPTY_SEMANTIC_CONTEXT || semanticContext2 == null) {
            return semanticContext;
        }
        if (semanticContext.equals(semanticContext2)) {
            return semanticContext;
        }
        return new AND(semanticContext, semanticContext2).reduce();
    }

    public static SemanticContext or(SemanticContext semanticContext, SemanticContext semanticContext2) {
        if (semanticContext == EMPTY_SEMANTIC_CONTEXT || semanticContext == null) {
            return semanticContext2;
        }
        if (semanticContext2 == EMPTY_SEMANTIC_CONTEXT || semanticContext2 == null) {
            return semanticContext;
        }
        if (semanticContext.equals(semanticContext2)) {
            return semanticContext;
        }
        return new OR(semanticContext, semanticContext2).reduce();
    }

    public static SemanticContext not(SemanticContext semanticContext) {
        return new NOT(semanticContext).reduce();
    }

    public static class NOT
    extends SemanticContext {
        protected SemanticContext ctx;

        public NOT(SemanticContext semanticContext) {
            this.ctx = semanticContext;
        }

        public SemanticContext reduce() {
            this.ctx.reduce();
            return this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NOT)) {
                return false;
            }
            return this.ctx.equals(((NOT)object).ctx);
        }

        public int hashCode() {
            return this.ctx.hashCode();
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            StringTemplate stringTemplate = null;
            stringTemplate = stringTemplateGroup != null ? stringTemplateGroup.getInstanceOf("notPredicate") : new StringTemplate("?!($pred$)");
            stringTemplate.setAttribute("pred", (Object)this.ctx.genExpr(codeGenerator, stringTemplateGroup, dFA));
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext semanticContext = this.ctx.getGatedPredicateContext();
            if (semanticContext == null) {
                return null;
            }
            return new NOT(semanticContext);
        }

        public boolean isSyntacticPredicate() {
            return this.ctx.isSyntacticPredicate();
        }

        public String toString() {
            return "!(" + this.ctx + ")";
        }
    }

    public static class OR
    extends SemanticContext {
        protected SemanticContext left;
        protected SemanticContext right;

        public OR(SemanticContext semanticContext, SemanticContext semanticContext2) {
            this.left = semanticContext;
            this.right = semanticContext2;
        }

        public SemanticContext reduce() {
            Predicate predicate;
            OR oR;
            this.left.reduce();
            this.right.reduce();
            if (this.left instanceof OR && this.right instanceof Predicate) {
                oR = (OR)this.left;
                predicate = (Predicate)this.right;
                if (oR.left.equals(predicate) || oR.right.equals(predicate)) {
                    return this.left;
                }
            }
            if (this.left instanceof Predicate && this.right instanceof OR) {
                oR = (OR)this.right;
                predicate = (Predicate)this.left;
                if (oR.left.equals(predicate) || oR.right.equals(predicate)) {
                    return this.right;
                }
            }
            if (this.left.equals(OR.not(this.right))) {
                return new TruePredicate();
            }
            if (this.right.equals(OR.not(this.left))) {
                return new TruePredicate();
            }
            return this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof OR)) {
                return false;
            }
            return this.left.equals(((OR)object).left) && this.right.equals(((OR)object).right);
        }

        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            StringTemplate stringTemplate = null;
            stringTemplate = stringTemplateGroup != null ? stringTemplateGroup.getInstanceOf("orPredicates") : new StringTemplate("($left$||$right$)");
            stringTemplate.setAttribute("left", (Object)this.left.genExpr(codeGenerator, stringTemplateGroup, dFA));
            stringTemplate.setAttribute("right", (Object)this.right.genExpr(codeGenerator, stringTemplateGroup, dFA));
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext semanticContext = this.left.getGatedPredicateContext();
            SemanticContext semanticContext2 = this.right.getGatedPredicateContext();
            if (semanticContext == null) {
                return semanticContext2;
            }
            if (semanticContext2 == null) {
                return semanticContext;
            }
            return new AND(semanticContext, semanticContext2);
        }

        public boolean isSyntacticPredicate() {
            return this.left.isSyntacticPredicate() || this.right.isSyntacticPredicate();
        }

        public String toString() {
            return "(" + this.left + "||" + this.right + ")";
        }
    }

    public static class AND
    extends SemanticContext {
        protected SemanticContext left;
        protected SemanticContext right;

        public AND(SemanticContext semanticContext, SemanticContext semanticContext2) {
            this.left = semanticContext;
            this.right = semanticContext2;
        }

        public SemanticContext reduce() {
            this.left.reduce();
            this.right.reduce();
            return this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AND)) {
                return false;
            }
            return this.left.equals(((AND)object).left) && this.right.equals(((AND)object).right);
        }

        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            StringTemplate stringTemplate = null;
            stringTemplate = stringTemplateGroup != null ? stringTemplateGroup.getInstanceOf("andPredicates") : new StringTemplate("($left$&&$right$)");
            stringTemplate.setAttribute("left", (Object)this.left.genExpr(codeGenerator, stringTemplateGroup, dFA));
            stringTemplate.setAttribute("right", (Object)this.right.genExpr(codeGenerator, stringTemplateGroup, dFA));
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext semanticContext = this.left.getGatedPredicateContext();
            SemanticContext semanticContext2 = this.right.getGatedPredicateContext();
            if (semanticContext == null) {
                return semanticContext2;
            }
            if (semanticContext2 == null) {
                return semanticContext;
            }
            return new AND(semanticContext, semanticContext2);
        }

        public boolean isSyntacticPredicate() {
            return this.left.isSyntacticPredicate() || this.right.isSyntacticPredicate();
        }

        public String toString() {
            return "(" + this.left + "&&" + this.right + ")";
        }
    }

    public static class FalsePredicate
    extends Predicate {
        public FalsePredicate() {
            this.constantValue = 0;
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            if (stringTemplateGroup != null) {
                return stringTemplateGroup.getInstanceOf("false");
            }
            return new StringTemplate("false");
        }

        public String toString() {
            return "false";
        }
    }

    public static class TruePredicate
    extends Predicate {
        public TruePredicate() {
            this.constantValue = 1;
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            if (stringTemplateGroup != null) {
                return stringTemplateGroup.getInstanceOf("true");
            }
            return new StringTemplate("true");
        }

        public String toString() {
            return "true";
        }
    }

    public static class Predicate
    extends SemanticContext {
        protected GrammarAST predicate;
        protected boolean gated = false;
        protected boolean synpred = false;
        public static final int INVALID_PRED_VALUE = -1;
        public static final int FALSE_PRED = 0;
        public static final int TRUE_PRED = 1;
        protected int constantValue = -1;

        public Predicate() {
            this.predicate = new GrammarAST();
            this.gated = false;
        }

        public Predicate(GrammarAST grammarAST) {
            this.predicate = grammarAST;
            this.gated = grammarAST.getType() == 35;
            this.synpred = grammarAST.getType() == 36;
        }

        public Predicate(Predicate predicate) {
            this.predicate = predicate.predicate;
            this.gated = predicate.gated;
            this.synpred = predicate.synpred;
            this.constantValue = predicate.constantValue;
        }

        public SemanticContext reduce() {
            return this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Predicate)) {
                return false;
            }
            return this.predicate.getText().equals(((Predicate)object).predicate.getText());
        }

        public int hashCode() {
            if (this.predicate == null) {
                return 0;
            }
            return this.predicate.getText().hashCode();
        }

        public StringTemplate genExpr(CodeGenerator codeGenerator, StringTemplateGroup stringTemplateGroup, DFA dFA) {
            String string;
            StringTemplate stringTemplate = null;
            if (stringTemplateGroup != null) {
                stringTemplate = this.synpred ? stringTemplateGroup.getInstanceOf("evalSynPredicate") : stringTemplateGroup.getInstanceOf("evalPredicate");
                string = this.predicate.getEnclosingRule();
                if (codeGenerator != null) {
                    stringTemplate.setAttribute("pred", (Object)codeGenerator.translateAction(string, this.predicate));
                }
            } else {
                stringTemplate = new StringTemplate("$pred$");
                stringTemplate.setAttribute("pred", (Object)this.toString());
                return stringTemplate;
            }
            if (codeGenerator != null) {
                string = codeGenerator.target.getTargetStringLiteralFromString(this.toString());
                stringTemplate.setAttribute("description", (Object)string);
            }
            return stringTemplate;
        }

        public SemanticContext getGatedPredicateContext() {
            if (this.gated) {
                return this;
            }
            return null;
        }

        public boolean isSyntacticPredicate() {
            return this.predicate != null && this.predicate.getType() == 36;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(StringTemplateGroup stringTemplateGroup) {
            if (this.predicate == null) {
                return "<nopred>";
            }
            return this.predicate.getText();
        }
    }
}

