/*
 * Decompiled with CFR 0.152.
 */
package org.antlr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.codegen.CodeGenerator;
import org.antlr.tool.DOTGenerator;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarReport;
import org.antlr.tool.Rule;

public class Tool {
    protected boolean hasError;
    public static final String VERSION = "3.0ea8";
    public static final String UNINITIALIZED_DIR = "<unset-dir>";
    protected List grammarFileNames = new ArrayList();
    protected boolean generate_NFA_dot = false;
    protected boolean generate_DFA_dot = false;
    protected String outputDirectory = "<unset-dir>";
    protected String libDirectory = ".";
    protected boolean debug = false;
    protected boolean trace = false;
    protected boolean profile = false;
    protected boolean report = false;
    protected boolean memo = true;
    protected boolean printGrammar = false;
    public static boolean internalOption_PrintGrammarTree = false;
    public static boolean internalOption_PrintDFA = false;
    public static boolean internalOption_ShowNFConfigsInDFA = false;
    public static boolean internalOption_watchNFAConversion = false;

    public static void main(String[] stringArray) {
        ErrorManager.info("ANTLR Parser Generator   Early Access Version 3.0ea8 (Mar 11, 2006)  1989-2006");
        Tool tool = new Tool(stringArray);
        tool.process();
        System.exit(0);
    }

    public Tool() {
    }

    public Tool(String[] stringArray) {
        this.processArgs(stringArray);
    }

    public void processArgs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            Tool.help();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            if (stringArray[i].equals("-o")) {
                if (i + 1 >= stringArray.length) {
                    System.err.println("missing output directory with -o option; ignoring");
                    continue;
                }
                this.outputDirectory = stringArray[++i];
                if (this.outputDirectory.endsWith("/") || this.outputDirectory.endsWith("\\")) {
                    this.outputDirectory = this.outputDirectory.substring(0, this.outputDirectory.length() - 1);
                }
                if (!(file = new File(this.outputDirectory)).exists() || file.isDirectory()) continue;
                ErrorManager.error(6, this.outputDirectory);
                this.libDirectory = ".";
                continue;
            }
            if (stringArray[i].equals("-lib")) {
                if (i + 1 >= stringArray.length) {
                    System.err.println("missing library directory with -lib option; ignoring");
                    continue;
                }
                this.libDirectory = stringArray[++i];
                if (this.libDirectory.endsWith("/") || this.libDirectory.endsWith("\\")) {
                    this.libDirectory = this.libDirectory.substring(0, this.libDirectory.length() - 1);
                }
                if ((file = new File(this.libDirectory)).exists()) continue;
                ErrorManager.error(5, this.libDirectory);
                this.libDirectory = ".";
                continue;
            }
            if (stringArray[i].equals("-verbose")) {
                DecisionProbe.verbose = true;
                continue;
            }
            if (stringArray[i].equals("-nfa")) {
                this.generate_NFA_dot = true;
                continue;
            }
            if (stringArray[i].equals("-dfa")) {
                this.generate_DFA_dot = true;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                this.debug = true;
                continue;
            }
            if (stringArray[i].equals("-trace")) {
                this.trace = true;
                continue;
            }
            if (stringArray[i].equals("-report")) {
                this.report = true;
                continue;
            }
            if (stringArray[i].equals("-profile")) {
                this.profile = true;
                continue;
            }
            if (stringArray[i].equals("-nomemo")) {
                this.memo = false;
                continue;
            }
            if (stringArray[i].equals("-print")) {
                this.printGrammar = true;
                continue;
            }
            if (stringArray[i].equals("-Igrtree")) {
                internalOption_PrintGrammarTree = true;
                continue;
            }
            if (stringArray[i].equals("-Idfa")) {
                internalOption_PrintDFA = true;
                continue;
            }
            if (stringArray[i].equals("-Inoprune")) {
                DFAOptimizer.PRUNE_EBNF_EXIT_BRANCHES = false;
                continue;
            }
            if (stringArray[i].equals("-Inocollapse")) {
                DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES = false;
                continue;
            }
            if (stringArray[i].equals("-Idbgconversion")) {
                NFAToDFAConverter.debug = true;
                continue;
            }
            if (stringArray[i].equals("-Inomergestopstates")) {
                DFAOptimizer.MERGE_STOP_STATES = false;
                continue;
            }
            if (stringArray[i].equals("-Idfaverbose")) {
                internalOption_ShowNFConfigsInDFA = true;
                continue;
            }
            if (stringArray[i].equals("-Iwatchconversion")) {
                internalOption_watchNFAConversion = true;
                continue;
            }
            if (stringArray[i].equals("-Im")) {
                if (i + 1 >= stringArray.length) {
                    System.err.println("missing max recursion with -m option; ignoring");
                    continue;
                }
                NFAContext.MAX_RECURSIVE_INVOCATIONS = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].charAt(0) == '-') continue;
            this.grammarFileNames.add(stringArray[i]);
        }
    }

    public void process() {
        for (int i = 0; i < this.grammarFileNames.size(); ++i) {
            String string = (String)this.grammarFileNames.get(i);
            try {
                Object object;
                FileReader fileReader = new FileReader(string);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                Grammar grammar = new Grammar(this, string, bufferedReader);
                grammar.setWatchNFAConversion(internalOption_watchNFAConversion);
                bufferedReader.close();
                fileReader.close();
                this.processGrammar(grammar);
                if (this.printGrammar) {
                    grammar.printGrammar(System.out);
                }
                String string2 = grammar.getLexerGrammar();
                if (grammar.type == 4 && string2 != null) {
                    object = grammar.name + ".lexer.g";
                    Writer writer = this.getOutputFile(grammar, (String)object);
                    writer.write(string2);
                    writer.close();
                    StringReader stringReader = new StringReader(string2);
                    Grammar grammar2 = new Grammar();
                    File file = new File(grammar.getFileDirectory(), (String)object);
                    grammar2.setFileName(file.toString());
                    grammar2.importTokenVocabulary(grammar);
                    grammar2.setGrammarContent(stringReader);
                    stringReader.close();
                    this.processGrammar(grammar2);
                }
                if (this.generate_NFA_dot) {
                    this.generateNFAs(grammar);
                }
                if (this.generate_DFA_dot) {
                    this.generateDFAs(grammar);
                }
                if (this.report) {
                    object = new GrammarReport(grammar).toString();
                    System.out.println((String)object);
                }
                object = new GrammarReport(grammar);
                GrammarReport.writeReport("grammar.stats", ((GrammarReport)object).toNotifyString());
                continue;
            }
            catch (Exception exception) {
                ErrorManager.error(10, (Object)string, exception);
            }
        }
    }

    protected void processGrammar(Grammar grammar) throws IOException {
        String string = (String)grammar.getOption("language");
        if (string != null) {
            CodeGenerator codeGenerator = new CodeGenerator(this, grammar, string);
            grammar.setCodeGenerator(codeGenerator);
            codeGenerator.setDebug(this.debug);
            codeGenerator.setProfile(this.profile);
            codeGenerator.setTrace(this.trace);
            codeGenerator.setMemoize(this.memo);
            codeGenerator.genRecognizer();
        }
    }

    protected void generateDFAs(Grammar grammar) {
        for (int i = 1; i <= grammar.getNumberOfDecisions(); ++i) {
            DFA dFA = grammar.getLookaheadDFA(i);
            DOTGenerator dOTGenerator = new DOTGenerator(grammar);
            String string = dOTGenerator.getDOT(dFA.startState);
            String string2 = grammar.name + "_dec-" + i;
            try {
                this.writeDOTFile(grammar, string2, string);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.error(14, (Object)string2, iOException);
            }
        }
    }

    protected void generateNFAs(Grammar grammar) {
        DOTGenerator dOTGenerator = new DOTGenerator(grammar);
        Collection collection = grammar.getRules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            String string = rule.name;
            try {
                this.writeDOTFile(grammar, string, dOTGenerator.getDOT(grammar.getRuleStartState(string)));
            }
            catch (IOException iOException) {
                ErrorManager.error(1, iOException);
            }
        }
    }

    protected void writeDOTFile(Grammar grammar, String string, String string2) throws IOException {
        Writer writer = this.getOutputFile(grammar, string + ".dot");
        writer.write(string2);
        writer.close();
    }

    private static void help() {
        System.err.println("usage: java org.antlr.Tool [args] file.g [file2.g file3.g ...]");
        System.err.println("  -o outputDir   specify output directory where all output is generated");
        System.err.println("  -lib dir       specify location of token files");
        System.err.println("  -report        print out a report about the grammar(s) processed");
        System.err.println("  -print         print out the grammar without actions");
        System.err.println("  -debug         generate a parser that emits debugging events");
        System.err.println("  -profile       generate a parser that computes profiling information");
        System.err.println("  -nomemo        when backtracking don't generate memoization code");
        System.err.println("  -nfa           generate an NFA for each rule");
        System.err.println("  -dfa           generate a DFA for each decision point");
    }

    public void setOutputDirectory(String string) {
        this.outputDirectory = string;
    }

    public Writer getOutputFile(Grammar grammar, String string) throws IOException {
        Object object;
        if (this.outputDirectory == null) {
            return new StringWriter();
        }
        File file = new File(this.outputDirectory);
        String string2 = grammar.getFileDirectory();
        if (this.outputDirectory != UNINITIALIZED_DIR) {
            file = string2 != null && (new File(string2).isAbsolute() || string2.startsWith("~")) ? new File(this.outputDirectory) : (string2 != null ? new File(this.outputDirectory, string2) : new File(this.outputDirectory));
        } else {
            object = ".";
            if (string2 != null) {
                object = string2;
            }
            file = new File((String)object);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        object = new FileWriter(new File(file, string));
        return new BufferedWriter((Writer)object);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public BufferedReader getLibraryFile(String string) throws IOException {
        String string2 = this.libDirectory + File.separator + string;
        FileReader fileReader = new FileReader(string2);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        return bufferedReader;
    }

    public void panic() {
        throw new Error("ANTLR panic");
    }

    public static String getCurrentTimeStamp() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = String.valueOf(n);
        String string2 = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        String string3 = n3 < 10 ? "0" + n3 : String.valueOf(n3);
        String string4 = n4 < 10 ? "0" + n4 : String.valueOf(n4);
        String string5 = n5 < 10 ? "0" + n5 : String.valueOf(n5);
        String string6 = n6 < 10 ? "0" + n6 : String.valueOf(n6);
        return string + "-" + string2 + "-" + string3 + " " + string4 + ":" + string5 + ":" + string6;
    }
}

