/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KnowledgeHelperFixer {
    static String KNOWLEDGE_HELPER_PFX = "";
    static Pattern MODIFY = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "modify\\s*\\(([^)]+)\\)(.*)", 32);
    static Pattern ASSERT = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "assert\\s*\\((.*)\\)(.*)", 32);
    static Pattern ASSERT_LOGICAL = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "assertLogical\\s*\\((.*)\\)(.*)", 32);
    static Pattern RETRACT = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "retract\\s*\\(([^)]+)\\)(.*)", 32);

    public String fix(String string) {
        String string2 = this.fix(string, ModifyReplacer.INSTANCE);
        string2 = this.fix(string2, AssertReplacer.INSTANCE);
        string2 = this.fix(string2, AssertLogicalReplacer.INSTANCE);
        string2 = this.fix(string2, RetractReplacer.INSTANCE);
        return string2;
    }

    public String fix(String string, Replacer replacer) {
        if (string == null) {
            return null;
        }
        Matcher matcher = replacer.getPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            if (matcher.group(1) != null) {
                string2 = this.fix(string2, replacer);
            }
            String string3 = matcher.group(2).trim();
            String string4 = matcher.group(3);
            if (string4 != null) {
                string4 = this.fix(string4, replacer);
            }
            String string5 = this.escapeDollarSigns(replacer, string3);
            return string2 + matcher.replaceAll(string5) + string4;
        }
        return string;
    }

    private String escapeDollarSigns(Replacer replacer, String string) {
        return KnowledgeHelperFixer.replace(replacer.getReplacement(string), "$", "\\$", 256);
    }

    static String replace(String string, String string2, String string3, int n) {
        if (string == null || string2 == null || string2.equals("") || string3 == null || n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + string2.length();
            if (--n != 0) continue;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static class RetractReplacer
    implements Replacer {
        static Replacer INSTANCE = new RetractReplacer();

        RetractReplacer() {
        }

        public Pattern getPattern() {
            return RETRACT;
        }

        public String getReplacement(String string) {
            return "drools.retractObject(" + string.trim() + "__Handle__)";
        }
    }

    static class ModifyReplacer
    implements Replacer {
        static Replacer INSTANCE = new ModifyReplacer();

        ModifyReplacer() {
        }

        public Pattern getPattern() {
            return MODIFY;
        }

        public String getReplacement(String string) {
            return "drools.modifyObject(" + string.trim() + "__Handle__, " + string + ")";
        }
    }

    static class AssertLogicalReplacer
    implements Replacer {
        static Replacer INSTANCE = new AssertLogicalReplacer();

        AssertLogicalReplacer() {
        }

        public Pattern getPattern() {
            return ASSERT_LOGICAL;
        }

        public String getReplacement(String string) {
            return "drools.assertLogicalObject(" + string + ")";
        }
    }

    static class AssertReplacer
    implements Replacer {
        static Replacer INSTANCE = new AssertReplacer();

        AssertReplacer() {
        }

        public Pattern getPattern() {
            return ASSERT;
        }

        public String getReplacement(String string) {
            return "drools.assertObject(" + string + ")";
        }
    }

    static interface Replacer {
        public Pattern getPattern();

        public String getReplacement(String var1);
    }
}

