/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.EclipseJavaCompiler;
import org.apache.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.semantics.java.ClassTypeResolver;
import org.drools.semantics.java.FunctionBuilder;
import org.drools.semantics.java.PackageStore;
import org.drools.semantics.java.RuleBuilder;
import org.drools.spi.TypeResolver;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.SAXException;

public class PackageBuilder {
    private JavaCompiler compiler;
    private Package pkg;
    private List results;
    private PackageStore packageStoreWrapper;
    private MemoryResourceReader src;
    private PackageBuilderConfiguration configuration;
    private Map errorHandlers;
    private List generatedClassList;
    private ClassTypeResolver typeResolver;
    private ClassFieldExtractorCache classFieldExtractorCache;
    private static JavaCompiler cachedJavaCompiler = null;

    public PackageBuilder() {
        this(null, null);
    }

    public PackageBuilder(Package package_) {
        this(package_, null);
    }

    public PackageBuilder(PackageBuilderConfiguration packageBuilderConfiguration) {
        this(null, packageBuilderConfiguration);
    }

    public PackageBuilder(Package package_, PackageBuilderConfiguration packageBuilderConfiguration) {
        if (packageBuilderConfiguration == null) {
            packageBuilderConfiguration = new PackageBuilderConfiguration();
        }
        this.configuration = packageBuilderConfiguration;
        this.loadCompiler();
        this.src = new MemoryResourceReader();
        this.results = new ArrayList();
        this.errorHandlers = new HashMap();
        this.pkg = package_;
        this.generatedClassList = new ArrayList();
        this.classFieldExtractorCache = new ClassFieldExtractorCache();
        if (package_ != null) {
            this.packageStoreWrapper = new PackageStore(package_.getPackageCompilationData());
        }
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        DrlParser drlParser = new DrlParser();
        PackageDescr packageDescr = drlParser.parse(reader);
        this.results.addAll(drlParser.getErrors());
        this.addPackage(packageDescr);
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        XmlPackageReader xmlPackageReader = new XmlPackageReader();
        try {
            xmlPackageReader.read(reader);
        }
        catch (SAXException sAXException) {
            throw new DroolsParserException(sAXException.getCause());
        }
        this.addPackage(xmlPackageReader.getPackageDescr());
    }

    public void addPackageFromDrl(Reader reader, Reader reader2) throws DroolsParserException, IOException {
        DrlParser drlParser = new DrlParser();
        PackageDescr packageDescr = drlParser.parse(reader, reader2);
        this.results.addAll(drlParser.getErrors());
        this.addPackage(packageDescr);
    }

    public void addPackage(PackageDescr packageDescr) {
        this.validatePackageName(packageDescr);
        this.validateUniqueRuleNames(packageDescr);
        if (this.pkg != null) {
            this.mergePackage(this.pkg, packageDescr);
        } else {
            this.pkg = this.newPackage(packageDescr);
        }
        if (!this.hasErrors()) {
            Iterator iterator = packageDescr.getFunctions().iterator();
            while (iterator.hasNext()) {
                this.addFunction((FunctionDescr)iterator.next());
            }
            iterator = packageDescr.getRules().iterator();
            while (iterator.hasNext()) {
                this.addRule((RuleDescr)iterator.next());
            }
        }
        if (this.generatedClassList.size() > 0) {
            this.compileAll();
        }
    }

    private void validatePackageName(PackageDescr packageDescr) {
        if (packageDescr.getName() == null || "".equals(packageDescr.getName())) {
            throw new MissingPackageNameException("Missing package name for rule package.");
        }
    }

    private void validateUniqueRuleNames(PackageDescr packageDescr) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = packageDescr.getRules().iterator();
        while (iterator.hasNext()) {
            RuleDescr ruleDescr = (RuleDescr)iterator.next();
            String string = ruleDescr.getName();
            if (hashSet.contains(string)) {
                this.results.add(new ParserError("Duplicate rule name: " + string, ruleDescr.getLine(), ruleDescr.getColumn()));
            }
            hashSet.add(string);
        }
    }

    private Package newPackage(PackageDescr packageDescr) {
        Package package_ = new Package(packageDescr.getName(), this.configuration.getClassLoader());
        this.packageStoreWrapper = new PackageStore(package_.getPackageCompilationData());
        this.mergePackage(package_, packageDescr);
        return package_;
    }

    private void mergePackage(Package package_, PackageDescr packageDescr) {
        List list = packageDescr.getImports();
        Object object = list.iterator();
        while (object.hasNext()) {
            package_.addImport((String)object.next());
        }
        object = new ClassTypeResolver(list, package_.getPackageCompilationData().getClassLoader());
        Map map = packageDescr.getGlobals();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            try {
                Class clazz = object.resolveType(string2);
                package_.addGlobal(string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                new GlobalError(string);
            }
        }
    }

    private void addClassCompileTask(String string, String string2, MemoryResourceReader memoryResourceReader, ErrorHandler errorHandler) {
        String string3 = string.replace('.', '/') + ".java";
        memoryResourceReader.add(string3, string2.getBytes());
        this.errorHandlers.put(string3, errorHandler);
        this.generatedClassList.add(string);
    }

    private void addFunction(FunctionDescr functionDescr) {
        FunctionBuilder functionBuilder = new FunctionBuilder();
        this.addClassCompileTask(this.pkg.getName() + "." + this.ucFirst(functionDescr.getName()), functionBuilder.build(this.pkg, functionDescr), this.src, new FunctionErrorHandler(functionDescr, "Function Compilation error"));
    }

    private void addRule(RuleDescr ruleDescr) {
        String string = this.getUniqueLegalName(this.pkg.getName(), ruleDescr.getName(), "java", (ResourceReader)this.src);
        ruleDescr.SetClassName(this.ucFirst(string));
        RuleBuilder ruleBuilder = new RuleBuilder(this.getTypeResolver(), this.classFieldExtractorCache);
        ruleBuilder.build(this.pkg, ruleDescr);
        this.results.addAll(ruleBuilder.getErrors());
        Rule rule = ruleBuilder.getRule();
        if (ruleBuilder.getRuleClass() != null) {
            this.addRuleSemantics(ruleBuilder, rule, ruleDescr);
        }
        this.pkg.addRule(rule);
    }

    private TypeResolver getTypeResolver() {
        if (this.typeResolver == null) {
            this.typeResolver = new ClassTypeResolver(this.pkg.getImports(), this.pkg.getPackageCompilationData().getClassLoader());
            this.typeResolver.addImport(this.pkg.getName() + ".*");
            this.typeResolver.addImport("java.lang.*");
        }
        return this.typeResolver;
    }

    public void compileRule(RuleBuilder ruleBuilder, Rule rule, RuleDescr ruleDescr) {
        this.addRuleSemantics(ruleBuilder, rule, ruleDescr);
        this.compileAll();
    }

    private void addRuleSemantics(RuleBuilder ruleBuilder, Rule rule, RuleDescr ruleDescr) {
        this.addClassCompileTask(this.pkg.getName() + "." + ruleDescr.getClassName(), ruleBuilder.getRuleClass(), this.src, new RuleErrorHandler(ruleDescr, rule, "Rule Compilation error"));
        Iterator iterator = ruleBuilder.getInvokers().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = ruleBuilder.getInvokerLookups().get(string);
            if (v != null) {
                this.pkg.getPackageCompilationData().putInvoker(string, v);
            }
            String string2 = (String)ruleBuilder.getInvokers().get(string);
            PatternDescr patternDescr = (PatternDescr)ruleBuilder.getDescrLookups().get(string);
            this.addClassCompileTask(string, string2, this.src, new RuleInvokerErrorHandler(patternDescr, rule, "Unable to generate rule invoker."));
        }
    }

    public Package getPackage() {
        if (this.hasErrors()) {
            this.pkg.setError(this.printErrors());
        }
        return this.pkg;
    }

    private void compileAll() {
        String[] stringArray = new String[this.generatedClassList.size()];
        this.generatedClassList.toArray(stringArray);
        CompilationResult compilationResult = this.compiler.compile(stringArray, (ResourceReader)this.src, (ResourceStore)this.packageStoreWrapper, this.pkg.getPackageCompilationData().getClassLoader());
        if (compilationResult.getErrors().length > 0) {
            ErrorHandler errorHandler;
            Object object;
            for (int i = 0; i < compilationResult.getErrors().length; ++i) {
                object = compilationResult.getErrors()[i];
                errorHandler = (ErrorHandler)this.errorHandlers.get(object.getFileName());
                if (errorHandler instanceof RuleErrorHandler) {
                    RuleErrorHandler ruleErrorHandler = (RuleErrorHandler)errorHandler;
                }
                errorHandler.addError((CompilationProblem)object);
            }
            Collection collection = this.errorHandlers.values();
            object = collection.iterator();
            while (object.hasNext()) {
                errorHandler = (ErrorHandler)object.next();
                if (!errorHandler.isInError()) continue;
                if (!(errorHandler instanceof RuleInvokerErrorHandler)) {
                    this.results.add(errorHandler.getError());
                    continue;
                }
                System.err.println("Warning: An error occurred compiling a semantic invoker. Errors should have been reported elsewhere.");
            }
        }
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public DroolsError[] getErrors() {
        return this.results.toArray(new DroolsError[this.results.size()]);
    }

    public String printErrors() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            DroolsError droolsError = (DroolsError)iterator.next();
            stringBuffer.append(droolsError.getMessage());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String getUniqueLegalName(String string, String string2, String string3, ResourceReader resourceReader) {
        String string4 = "Rule_" + string2.replaceAll("[^\\w$]", "_");
        int n = -1;
        boolean bl = true;
        while (bl) {
            String string5 = string.replaceAll("\\.", "/") + string4 + "_" + ++n + string3;
            bl = resourceReader.isAvailable(string5);
        }
        if (n >= 0) {
            string4 = string4 + "_" + n;
        }
        return string4;
    }

    private void loadCompiler() {
        switch (this.configuration.getCompiler()) {
            case 1: {
                if (!"1.4".intern().equals(this.configuration.getJavaLanguageLevel())) {
                    throw new RuntimeDroolsException("Incompatible Java language level with selected compiler");
                }
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("janino");
                break;
            }
            default: {
                EclipseJavaCompilerSettings eclipseJavaCompilerSettings = new EclipseJavaCompilerSettings();
                eclipseJavaCompilerSettings.getMap().put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.configuration.getJavaLanguageLevel());
                eclipseJavaCompilerSettings.getMap().put("org.eclipse.jdt.core.compiler.source", this.configuration.getJavaLanguageLevel());
                this.compiler = new EclipseJavaCompiler(eclipseJavaCompilerSettings);
            }
        }
    }

    private String ucFirst(String string) {
        return string.toUpperCase().charAt(0) + string.substring(1);
    }

    public static class FunctionErrorHandler
    extends ErrorHandler {
        private FunctionDescr descr;

        public FunctionErrorHandler(FunctionDescr functionDescr, String string) {
            this.descr = functionDescr;
            this.message = string;
        }

        public DroolsError getError() {
            return new FunctionError(this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static class RuleInvokerErrorHandler
    extends RuleErrorHandler {
        public RuleInvokerErrorHandler(PatternDescr patternDescr, Rule rule, String string) {
            super(patternDescr, rule, string);
        }
    }

    public static class RuleErrorHandler
    extends ErrorHandler {
        private PatternDescr descr;
        private Rule rule;

        public RuleErrorHandler(PatternDescr patternDescr, Rule rule, String string) {
            this.descr = patternDescr;
            this.rule = rule;
            this.message = string;
        }

        public DroolsError getError() {
            return new RuleError(this.rule, this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static abstract class ErrorHandler {
        private List errors = new ArrayList();
        protected String message;
        private boolean inError = false;

        public boolean isInError() {
            return this.inError;
        }

        public void addError(CompilationProblem compilationProblem) {
            this.errors.add(compilationProblem);
            this.inError = true;
        }

        public abstract DroolsError getError();

        protected CompilationProblem[] collectCompilerProblems() {
            if (this.errors.size() == 0) {
                return null;
            }
            CompilationProblem[] compilationProblemArray = new CompilationProblem[this.errors.size()];
            this.errors.toArray(compilationProblemArray);
            return compilationProblemArray;
        }
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 4056984379574366454L;

        public MissingPackageNameException(String string) {
            super(string);
        }
    }
}

