/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.sr;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.macro.SOPInstanceReference;

public class ReferencedRequest
extends Module {
    public ReferencedRequest(DicomObject dcmobj) {
        super(dcmobj);
    }

    public ReferencedRequest() {
        super((DicomObject)new BasicDicomObject());
    }

    public static ReferencedRequest[] toReferencedRequests(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        ReferencedRequest[] a = new ReferencedRequest[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new ReferencedRequest(sq.getDicomObject(i));
        }
        return a;
    }

    public String getStudyInstanceUID() {
        return this.dcmobj.getString(0x20000D);
    }

    public void setStudyInstanceUID(String s) {
        this.dcmobj.putString(0x20000D, VR.UI, s);
    }

    public SOPInstanceReference getReferencedStudySOPInstance() {
        DicomObject item = this.dcmobj.getNestedDicomObject(528656);
        return item != null ? new SOPInstanceReference(item) : null;
    }

    public void setReferencedStudySOPInstance(SOPInstanceReference refSOP) {
        this.updateSequence(528656, refSOP);
    }

    public String getAccessionNumber() {
        return this.dcmobj.getString(524368);
    }

    public void setAccessionNumber(String s) {
        this.dcmobj.putString(524368, VR.SH, s);
    }

    public String getPlacerOrderNumberImagingServiceRequest() {
        return this.dcmobj.getString(4202518);
    }

    public void setPlacerOrderNumberImagingServiceRequest(String s) {
        this.dcmobj.putString(4202518, VR.LO, s);
    }

    public String getFillerOrderNumberImagingServiceRequest() {
        return this.dcmobj.getString(4202519);
    }

    public void setFillerOrderNumberImagingServiceRequest(String s) {
        this.dcmobj.putString(4202519, VR.LO, s);
    }

    public String getRequestedProcedureID() {
        return this.dcmobj.getString(0x401001);
    }

    public void setRequestedProcedureID(String s) {
        this.dcmobj.putString(0x401001, VR.SH, s);
    }

    public String getRequestedProcedureDescription() {
        return this.dcmobj.getString(3280992);
    }

    public void setRequestedProcedureDescription(String s) {
        this.dcmobj.putString(3280992, VR.LO, s);
    }

    public Code getRequestedProcedureCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(3280996);
        return item != null ? new Code(item) : null;
    }

    public void setRequestedProcedureCode(Code code) {
        this.updateSequence(3280996, code);
    }

    public String getReasonForTheRequestedProcedure() {
        return this.dcmobj.getString(4198402);
    }

    public void setReasonForTheRequestedProcedure(String s) {
        this.dcmobj.putString(4198402, VR.LO, s);
    }

    public Code getReasonForRequestedProcedureCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4198410);
        return item != null ? new Code(item) : null;
    }

    public void setReasonForRequestedProcedureCode(Code code) {
        this.updateSequence(4198410, code);
    }
}

