/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.spatial;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.spatial.GraphicCoordinatesData;

public class Fiducial
extends GraphicCoordinatesData {
    public Fiducial(DicomObject dcmobj) {
        super(dcmobj);
    }

    public Fiducial() {
        super((DicomObject)new BasicDicomObject());
    }

    public static Fiducial[] toFiducials(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        Fiducial[] a = new Fiducial[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Fiducial(sq.getDicomObject(i));
        }
        return a;
    }

    public String getFiducialIdentifier() {
        return this.dcmobj.getString(7340816);
    }

    public void setFiducialIdentifier(String sh) {
        this.dcmobj.putString(7340816, VR.SH, sh);
    }

    public void setFiducialIdentifierCode(Code code) {
        this.updateSequence(7340817, code);
    }

    public Code getFiducialIdentifierCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(7340817);
        return item != null ? new Code(item) : null;
    }

    public String getFiducialUID() {
        return this.dcmobj.getString(7340826);
    }

    public void setFiducialUID(String ui) {
        this.dcmobj.putString(7340826, VR.UI, ui);
    }

    public String getFiducialDescription() {
        return this.dcmobj.getString(7340815);
    }

    public void setFiducialDescription(String st) {
        this.dcmobj.putString(7340815, VR.ST, st);
    }

    public String getShapeType() {
        return this.dcmobj.getString(7340806);
    }

    public void setShapeType(String cs) {
        this.dcmobj.putString(7340806, VR.CS, cs);
    }

    public int getNumberOfContourPoints() {
        return this.dcmobj.getInt(805699654);
    }

    public void setNumberOfContourPoints(int is) {
        this.dcmobj.putInt(805699654, VR.IS, is);
    }

    public float[] getContourData() {
        return this.dcmobj.getFloats(805699664);
    }

    public void setContourData(float[] ds) {
        this.dcmobj.putFloats(805699664, VR.DS, ds);
    }

    public double getContourUncertaintyRadius() {
        return this.dcmobj.getDouble(7340818);
    }

    public void setContourUncertaintyRadius(double fd) {
        this.dcmobj.putDouble(7340818, VR.FD, fd);
    }

    public GraphicCoordinatesData[] getGraphicCoordinatesData() {
        return GraphicCoordinatesData.toGraphicCoordinatesData(this.dcmobj.get(7340824));
    }

    public void setGraphicCoordinatesData(GraphicCoordinatesData[] gcds) {
        this.updateSequence(7340824, gcds);
    }
}

