/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.pr;

import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;

public class TextObject
extends Module {
    public TextObject(DicomObject dcmobj) {
        super(dcmobj);
    }

    public static TextObject[] toTextObjects(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        TextObject[] a = new TextObject[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new TextObject(sq.getDicomObject(i));
        }
        return a;
    }

    public String getUnformattedTextValue() {
        return this.dcmobj.getString(0x700006);
    }

    public float[] getBoundingBoxTopLeftHandCorner() {
        return this.dcmobj.getFloats(0x700010);
    }

    public float[] getBoundingBoxBottomRightHandCorner() {
        return this.dcmobj.getFloats(0x700011);
    }

    public float[] getAnchorPoint() {
        return this.dcmobj.getFloats(7340052);
    }

    public boolean getAnchorPointVisibility() {
        String visible = this.dcmobj.getString(7340053);
        if (visible == null) {
            return false;
        }
        return visible.equalsIgnoreCase("Y");
    }

    public String getAnchorPointAnnotationUnits() {
        return this.dcmobj.getString(0x700004);
    }

    public String getBoundingBoxAnnotationUnits() {
        return this.dcmobj.getString(0x700003);
    }

    public String getBoundingBoxTextHorizontalJustification() {
        return this.dcmobj.getString(7340050);
    }

    public void setBoundingBoxTextHorizontalJustification(String justification) {
        this.dcmobj.putString(7340050, VR.CS, justification);
    }
}

