/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.pr;

import java.util.HashMap;
import java.util.Map;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.pr.DisplayShutterModule;

public class GraphicLayerModule
extends Module {
    public GraphicLayerModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public static Map toGraphicLayerMap(DicomObject dcmobj) {
        DicomElement sq = dcmobj.get(0x700060);
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        int sqCount = sq.countItems();
        HashMap<String, GraphicLayerModule> layers = new HashMap<String, GraphicLayerModule>(sqCount);
        for (int i = 0; i < sqCount; ++i) {
            GraphicLayerModule glm = new GraphicLayerModule(sq.getDicomObject(i));
            layers.put(glm.getGraphicLayer(), glm);
        }
        return layers;
    }

    public String getGraphicLayer() {
        return this.dcmobj.getString(0x700002);
    }

    public int getGraphicLayerRecommendedDisplayGrayscaleValue() {
        return this.dcmobj.getInt(0x700066, 32768);
    }

    public int[] getGraphicLayerRecommendedDisplayCIELabValue() {
        return this.dcmobj.getInts(7341057);
    }

    public float[] getFloatLab() {
        return DisplayShutterModule.convertToFloatLab(this.getGraphicLayerRecommendedDisplayCIELabValue());
    }

    public int getGraphicLayerOrder() {
        return this.dcmobj.getInt(7340130);
    }

    public String getGraphicLayerDescription() {
        return this.dcmobj.getString(7340136);
    }

    @Deprecated
    public int[] getGraphicLayerRecommendedDisplayRGBValue() {
        return this.dcmobj.getInts(0x700067);
    }
}

