/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.pr;

import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.ImageSOPInstanceReference;

public class DisplayedAreaModule
extends Module {
    public DisplayedAreaModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public static DisplayedAreaModule[] toDisplayedAreaModules(DicomObject dcmobj) {
        DicomElement sq = dcmobj.get(7340122);
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        DisplayedAreaModule[] a = new DisplayedAreaModule[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new DisplayedAreaModule(sq.getDicomObject(i));
        }
        return a;
    }

    public ImageSOPInstanceReference[] getImageSOPInstanceReferences() {
        return ImageSOPInstanceReference.toImageSOPInstanceReferences(this.dcmobj.get(528704));
    }

    public int[] getDisplayedAreaTopLeftHandCorner() {
        return this.dcmobj.getInts(7340114);
    }

    public void setDisplayedAreaTopLeftHandCorner(int[] tlhc) {
        this.dcmobj.putInts(7340114, VR.IS, tlhc);
    }

    public int[] getDisplayedAreaBottomRightHandCorner() {
        return this.dcmobj.getInts(7340115);
    }

    public void setDisplayedAreaBottomrRightHandCorner(int[] brhc) {
        this.dcmobj.putInts(7340115, VR.IS, brhc);
    }

    public String getPresentationSizeMode() {
        return this.dcmobj.getString(0x700100);
    }

    public void setPresentationSizeMode(String mode) {
        this.dcmobj.putString(0x700100, VR.CS, mode);
    }

    public float[] getPresentationPixelSpacing() {
        return this.dcmobj.getFloats(0x700101);
    }

    public void setPresentationPixelSpacing(float[] spacing) {
        this.dcmobj.putFloats(0x700101, VR.DS, spacing);
    }

    public int[] getPresentationPixelAspectRatio() {
        return this.dcmobj.getInts(7340290);
    }

    public void setPresentationPixelAspectRatio(int[] aspect) {
        this.dcmobj.putInts(0x700101, VR.IS, aspect);
    }

    public float getPresentationPixelMagnificationRatio() {
        return this.dcmobj.getFloat(7340291);
    }

    public void setPresentationPixelMagnificationRatio(float magnify) {
        this.dcmobj.putFloat(7340291, VR.DS, magnify);
    }
}

