/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.pr;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;

public class DisplayShutterModule
extends Module {
    public DisplayShutterModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public String[] getShutterShapes() {
        return this.dcmobj.getStrings(1578496);
    }

    public void setShutterShapes(String[] shapes) {
        this.dcmobj.putStrings(1578496, VR.CS, shapes);
    }

    public int[] getCenterOfCircularShutter() {
        return this.dcmobj.getInts(1578512);
    }

    public void setCenterOfCircularShutter(int[] center) {
        this.dcmobj.putInts(1578512, VR.IS, center);
    }

    public int getRadiusOfCircularShutter() {
        return this.dcmobj.getInt(1578514);
    }

    public void setRadiusOfCircularShutter(int radius) {
        this.dcmobj.putInt(1578514, VR.IS, radius);
    }

    public int getShutterLeftVerticalEdge() {
        return this.dcmobj.getInt(1578498);
    }

    public int getShutterRightVerticalEdge() {
        return this.dcmobj.getInt(1578500);
    }

    public int getShutterUpperHorizontalEdge() {
        return this.dcmobj.getInt(1578502);
    }

    public int getShutterLowerHorizontalEdge() {
        return this.dcmobj.getInt(1578504);
    }

    public void setShutterLeftVerticalEdge(int value) {
        this.dcmobj.putInt(1578498, VR.IS, value);
    }

    public void setShutterRightVerticalEdge(int value) {
        this.dcmobj.putInt(1578500, VR.IS, value);
    }

    public void setShutterUpperHorizontalEdge(int value) {
        this.dcmobj.putInt(1578502, VR.IS, value);
    }

    public void setShutterLowerHorizontalEdge(int value) {
        this.dcmobj.putInt(1578504, VR.IS, value);
    }

    public int getShutterPresentationValue() {
        return this.dcmobj.getInt(1578530);
    }

    public int[] getShutterPresentationColorCIELabValue() {
        return this.dcmobj.getInts(1578532);
    }

    public float[] getFloatLab() {
        int[] lab = this.getShutterPresentationColorCIELabValue();
        return DisplayShutterModule.convertToFloatLab(lab);
    }

    public static float[] convertToFloatLab(int[] lab) {
        if (lab == null || lab.length != 3) {
            return null;
        }
        float[] ret = new float[]{(float)lab[0] / 655.35f, (float)lab[1] / 257.0f - 128.0f, (float)lab[2] / 257.0f - 128.0f};
        return ret;
    }

    public int[] getVerticesOfThePolygonalShutter() {
        return this.dcmobj.getInts(1578528);
    }
}

