/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.lut;

import org.dcm4che2.iod.module.lut.ILut;

public class WindowLevelLut
implements ILut {
    private static final float RANGE_BIAS = 0.5f;
    private static final float CENTER_BIAS = -0.5f;
    private static final int WIDTH_BIAS = -1;
    private float center;
    private float width;
    private String description;
    private int ymin;
    private int ymax;

    public WindowLevelLut(float center, float width, String description) {
        this(center, width, description, 0, 255);
    }

    public WindowLevelLut(float center, float width, String description, int ymin, int ymax) {
        this.center = center + -0.5f;
        this.width = width + -1.0f;
        this.description = description;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public float lookup(float value) {
        if (value < this.center - this.width / 2.0f) {
            return this.ymin;
        }
        if (value > this.center + this.width / 2.0f) {
            return this.ymax;
        }
        return ((value - this.center) / this.width + 0.5f) * (float)(this.ymax - this.ymin) + (float)this.ymin;
    }

    public float getCenter() {
        return this.center - -0.5f;
    }

    public void setCenter(float center) {
        this.center = center + -0.5f;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public float getWidth() {
        return this.width - -1.0f;
    }

    public void setWidth(float width) {
        this.width = width + -1.0f;
    }

    public int getYmax() {
        return this.ymax;
    }

    public void setYmax(int ymax) {
        this.ymax = ymax;
    }

    public int getYmin() {
        return this.ymin;
    }

    public void setYmin(int ymin) {
        this.ymin = ymin;
    }

    public int lookup(int value) {
        return (int)this.lookup((float)value);
    }
}

