/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.lut;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.lut.ILut;
import org.dcm4che2.iod.module.lut.Lut;
import org.dcm4che2.iod.module.lut.WindowLevelLut;

public class VoiLutModule
extends Module {
    public VoiLutModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public ILut getVOILut(String name) {
        Lut[] luts;
        String[] wlExplanations = this.getWindowCenterWidthExplanations();
        if (wlExplanations != null && wlExplanations.length > 0) {
            if (name == null) {
                return new WindowLevelLut(this.getWindowCenter()[0], this.getWindowWidth()[0], wlExplanations[0]);
            }
            for (int i = 0; i < wlExplanations.length; ++i) {
                if (!name.equals(wlExplanations[i])) continue;
                return new WindowLevelLut(this.getWindowCenter()[i], this.getWindowWidth()[i], wlExplanations[i]);
            }
        }
        if ((luts = this.getVOILUTs()) == null || luts.length == 0) {
            return null;
        }
        if (name == null) {
            throw new UnsupportedOperationException("Still need to implement Lut class generally.");
        }
        for (int i = 0; i < luts.length; ++i) {
            Lut lut = luts[i];
            if (!name.equals(lut.getLUTExplanation())) continue;
            throw new UnsupportedOperationException("Still need to implement Lut class generally.");
        }
        return null;
    }

    public Lut[] getVOILUTs() {
        return Lut.toLUTs(this.dcmobj.get(2633744));
    }

    public void setVOILUTs(Lut[] luts) {
        this.updateSequence(2633744, luts);
    }

    public void setWindowCenter(float[] centers) {
        this.dcmobj.putFloats(2625616, VR.DS, centers);
    }

    public float[] getWindowCenter() {
        return this.dcmobj.getFloats(2625616);
    }

    public void setWindowWidth(float[] widths) {
        this.dcmobj.putFloats(2625617, VR.DS, widths);
    }

    public float[] getWindowWidth() {
        return this.dcmobj.getFloats(2625617);
    }

    public void setWindowCenterWidthExplanation(String[] explanations) {
        this.dcmobj.putStrings(2625621, VR.LO, explanations);
    }

    public String[] getWindowCenterWidthExplanations() {
        return this.dcmobj.getStrings(2625621);
    }
}

