/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.general;

import java.util.Date;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;

public class DigitalSignatures
extends Module {
    public DigitalSignatures(DicomObject dcmobj) {
        super(dcmobj);
    }

    public DigitalSignatures() {
        super((DicomObject)new BasicDicomObject());
    }

    public static DigitalSignatures[] toDigitalSignatures(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        DigitalSignatures[] a = new DigitalSignatures[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new DigitalSignatures(sq.getDicomObject(i));
        }
        return a;
    }

    public int getMACIDNumber() {
        return this.dcmobj.getInt(0x4000005);
    }

    public void setMACIDNumber(int i) {
        this.dcmobj.putInt(0x4000005, VR.US, i);
    }

    public String getDigitalSignatureUID() {
        return this.dcmobj.getString(0x4000100);
    }

    public void setDigitalSignatureUID(String s) {
        this.dcmobj.putString(0x4000100, VR.UI, s);
    }

    public Date getDigitalSignatureDateTime() {
        return this.dcmobj.getDate(67109125);
    }

    public void setDigitalSignatureDateTime(Date d) {
        this.dcmobj.putDate(67109125, VR.DT, d);
    }

    public String getCertificateType() {
        return this.dcmobj.getString(0x4000110);
    }

    public void setCertificateType(String s) {
        this.dcmobj.putString(0x4000110, VR.CS, s);
    }

    public byte[] getCertificateOfSigner() {
        return this.dcmobj.getBytes(67109141);
    }

    public void setCertificateOfSigner(byte[] b) {
        this.dcmobj.putBytes(67109141, VR.OB, b);
    }

    public byte[] getSignature() {
        return this.dcmobj.getBytes(67109152);
    }

    public void setSignature(byte[] b) {
        this.dcmobj.putBytes(67109152, VR.OB, b);
    }

    public String getCertifiedTimestampType() {
        return this.dcmobj.getString(67109637);
    }

    public void setCertifiedTimestampType(String s) {
        this.dcmobj.putString(67109637, VR.CS, s);
    }

    public byte[] getCertifiedTimestamp() {
        return this.dcmobj.getBytes(67109648);
    }

    public void setCertifiedTimestamp(byte[] b) {
        this.dcmobj.putBytes(67109648, VR.OB, b);
    }

    public Code getDigitalSignaturePurposeCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(0x4000401);
        return item != null ? new Code(item) : null;
    }

    public void setDigitalSignaturePurposeCode(Code code) {
        this.updateSequence(0x4000401, code);
    }
}

