/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.dx;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.macro.PatientOrientationCode;
import org.dcm4che2.iod.module.macro.ViewCode;

public class DXPositioningModule
extends Module {
    public DXPositioningModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public void setProjectionEponymousNameCode(Code code) {
        this.updateSequence(1593604, code);
    }

    public Code getProjectionEponymousNameCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(1593604);
        return item != null ? new Code(item) : null;
    }

    public void setPatientPosition(String cs) {
        this.dcmobj.putString(1593600, VR.CS, cs);
    }

    public String getPatientPosition() {
        return this.dcmobj.getString(1593600);
    }

    public void setViewPosition(String cs) {
        this.dcmobj.putString(1593601, VR.CS, cs);
    }

    public String getViewPosition() {
        return this.dcmobj.getString(1593601);
    }

    public void setViewCode(ViewCode code) {
        this.updateSequence(5505568, code);
    }

    public ViewCode getViewCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(5505568);
        return item != null ? new ViewCode(item) : null;
    }

    public void setPatientOrientationCode(PatientOrientationCode code) {
        this.updateSequence(5506064, code);
    }

    public PatientOrientationCode getPatientOrientationCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(5506064);
        return item != null ? new PatientOrientationCode(item) : null;
    }

    public void setPatientGantryRelationshipCode(Code code) {
        this.updateSequence(5506068, code);
    }

    public Code getPatientGantryRelationshipCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(5506068);
        return item != null ? new Code(item) : null;
    }

    public void setDistanceSourceToPatient(float f) {
        this.dcmobj.putFloat(0x181111, VR.DS, f);
    }

    public float getDistanceSourceToPatient() {
        return this.dcmobj.getFloat(0x181111);
    }

    public void setDistanceSourceToDetector(float f) {
        this.dcmobj.putFloat(0x181110, VR.DS, f);
    }

    public float getDistanceSourceToDetector() {
        return this.dcmobj.getFloat(0x181110);
    }

    public void setEstimatedRadiographicMagnificationFactor(float f) {
        this.dcmobj.putFloat(0x181114, VR.DS, f);
    }

    public float getEstimatedRadiographicMagnificationFactor() {
        return this.dcmobj.getFloat(0x181114);
    }

    public void setPositionerType(String cs) {
        this.dcmobj.putString(1578248, VR.CS, cs);
    }

    public String getPositionerType() {
        return this.dcmobj.getString(1578248);
    }

    public void setPositonerPrimaryAngle(float f) {
        this.dcmobj.putFloat(1578256, VR.DS, f);
    }

    public float getPositionerPrimaryAngle() {
        return this.dcmobj.getFloat(1578256);
    }

    public void setPositonerSecondaryAngle(float f) {
        this.dcmobj.putFloat(0x181511, VR.DS, f);
    }

    public float getPositionerSecondaryAngle() {
        return this.dcmobj.getFloat(0x181511);
    }

    public void setDetectorPrimaryAngle(float f) {
        this.dcmobj.putFloat(1578288, VR.DS, f);
    }

    public float getDetectorPrimaryAngle() {
        return this.dcmobj.getFloat(1578288);
    }

    public void setDetectorSecondaryAngle(float f) {
        this.dcmobj.putFloat(1578289, VR.DS, f);
    }

    public float getDetectorSecondaryAngle() {
        return this.dcmobj.getFloat(1578289);
    }

    public void setColumnAngulation(float f) {
        this.dcmobj.putFloat(1578064, VR.DS, f);
    }

    public float getColumnAngulation() {
        return this.dcmobj.getFloat(1578064);
    }

    public void setTableType(String cs) {
        this.dcmobj.putString(1577274, VR.CS, cs);
    }

    public String getTableType() {
        return this.dcmobj.getString(1577274);
    }

    public void setTableAngle(float f) {
        this.dcmobj.putFloat(0x181138, VR.DS, f);
    }

    public float getTableAngle() {
        return this.dcmobj.getFloat(0x181138);
    }

    public void setBodyPartThickness(float f) {
        this.dcmobj.putFloat(1577376, VR.DS, f);
    }

    public float getBodyPartThickness() {
        return this.dcmobj.getFloat(1577376);
    }

    public void setCompressionForce(float f) {
        this.dcmobj.putFloat(1577378, VR.DS, f);
    }

    public float getCompressionForce() {
        return this.dcmobj.getFloat(1577378);
    }
}

