/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.composite;

import java.util.Date;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.macro.SOPInstanceReference;

public class PatientModule
extends Module {
    public PatientModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public String getPatientName() {
        return this.dcmobj.getString(0x100010);
    }

    public void setPatientName(String s) {
        this.dcmobj.putString(0x100010, VR.PN, s);
    }

    public String getPatientID() {
        return this.dcmobj.getString(0x100020);
    }

    public void setPatientID(String s) {
        this.dcmobj.putString(0x100020, VR.LO, s);
    }

    public String getIssuerOfPatientID() {
        return this.dcmobj.getString(0x100021);
    }

    public void setIssuerOfPatientID(String s) {
        this.dcmobj.putString(0x100021, VR.LO, s);
    }

    public Date getPatientBirthDate() {
        return this.dcmobj.getDate(0x100030);
    }

    public void setPatientBirthDate(Date d) {
        this.dcmobj.putDate(0x100030, VR.DA, d);
    }

    public Date getPatientBirthTime() {
        return this.dcmobj.getDate(1048626);
    }

    public void setPatientBirthTime(Date d) {
        this.dcmobj.putDate(1048626, VR.TM, d);
    }

    public String getPatientSex() {
        return this.dcmobj.getString(0x100040);
    }

    public void setPatientSex(String s) {
        this.dcmobj.putString(0x100040, VR.CS, s);
    }

    public SOPInstanceReference getReferencedPatientSOPInstance() {
        DicomObject item = this.dcmobj.getNestedDicomObject(528672);
        return item != null ? new SOPInstanceReference(item) : null;
    }

    public void setReferencedPatientSOPInstance(SOPInstanceReference refSOP) {
        this.updateSequence(528672, refSOP);
    }

    public String[] getOtherPatientIDs() {
        return this.dcmobj.getStrings(0x101000);
    }

    public void setOtherPatientIDs(String[] ss) {
        this.dcmobj.putStrings(0x101000, VR.LO, ss);
    }

    public String[] getOtherPatientNames() {
        return this.dcmobj.getStrings(0x101001);
    }

    public void setOtherPatientNames(String[] ss) {
        this.dcmobj.putStrings(0x101001, VR.PN, ss);
    }

    public String getEthnicGroup() {
        return this.dcmobj.getString(1057120);
    }

    public void setEthnicGroup(String s) {
        this.dcmobj.putString(1057120, VR.SH, s);
    }

    public String getPatientComments() {
        return this.dcmobj.getString(0x104000);
    }

    public void setPatientComments(String s) {
        this.dcmobj.putString(0x104000, VR.LT, s);
    }

    public String getPatientIdentifyRemoved() {
        return this.dcmobj.getString(1179746);
    }

    public void setPatientIdentifyRemoved(String s) {
        this.dcmobj.putString(1179746, VR.CS, s);
    }

    public String getDeidentificationMethod() {
        return this.dcmobj.getString(1179747);
    }

    public void setDeidentificationMethod(String s) {
        this.dcmobj.putString(1179747, VR.LO, s);
    }

    public Code[] getDeidentificationMethodCodes() {
        return Code.toCodes(this.dcmobj.get(1179748));
    }

    public void setDeidentificationMethodCodes(Code[] codes) {
        this.updateSequence(1179748, codes);
    }
}

