/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.composite;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.value.PixelRepresentation;

public class ImagePixel
extends Module {
    public ImagePixel(DicomObject dcmobj) {
        super(dcmobj);
    }

    public ImagePixel() {
        super((DicomObject)new BasicDicomObject());
    }

    public int getSamplesPerPixel() {
        return this.dcmobj.getInt(0x280002);
    }

    public void setSamplesPerPixel(int i) {
        this.dcmobj.putInt(0x280002, VR.US, i);
    }

    public String getPhotometricInterpretation() {
        return this.dcmobj.getString(2621444);
    }

    public void setPhotometricInterpretation(String s) {
        this.dcmobj.putString(2621444, VR.CS, s);
    }

    public int getRows() {
        return this.dcmobj.getInt(2621456);
    }

    public void setRows(int i) {
        this.dcmobj.putInt(2621456, VR.US, i);
    }

    public int getColumns() {
        return this.dcmobj.getInt(2621457);
    }

    public void setColumns(int i) {
        this.dcmobj.putInt(2621457, VR.US, i);
    }

    public int getBitsAllocated() {
        return this.dcmobj.getInt(2621696);
    }

    public void setBitsAllocated(int i) {
        this.dcmobj.putInt(2621696, VR.US, i);
    }

    public int getBitsStored() {
        return this.dcmobj.getInt(2621697);
    }

    public void setBitsStored(int i) {
        this.dcmobj.putInt(2621697, VR.US, i);
    }

    public int getHighBit() {
        return this.dcmobj.getInt(2621698);
    }

    public void setHighBit(int i) {
        this.dcmobj.putInt(2621698, VR.US, i);
    }

    public int getPixelRepresentation() {
        return this.dcmobj.getInt(2621699);
    }

    public void setPixelRepresentation(int i) {
        this.dcmobj.putInt(2621699, VR.US, i);
    }

    public int getPlanarConfiguration() {
        return this.dcmobj.getInt(2621446);
    }

    public void setPlanarConfiguration(int i) {
        this.dcmobj.putInt(2621446, VR.US, i);
    }

    public int[] getPixelAspectRatio() {
        return this.dcmobj.getInts(2621492);
    }

    public void setPixelAspectRatio(int[] ints) {
        this.dcmobj.putInts(2621492, VR.IS, ints);
    }

    public byte[] getPixelData() {
        return this.dcmobj.getBytes(2145386512, false);
    }

    public void setPixelData(byte[] b) {
        this.dcmobj.putBytes(2145386512, VR.OW, b, false);
    }

    public int getSmallestImagePixelValue() {
        return this.dcmobj.getInt(2621702);
    }

    public void setSmallestImagePixelValue(int s) {
        this.dcmobj.putInt(2621702, PixelRepresentation.isSigned(this.dcmobj) ? VR.SS : VR.US, s);
    }

    public int getLargestImagePixelValue() {
        return this.dcmobj.getInt(2621703);
    }

    public void setLargestImagePixelValue(int s) {
        this.dcmobj.putInt(2621703, PixelRepresentation.isSigned(this.dcmobj) ? VR.SS : VR.US, s);
    }

    public int[] getRedPaletteColorLookupTableDescriptor() {
        return this.dcmobj.getInts(2625793);
    }

    public void setRedPaletteColorLookupTableDescriptor(int[] ints) {
        this.dcmobj.putInts(2625793, VR.US, ints);
    }

    public int[] getGreenPaletteColorLookupTableDescriptor() {
        return this.dcmobj.getInts(2625794);
    }

    public void setGreenPaletteColorLookupTableDescriptor(int[] ints) {
        this.dcmobj.putInts(2625794, VR.US, ints);
    }

    public int[] getBluePaletteColorLookupTableDescriptor() {
        return this.dcmobj.getInts(2625795);
    }

    public void setBluePaletteColorLookupTableDescriptor(int[] ints) {
        this.dcmobj.putInts(2625795, VR.US, ints);
    }

    public byte[] getRedPaletteColorLookupTableData() {
        return this.dcmobj.getBytes(2626049, false);
    }

    public void setRedPaletteColorLookupTableData(byte[] b) {
        this.dcmobj.putBytes(2626049, VR.OW, b, false);
    }

    public byte[] getGreenPaletteColorLookupTableData() {
        return this.dcmobj.getBytes(2626050, false);
    }

    public void setGreenPaletteColorLookupTableData(byte[] b) {
        this.dcmobj.putBytes(2626050, VR.OW, b, false);
    }

    public byte[] getBluePaletteColorLookupTableData() {
        return this.dcmobj.getBytes(2626051, false);
    }

    public void setBluePaletteColorLookupTableData(byte[] b) {
        this.dcmobj.putBytes(2626051, VR.OW, b, false);
    }

    public byte[] getICCProfile() {
        return this.dcmobj.getBytes(0x282000, false);
    }

    public void setICCProfile(byte[] b) {
        this.dcmobj.putBytes(0x282000, VR.OB, b, false);
    }

    public int maxPossibleStoredValue() {
        return PixelRepresentation.isSigned(this.dcmobj) ? (1 << this.getBitsStored() - 1) - 1 : (1 << this.getBitsStored()) - 1;
    }

    public int minPossibleStoredValue() {
        return PixelRepresentation.isSigned(this.dcmobj) ? -this.maxPossibleStoredValue() - 1 : 0;
    }
}

