/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.composite;

import java.util.Date;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;

public class AcquisitionContext
extends Module {
    public AcquisitionContext(DicomObject dcmobj) {
        super(dcmobj);
    }

    public static AcquisitionContext[] toAcquisitionContexts(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        AcquisitionContext[] a = new AcquisitionContext[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new AcquisitionContext(sq.getDicomObject(i));
        }
        return a;
    }

    public void setValueType(String cs) {
        this.dcmobj.putString(0x40A040, VR.CS, cs);
    }

    public String getValueType() {
        return this.dcmobj.getString(0x40A040);
    }

    public void setConceptNameCode(Code c) {
        this.updateSequence(4235331, c);
    }

    public Code getConceptNameCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235331);
        return item != null ? new Code(item) : null;
    }

    public void setReferencedFrameNumbers(int[] us) {
        this.dcmobj.putInts(4235574, VR.US, us);
    }

    public int[] getReferencedFrameNumbers() {
        return this.dcmobj.getInts(4235574);
    }

    public void setNumericValue(float ds) {
        this.dcmobj.putFloat(4236042, VR.DS, ds);
    }

    public float getNumericValue() {
        return this.dcmobj.getFloat(4236042);
    }

    public void setMeasurementUnitsCode(Code c) {
        this.updateSequence(4196586, c);
    }

    public Code getMeasurementUnitsCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4196586);
        return item != null ? new Code(item) : null;
    }

    public Date getDateTime() {
        return this.dcmobj.getDate(4235553, 4235554);
    }

    public void setDateTime(Date d) {
        this.dcmobj.putDate(4235553, VR.DA, d);
        this.dcmobj.putDate(4235554, VR.TM, d);
    }

    public String getPersonName() {
        return this.dcmobj.getString(4235555);
    }

    public void setPersonName(String s) {
        this.dcmobj.putString(4235555, VR.PN, s);
    }

    public String getTextValue() {
        return this.dcmobj.getString(4235616);
    }

    public void setTextValue(String s) {
        this.dcmobj.putString(4235616, VR.UT, s);
    }

    public Code getConceptCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235624);
        return item != null ? new Code(item) : null;
    }

    public void setConceptCode(Code code) {
        this.updateSequence(4235624, code);
    }
}

