/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module;

import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.iod.validation.ValidationContext;
import org.dcm4che2.iod.validation.ValidationResult;

public class Module {
    private static final int[] INT0 = new int[0];
    protected final DicomObject dcmobj;

    public Module(DicomObject dcmobj) {
        if (dcmobj == null) {
            throw new NullPointerException("dcmobj");
        }
        this.dcmobj = dcmobj;
    }

    public DicomObject getDicomObject() {
        return this.dcmobj;
    }

    protected int[] getType1Tags() {
        return INT0;
    }

    protected int[] getType2Tags() {
        return INT0;
    }

    public void init() {
        int[] tags = this.getType2Tags();
        for (int i = 0; i < tags.length; ++i) {
            this.dcmobj.putNull(tags[i], null);
        }
    }

    public void validate(ValidationContext ctx, ValidationResult result) {
        int i;
        int[] tags = this.getType1Tags();
        for (i = 0; i < tags.length; ++i) {
            if (this.dcmobj.containsValue(tags[i])) continue;
            if (!this.dcmobj.contains(tags[i])) {
                result.logMissingAttribute(tags[i]);
                continue;
            }
            result.logMissingValue(tags[i]);
        }
        tags = this.getType2Tags();
        for (i = 0; i < tags.length; ++i) {
            if (this.dcmobj.contains(tags[i])) continue;
            result.logMissingAttribute(tags[i]);
        }
    }

    protected void updateSequence(int tag, Module module) {
        if (module != null) {
            this.dcmobj.putNestedDicomObject(tag, module.getDicomObject());
        } else {
            this.dcmobj.remove(528656);
        }
    }

    protected void updateSequence(int tag, Module[] module) {
        if (module != null) {
            DicomElement sq = this.dcmobj.putSequence(tag);
            for (int i = 0; i < module.length; ++i) {
                sq.addDicomObject(module[i].getDicomObject());
            }
        } else {
            this.dcmobj.remove(tag);
        }
    }
}

