/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.composite;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.iod.composite.CRImage;
import org.dcm4che2.iod.module.composite.ClinicalTrialSeriesModule;
import org.dcm4che2.iod.module.composite.ClinicalTrialStudyModule;
import org.dcm4che2.iod.module.composite.ClinicalTrialSubjectModule;
import org.dcm4che2.iod.module.composite.GeneralEquipmentModule;
import org.dcm4che2.iod.module.composite.GeneralSeriesModule;
import org.dcm4che2.iod.module.composite.GeneralStudyModule;
import org.dcm4che2.iod.module.composite.PatientModule;
import org.dcm4che2.iod.module.composite.PatientStudyModule;
import org.dcm4che2.iod.module.general.SOPCommonModule;
import org.dcm4che2.iod.validation.ValidationContext;
import org.dcm4che2.iod.validation.ValidationResult;

public class Composite {
    protected final DicomObject dcmobj;
    protected final PatientModule patientModule;
    protected final ClinicalTrialSubjectModule clinicalTrialSubjectModule;
    protected final GeneralStudyModule generalStudyModule;
    protected final PatientStudyModule patientStudyModule;
    protected final ClinicalTrialStudyModule clinicalTrialStudyModule;
    protected final GeneralSeriesModule generalSeriesModule;
    protected final ClinicalTrialSeriesModule clinicalTrialSeriesModule;
    protected final GeneralEquipmentModule generalEquipmentModule;
    protected final SOPCommonModule sopCommonModule;

    public static Composite valueOf(DicomObject dcmobj) {
        String cuid = dcmobj.getString(524310);
        if (cuid == null) {
            throw new IllegalArgumentException("Missing SOP Class UID");
        }
        if ("1.2.840.10008.5.1.4.1.1.1".equals(cuid)) {
            return new CRImage(dcmobj);
        }
        throw new UnsupportedOperationException("Unsupported SOP Class: " + UIDDictionary.getDictionary().prompt(cuid));
    }

    protected Composite(DicomObject dcmobj, GeneralSeriesModule seriesModule) {
        if (dcmobj == null) {
            throw new NullPointerException("dcmobj");
        }
        if (seriesModule == null) {
            throw new NullPointerException("seriesModule");
        }
        this.dcmobj = dcmobj;
        this.patientModule = new PatientModule(dcmobj);
        this.clinicalTrialSubjectModule = new ClinicalTrialSubjectModule(dcmobj);
        this.generalStudyModule = new GeneralStudyModule(dcmobj);
        this.patientStudyModule = new PatientStudyModule(dcmobj);
        this.clinicalTrialStudyModule = new ClinicalTrialStudyModule(dcmobj);
        this.generalSeriesModule = seriesModule;
        this.clinicalTrialSeriesModule = new ClinicalTrialSeriesModule(dcmobj);
        this.generalEquipmentModule = new GeneralEquipmentModule(dcmobj);
        this.sopCommonModule = new SOPCommonModule(dcmobj);
    }

    public void init() {
        this.patientModule.init();
        this.clinicalTrialSubjectModule.init();
        this.generalStudyModule.init();
        this.patientStudyModule.init();
        this.clinicalTrialStudyModule.init();
        this.generalSeriesModule.init();
        this.clinicalTrialSeriesModule.init();
        this.generalEquipmentModule.init();
        this.sopCommonModule.init();
    }

    public void validate(ValidationContext ctx, ValidationResult result) {
        this.patientModule.validate(ctx, result);
        this.clinicalTrialSubjectModule.validate(ctx, result);
        this.generalStudyModule.validate(ctx, result);
        this.patientStudyModule.validate(ctx, result);
        this.clinicalTrialStudyModule.validate(ctx, result);
        this.generalSeriesModule.validate(ctx, result);
        this.clinicalTrialSeriesModule.validate(ctx, result);
        this.generalEquipmentModule.validate(ctx, result);
        this.sopCommonModule.validate(ctx, result);
    }

    public DicomObject getDicomObject() {
        return this.dcmobj;
    }

    public final DicomObject getDcmobj() {
        return this.dcmobj;
    }

    public final PatientModule getPatientModule() {
        return this.patientModule;
    }

    public final ClinicalTrialSubjectModule getClinicalTrialSubjectModule() {
        return this.clinicalTrialSubjectModule;
    }

    public final GeneralStudyModule getGeneralStudyModule() {
        return this.generalStudyModule;
    }

    public final PatientStudyModule getPatientStudyModule() {
        return this.patientStudyModule;
    }

    public final ClinicalTrialStudyModule getClinicalTrialStudyModule() {
        return this.clinicalTrialStudyModule;
    }

    public final GeneralSeriesModule getGeneralSeriesModule() {
        return this.generalSeriesModule;
    }

    public final ClinicalTrialSeriesModule getClinicalTrialSeriesModule() {
        return this.clinicalTrialSeriesModule;
    }

    public final GeneralEquipmentModule getGeneralEquipmentModule() {
        return this.generalEquipmentModule;
    }

    public final SOPCommonModule getSopCommonModule() {
        return this.sopCommonModule;
    }
}

