/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.composite;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.iod.composite.Image;
import org.dcm4che2.iod.module.composite.ContrastBolusModule;
import org.dcm4che2.iod.module.composite.DeviceModule;
import org.dcm4che2.iod.module.cr.CRImageModule;
import org.dcm4che2.iod.module.cr.CRSeriesModule;
import org.dcm4che2.iod.module.lut.ModalityLutModule;
import org.dcm4che2.iod.module.lut.VoiLutModule;
import org.dcm4che2.iod.module.overlay.OverlayPlaneModule;
import org.dcm4che2.iod.validation.ValidationContext;
import org.dcm4che2.iod.validation.ValidationResult;

public class CRImage
extends Image {
    protected final ContrastBolusModule contrastBolusModule;
    protected final DeviceModule deviceModule;
    protected final OverlayPlaneModule overlayPlaneModule;
    protected final ModalityLutModule modalityLUTModule;
    protected final VoiLutModule voiLUTModule;

    public CRImage(DicomObject dcmobj) {
        super(dcmobj, new CRSeriesModule(dcmobj), new CRImageModule(dcmobj));
        this.contrastBolusModule = new ContrastBolusModule(dcmobj);
        this.deviceModule = new DeviceModule(dcmobj);
        this.overlayPlaneModule = new OverlayPlaneModule(dcmobj);
        this.modalityLUTModule = new ModalityLutModule(dcmobj);
        this.voiLUTModule = new VoiLutModule(dcmobj);
    }

    public CRImage() {
        this((DicomObject)new BasicDicomObject());
    }

    public void init() {
        super.init();
        this.contrastBolusModule.init();
        this.deviceModule.init();
        this.overlayPlaneModule.init();
        this.modalityLUTModule.init();
        this.voiLUTModule.init();
    }

    public void validate(ValidationContext ctx, ValidationResult result) {
        super.validate(ctx, result);
        this.contrastBolusModule.validate(ctx, result);
        this.deviceModule.validate(ctx, result);
        this.overlayPlaneModule.validate(ctx, result);
        this.modalityLUTModule.validate(ctx, result);
        this.voiLUTModule.validate(ctx, result);
    }

    public final CRSeriesModule getCrSeriesModule() {
        return (CRSeriesModule)this.generalSeriesModule;
    }

    public final ContrastBolusModule getContrastBolusModule() {
        return this.contrastBolusModule;
    }

    public final DeviceModule getDeviceModule() {
        return this.deviceModule;
    }

    public final CRImageModule getCRImageModule() {
        return (CRImageModule)this.generalImageModule;
    }

    public final OverlayPlaneModule getOverlayPlaneModule() {
        return this.overlayPlaneModule;
    }

    public final ModalityLutModule getModalityLUTModule() {
        return this.modalityLUTModule;
    }

    public final VoiLutModule getVOILUTModule() {
        return this.voiLUTModule;
    }
}

