/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.FactException;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EqualityKey;
import org.drools.common.EqualityKeyComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.util.FastMap;
import org.drools.util.LinkedList;
import org.drools.util.PrimitiveLongMap;

public class TruthMaintenanceSystem
implements Serializable {
    private final AbstractWorkingMemory WorkingMemory;
    private final PrimitiveLongMap justifiedMap = new PrimitiveLongMap(8, 32);
    private final Map assertMap;

    public TruthMaintenanceSystem(AbstractWorkingMemory abstractWorkingMemory) {
        this.WorkingMemory = abstractWorkingMemory;
        this.assertMap = new FastMap().setKeyComparator(EqualityKeyComparator.getInstance());
    }

    public PrimitiveLongMap getJustifiedMap() {
        return this.justifiedMap;
    }

    public Map getAssertMap() {
        return this.assertMap;
    }

    public Object put(EqualityKey equalityKey) {
        return this.assertMap.put(equalityKey, equalityKey);
    }

    public EqualityKey get(EqualityKey equalityKey) {
        return (EqualityKey)this.assertMap.get(equalityKey);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.assertMap.get(object);
    }

    public EqualityKey remove(EqualityKey equalityKey) {
        return (EqualityKey)this.assertMap.remove(equalityKey);
    }

    public void removeLogicalDependencies(Activation activation, PropagationContext propagationContext, Rule rule) throws FactException {
        LinkedList linkedList = activation.getLogicalDependencies();
        if (linkedList == null || linkedList.isEmpty()) {
            return;
        }
        for (LogicalDependency logicalDependency = (LogicalDependency)linkedList.getFirst(); logicalDependency != null; logicalDependency = (LogicalDependency)logicalDependency.getNext()) {
            InternalFactHandle internalFactHandle = (InternalFactHandle)logicalDependency.getFactHandle();
            Set set = (Set)this.justifiedMap.get(internalFactHandle.getId());
            if (set == null) continue;
            set.remove(logicalDependency);
            if (!set.isEmpty()) continue;
            this.justifiedMap.remove(internalFactHandle.getId());
            this.WorkingMemory.queueRetractAction(internalFactHandle, false, true, propagationContext.getRuleOrigin(), propagationContext.getActivationOrigin());
        }
    }

    public void removeLogicalDependencies(InternalFactHandle internalFactHandle) throws FactException {
        Set set = (Set)this.justifiedMap.remove(internalFactHandle.getId());
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                LogicalDependency logicalDependency = (LogicalDependency)iterator.next();
                logicalDependency.getJustifier().getLogicalDependencies().remove(logicalDependency);
            }
        }
    }

    public void addLogicalDependency(InternalFactHandle internalFactHandle, Activation activation, PropagationContext propagationContext, Rule rule) throws FactException {
        LogicalDependency logicalDependency = new LogicalDependency(activation, internalFactHandle);
        activation.addLogicalDependency(logicalDependency);
        HashSet<LogicalDependency> hashSet = (HashSet<LogicalDependency>)this.justifiedMap.get(internalFactHandle.getId());
        if (hashSet == null) {
            hashSet = new HashSet<LogicalDependency>();
            this.justifiedMap.put(internalFactHandle.getId(), hashSet);
        }
        hashSet.add(logicalDependency);
    }
}

