/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class BooleanFactory {
    public static Evaluator getBooleanEvaluator(int n) {
        switch (n) {
            case 1: {
                return BooleanEqualEvaluator.INSTANCE;
            }
            case 10: {
                return BooleanNotEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + n + "' does not exist for BooleanEvaluator");
    }

    static class BooleanNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -451325761056297938L;
        public static final Evaluator INSTANCE = new BooleanNotEqualEvaluator();

        private BooleanNotEqualEvaluator() {
            super(170, 10);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 != null;
            }
            return !((Boolean)object).equals(object2);
        }

        public String toString() {
            return "Boolean !=";
        }
    }

    static class BooleanEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 7891019213259874134L;
        private static final Evaluator INSTANCE = new BooleanEqualEvaluator();

        private BooleanEqualEvaluator() {
            super(170, 1);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return ((Boolean)object).equals(object2);
        }

        public String toString() {
            return "Boolean ==";
        }
    }
}

