/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingEvent;
import lu.tudor.santec.settings.SettingListener;
import lu.tudor.santec.settings.SettingsPlugin;

public class StartScriptPlugin
extends SettingsPlugin
implements SettingListener {
    private static final long serialVersionUID = 1L;
    private static final String UNIX_START = "#!/bin/sh";
    private static final String WINDOWS_START = "@echo off";
    private static final String UNIX_CD = "cd $(dirname $0)";
    private static final String UNIX_EXTENSION = ".sh";
    private static final String WINDOWS_EXTENSION = ".cmd";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String COMMENT = "created by lu.tudor.santec.settings.StartScriptPlugin (Tudor/Santec)";
    private static final Integer[] memorys = new Integer[]{new Integer(128), new Integer(256), new Integer(512), new Integer(1024), new Integer(2048)};
    private static final String VM_ARGS = "";
    private static final String PROG_ARGS = "";
    private String scriptName = "";
    private String jarFile = "";
    private String[] classPath = null;
    private String mainClass = "";
    private FormLayout layout;
    private JPanel scriptPanel;
    private JLabel desc;
    private JLabel vmArgsLabel;
    private JTextArea vmArgs;
    private JTextArea progArgs;
    private JLabel progArgsLabel;
    private JLabel memoryLabel;
    private JComboBox memory;
    private String vmargs;
    private static Logger logger = Logger.getLogger("lu.tudor.santec.settings.StartScriptPlugin");

    public StartScriptPlugin(String p_Name, String scriptName, String jarFile, String vmargs) {
        super(p_Name);
        this.scriptName = scriptName;
        this.vmargs = vmargs;
        this.jarFile = jarFile;
        this.buildPanel();
        this.relocalize();
    }

    public StartScriptPlugin(String p_Name, String scriptName, String[] classPath, String mainClass) {
        super(p_Name);
        this.scriptName = scriptName;
        this.classPath = classPath;
        this.mainClass = mainClass;
        this.buildPanel();
        this.relocalize();
    }

    private void buildPanel() {
        this.setLabel(Translatrix.getTranslationString((String)"script.Label"));
        this.setStationary("Memory", new Integer(512));
        this.setStationary("VmArgs", "");
        this.setStationary("ProgArgs", "");
        this.layout = new FormLayout("right:50dlu,5dlu,fill:60dlu:grow,5dlu", "center:pref,5dlu,center:pref,5dlu,pref,5dlu,40dlu,5dlu,pref,5dlu,40dlu");
        CellConstraints cc = new CellConstraints();
        this.scriptPanel = this.createSubPanel(Translatrix.getTranslationString((String)"lnf:Title"));
        this.scriptPanel.setLayout((LayoutManager)this.layout);
        PanelBuilder pBuilder = new PanelBuilder(this.layout, this.scriptPanel);
        this.desc = new JLabel();
        pBuilder.add((Component)this.desc, cc.xyw(1, 1, 3, "fill, center"));
        this.memoryLabel = new JLabel();
        pBuilder.add((Component)this.memoryLabel, cc.xy(1, 3));
        this.memory = new JComboBox<Integer>(memorys);
        pBuilder.add((Component)this.memory, cc.xy(3, 3));
        this.vmArgsLabel = new JLabel();
        pBuilder.add((Component)this.vmArgsLabel, cc.xy(1, 5));
        this.vmArgs = new JTextArea();
        pBuilder.add((Component)new JScrollPane(this.vmArgs), cc.xywh(3, 5, 1, 3));
        this.progArgsLabel = new JLabel();
        pBuilder.add((Component)this.progArgsLabel, cc.xy(1, 9));
        this.progArgs = new JTextArea();
        pBuilder.add((Component)new JScrollPane(this.progArgs), cc.xywh(3, 9, 1, 3));
        this.addSubPanel(this.scriptPanel);
        this.setIcon(StartScriptPlugin.getIconResource("icn_scripts"));
        this.setLabel(Translatrix.getTranslationString((String)"script.Label"));
    }

    public void revertToDefaults() {
        this.memory.setSelectedItem(this.getDefault("Memory"));
        this.vmArgs.setText((String)this.getDefault("VmArgs"));
        this.progArgs.setText((String)this.getDefault("ProgArgs"));
        this.reflectSettings();
        super.revertToDefaults();
    }

    public void updateSettings() {
        this.setValue("Memory", (Integer)this.memory.getSelectedItem());
        this.setValue("VmArgs", this.vmArgs.getText());
        this.setValue("ProgArgs", this.progArgs.getText());
        super.updateSettings();
    }

    public void reflectSettings() {
        super.reflectSettings();
        this.memory.setSelectedItem(this.getValue("Memory"));
        this.vmArgs.setText((String)this.getValue("VmArgs"));
        this.progArgs.setText((String)this.getValue("ProgArgs"));
    }

    public void relocalize() {
        this.setLabel(Translatrix.getTranslationString((String)"script.Label"));
        this.setSubPanelTitle(this.scriptPanel, Translatrix.getTranslationString((String)"script.Title"));
        this.desc.setText(Translatrix.getTranslationString((String)"script.Description"));
        this.memoryLabel.setText(Translatrix.getTranslationString((String)"script.Memory"));
        this.vmArgsLabel.setText(Translatrix.getTranslationString((String)"script.VMLabel"));
        this.progArgsLabel.setText(Translatrix.getTranslationString((String)"script.ProgLabel"));
    }

    public void createUnixScript() {
        try {
            FileWriter fw = new FileWriter(String.valueOf(this.scriptName) + UNIX_EXTENSION);
            fw.write(UNIX_START + NEWLINE);
            fw.write("# created by lu.tudor.santec.settings.StartScriptPlugin (Tudor/Santec)" + NEWLINE);
            fw.write(UNIX_CD + NEWLINE);
            fw.write("java ");
            fw.write("-Xmx" + this.memory.getSelectedItem() + "M ");
            fw.write(String.valueOf(this.vmargs) + " ");
            fw.write(String.valueOf(this.vmArgs.getText().replaceAll(NEWLINE, " ")) + " ");
            if (this.jarFile != null && this.jarFile != "") {
                fw.write("-jar " + this.jarFile + " ");
            } else {
                fw.write("-cp " + this.createClasspath(this.classPath, ":") + " ");
                fw.write(String.valueOf(this.mainClass) + " ");
            }
            fw.write(String.valueOf(this.progArgs.getText().replaceAll(NEWLINE, " ")) + " ");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createWindowsScript() {
        try {
            FileWriter fw = new FileWriter(String.valueOf(this.scriptName) + WINDOWS_EXTENSION);
            fw.write(WINDOWS_START + NEWLINE);
            fw.write("rem created by lu.tudor.santec.settings.StartScriptPlugin (Tudor/Santec)" + NEWLINE);
            fw.write("start javaw ");
            fw.write("-Xmx" + this.memory.getSelectedItem() + "M ");
            fw.write(String.valueOf(this.vmargs) + " ");
            fw.write(String.valueOf(this.vmArgs.getText().replaceAll(NEWLINE, " ")) + " ");
            if (this.jarFile != null && this.jarFile != "") {
                fw.write("-jar " + this.jarFile + " ");
            } else {
                fw.write("-cp " + this.createClasspath(this.classPath, ";") + " ");
                fw.write(String.valueOf(this.mainClass) + " ");
            }
            fw.write(String.valueOf(this.progArgs.getText().replaceAll(NEWLINE, " ")) + " ");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String createClasspath(String[] classPath, String seperator) {
        String path = "";
        int i = 0;
        while (i < classPath.length) {
            path = String.valueOf(path) + classPath[i] + seperator;
            ++i;
        }
        return path;
    }

    public void settingChanged(SettingEvent p_Event) {
        if (p_Event.getPluginName().equals(this.getName())) {
            this.createWindowsScript();
            this.createUnixScript();
            logger.info("Created new startup scripts: " + this.scriptName + UNIX_EXTENSION + ", " + this.scriptName + WINDOWS_EXTENSION);
        }
    }

    public void pluginAdded() {
        this.m_Owner.addSettingListener(this);
    }
}

