/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.Map;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.EndWithValue;
import org.mvel.ParseException;
import org.mvel.ParserContext;
import org.mvel.ast.Substatement;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ExecutionStack;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELInterpretedRuntime
extends AbstractParser {
    private boolean returnBigDecimal = false;
    private int roundingMode = 5;
    private Object holdOverRegister;

    Object parse() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.mvel.optimizers.impl.refl.ReflectiveAccessorOptimizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        OptimizerFactory.setThreadAccessorOptimizer(clazz);
        this.debugSymbols = false;
        try {
            this.stk = new ExecutionStack();
            this.dStack = new ExecutionStack();
            this.cursor = 0;
            this.parseAndExecuteInterpreted();
            if (parserContext != null && (parserContext.get() == null || ((ParserContext)parserContext.get()).getRootParser() == this)) {
                MVELInterpretedRuntime.contextControl(1, null, null);
            }
            return ParseTools.handleParserEgress(this.stk.pop(), this.returnBigDecimal);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new ParseException("unexpected end of statement", this.expr, this.length);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            if (this.cursor >= this.length) {
                throw new ParseException("unexpected end of statement", this.expr, this.length);
            }
            throw e;
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), this.returnBigDecimal);
        }
    }

    private void parseAndExecuteInterpreted() {
        ASTNode tk = null;
        this.lastWasIdentifier = false;
        try {
            while ((tk = this.nextToken()) != null) {
                int operator;
                this.holdOverRegister = null;
                if (this.lastWasIdentifier && this.lastNode.isDiscard()) {
                    this.stk.discard();
                }
                if (this.stk.isEmpty()) {
                    this.stk.push(tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                    if (tk instanceof Substatement) {
                        this.reduceRight();
                        tk = this.nextToken();
                        if (tk == null) continue;
                        operator = tk.getOperator();
                        if (MVELInterpretedRuntime.isArithmeticOperator(operator)) {
                            this.stk.push(this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory), new Integer(operator));
                            this.arithmeticFunctionReduction(operator);
                            continue;
                        }
                    }
                }
                if (!tk.isOperator()) continue;
                operator = tk.getOperator();
                switch (this.procBooleanOperator(operator)) {
                    case -1: {
                        return;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        this.stk.push(this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory), new Integer(operator));
                        this.arithmeticFunctionReduction(operator);
                    }
                }
            }
            if (this.holdOverRegister != null) {
                this.stk.push(this.holdOverRegister);
            }
            if (this.dStack != null) {
                while (!this.dStack.isEmpty()) {
                    this.reduceRight();
                }
            }
        }
        catch (NullPointerException e) {
            if (tk != null && tk.isOperator() && this.cursor >= this.length) {
                throw new CompileException(new StringBuffer("incomplete statement: ").append(tk.getName()).append(" (possible use of reserved keyword as identifier: ").append(tk.getName()).append(")").toString());
            }
            throw e;
        }
    }

    private int procBooleanOperator(int operator) {
        switch (operator) {
            case 20: {
                this.reduceRight();
                if (this.stk.peek() instanceof Boolean && !((Boolean)this.stk.peek()).booleanValue()) {
                    if (this.unwindStatement(operator)) {
                        return -1;
                    }
                    this.stk.clear();
                    return 0;
                }
                this.stk.discard();
                return 0;
            }
            case 21: {
                this.reduceRight();
                if (this.stk.peek() instanceof Boolean && ((Boolean)this.stk.peek()).booleanValue()) {
                    if (this.unwindStatement(operator)) {
                        return -1;
                    }
                    this.stk.clear();
                    return 0;
                }
                this.stk.discard();
                return 0;
            }
            case 29: {
                if (!((Boolean)this.stk.pop()).booleanValue()) {
                    ASTNode tk;
                    this.stk.clear();
                    while ((tk = this.nextToken()) != null && !tk.isOperator(new Integer(30))) {
                    }
                    return 0;
                }
            }
            case 30: {
                return 0;
            }
            case 37: {
                if (!this.hasNoMore()) {
                    this.holdOverRegister = this.stk.pop();
                    this.stk.clear();
                }
                return 0;
            }
        }
        return 1;
    }

    private void reduceRight() {
        if (this.dStack.isEmpty()) {
            return;
        }
        Object o = this.stk.pop();
        this.stk.push(this.dStack.pop());
        this.stk.push(o);
        this.stk.push(this.dStack.pop());
        this.reduce();
    }

    private boolean hasNoMore() {
        return this.cursor >= this.length;
    }

    private boolean unwindStatement(int operator) {
        ASTNode tk;
        switch (operator) {
            case 20: {
                while ((tk = this.nextToken()) != null && !tk.isOperator(new Integer(37)) && !tk.isOperator(new Integer(21))) {
                }
                break;
            }
            default: {
                while ((tk = this.nextToken()) != null && !tk.isOperator(new Integer(37))) {
                }
                break block0;
            }
        }
        return tk == null;
    }

    public MVELInterpretedRuntime setExpressionArray(char[] expressionArray) {
        this.expr = expressionArray;
        this.length = expressionArray.length;
        return this;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public boolean isReturnBigDecimal() {
        return this.returnBigDecimal;
    }

    public void setReturnBigDecimal(boolean returnBigDecimal) {
        this.returnBigDecimal = returnBigDecimal;
    }

    MVELInterpretedRuntime(char[] expression, Object ctx, Map<String, Object> variables) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(char[] expression, Object ctx) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
    }

    MVELInterpretedRuntime(String expression, Object ctx, Map<String, Object> variables) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(String expression) {
        this.setExpression(expression);
    }

    MVELInterpretedRuntime(char[] expression) {
        this.expr = expression;
        this.length = expression.length;
    }

    MVELInterpretedRuntime(char[] expr, Object ctx, VariableResolverFactory resolverFactory) {
        this.expr = expr;
        this.length = expr.length;
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(char[] expr, Object ctx, VariableResolverFactory resolverFactory, boolean returnBigDecimal) {
        this.expr = expr;
        this.length = expr.length;
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
        this.returnBigDecimal = returnBigDecimal;
    }

    MVELInterpretedRuntime(Object ctx, Map<String, Object> variables) {
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(String expression, Object ctx, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, Object ctx, VariableResolverFactory resolverFactory, boolean returnBigDecimal) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
        this.returnBigDecimal = returnBigDecimal;
    }

    MVELInterpretedRuntime(String expression, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, Object ctx) {
        this.setExpression(expression);
        this.ctx = ctx;
    }

    protected boolean hasImport(String name) {
        if (this.getParserContext().hasImport(name)) {
            return true;
        }
        ClassImportResolverFactory vrf = ParseTools.findClassImportResolverFactory(this.variableFactory);
        return vrf != null && vrf.isResolveable(name);
    }

    protected Class getImport(String name) {
        if (this.getParserContext().hasImport(name)) {
            return this.getParserContext().getImport(name);
        }
        ClassImportResolverFactory vrf = ParseTools.findClassImportResolverFactory(this.variableFactory);
        return (Class)vrf.getVariableResolver(name).getValue();
    }
}

