/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.decisiontable.model.SnippetBuilder;
import org.drools.decisiontable.parser.SourceBuilder;

public class LhsBuilder
implements SourceBuilder {
    private String column;
    private Map constraints;
    private List values;
    private boolean hasValues;
    private static Set operators = new HashSet();

    public LhsBuilder(String string) {
        this.column = string == null ? "" : string;
        this.constraints = new HashMap();
        this.values = new ArrayList();
    }

    public void addTemplate(int n, String string) {
        Integer n2 = new Integer(n);
        string = string.trim();
        if (this.constraints.containsKey(n2)) {
            throw new IllegalArgumentException("Internal error: Can't have a constraint added twice to one spreadsheet col.");
        }
        FieldType fieldType = this.calcFieldType(string);
        if (fieldType == FieldType.NORMAL_FIELD || !this.isMultipleConstraints()) {
            this.constraints.put(n2, string);
        } else if (fieldType == FieldType.SINGLE_FIELD) {
            this.constraints.put(n2, string + " == \"$param\"");
        } else if (fieldType == FieldType.OPERATOR_FIELD) {
            this.constraints.put(n2, string + " \"$param\"");
        }
    }

    public void clearValues() {
        this.hasValues = false;
        this.values.clear();
    }

    public void addCellValue(int n, String string) {
        this.hasValues = true;
        Integer n2 = new Integer(n);
        String string2 = (String)this.constraints.get(n2);
        SnippetBuilder snippetBuilder = new SnippetBuilder(string2);
        String string3 = snippetBuilder.build(string);
        this.values.add(string3);
    }

    public String getResult() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isMultipleConstraints()) {
            Iterator iterator = this.values.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                if (!iterator.hasNext()) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        stringBuffer.append(this.column);
        stringBuffer.append('(');
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    boolean isMultipleConstraints() {
        if ("".equals(this.column)) {
            return false;
        }
        return !this.column.endsWith(")");
    }

    public FieldType calcFieldType(String string) {
        if (string.indexOf("$param") != -1 || string.indexOf("$1") != -1) {
            return FieldType.NORMAL_FIELD;
        }
        Iterator iterator = operators.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            return FieldType.OPERATOR_FIELD;
        }
        return FieldType.SINGLE_FIELD;
    }

    public boolean hasValues() {
        return this.hasValues;
    }

    static {
        operators.add("==");
        operators.add("=");
        operators.add("!=");
        operators.add("<");
        operators.add(">");
        operators.add("<=");
        operators.add(">=");
        operators.add("contains");
        operators.add("matches");
    }

    static class FieldType {
        public static final FieldType SINGLE_FIELD = new FieldType();
        public static final FieldType OPERATOR_FIELD = new FieldType();
        public static final FieldType NORMAL_FIELD = new FieldType();

        FieldType() {
        }
    }
}

