/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.rubberband.rubberbands;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import net.java.swingfx.rubberband.canvas.RubberBandCanvas;
import net.java.swingfx.rubberband.rubberbands.RubberBand;

public abstract class AbstractRubberBand
extends MouseInputAdapter
implements RubberBand {
    protected RubberBandCanvas canvas;
    protected Rectangle rubberband;
    private int pressX;
    private int pressY;
    private boolean hideOnRelease;

    public AbstractRubberBand(RubberBandCanvas canvas) {
        this.canvas = canvas;
        this.init();
    }

    private void init() {
        this.rubberband = new Rectangle();
        this.setHideOnRelease(true);
        if (this.canvas != null) {
            this.canvas.setRubberBand(this);
            this.addMouseListeners();
        }
    }

    public void addMouseListeners() {
        this.canvas.getCanvas().addMouseListener(this);
        this.canvas.getCanvas().addMouseMotionListener(this);
    }

    public Rectangle getBounds() {
        return this.rubberband.getBounds();
    }

    public void setCanvas(RubberBandCanvas canvas) {
        this.canvas = canvas;
        this.canvas.setRubberBand(this);
        this.addMouseListeners();
    }

    public void mouseDragged(MouseEvent e) {
        int tmp;
        this.updateRubberBand(e);
        int x = e.getX();
        int y = e.getY();
        int w = 0;
        int h = 0;
        if (this.pressX < x) {
            tmp = x;
            x = this.pressX;
            w = tmp - x;
        } else {
            w = this.pressX - x;
        }
        if (this.pressY < y) {
            tmp = y;
            y = this.pressY;
            h = tmp - y;
        } else {
            h = this.pressY - y;
        }
        this.update(x, y, w, h);
        this.updateCanvas();
    }

    public void mousePressed(MouseEvent e) {
        this.startRubberBand(e);
        this.pressX = e.getX();
        this.pressY = e.getY();
        this.update(this.pressX, this.pressY, 0, 0);
    }

    public void mouseReleased(MouseEvent e) {
        this.stopRubberBand(e);
        if (this.isHideOnRelease()) {
            this.update(-1, -1, 0, 0);
            this.updateCanvas();
        }
    }

    private void updateCanvas() {
        this.canvas.getCanvas().repaint();
    }

    protected void setHideOnRelease(boolean hideOnRelease) {
        this.hideOnRelease = hideOnRelease;
    }

    protected boolean isHideOnRelease() {
        return this.hideOnRelease;
    }
}

