/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.win32;

import com.roxes.win32.Registry;
import com.roxes.win32.Win32Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class Win32 {
    static final String VERSION = "1.0.1";
    public static final int SPECIALDIRECTORY_PROGRAM_FILES = 1;
    public static final int SPECIALDIRECTORY_COMMON_FILES = 0;
    public static final int SPECIALDIRECTORY_COMMON_DESKTOP = 3;
    public static final int SPECIALDIRECTORY_COMMON_DOCUMENTS = 5;
    public static final int SPECIALDIRECTORY_COMMON_START_MENU = 6;
    public static final int SPECIALDIRECTORY_COMMON_PROGRAMS_MENU = 7;
    public static final int SPECIALDIRECTORY_COMMON_AUTOSTART_MENU = 8;
    public static final int SPECIALDIRECTORY_COMMON_TEMPLATES = 9;
    public static final int SPECIALDIRECTORY_PERSONAL_DESKTOP = 10;
    public static final int SPECIALDIRECTORY_PERSONAL_FILES = 11;
    public static final int SPECIALDIRECTORY_PERSONAL_START_MENU = 12;
    public static final int SPECIALDIRECTORY_PERSONAL_PROGRAMS_MENU = 13;
    public static final int SPECIALDIRECTORY_PERSONAL_AUTOSTART_MENU = 14;
    public static final int SPECIALDIRECTORY_PERSONAL_TEMPLATES = 15;
    public static final int SPECIALDIRECTORY_PERSONAL_SEND_TO = 16;
    public static final int SPECIALDIRECTORY_PERSONAL_FAVORITES = 17;
    static File commonFiles;
    static File programFiles;
    static File commonDesktop;
    static File commonDocuments;
    static File commonStartMenu;
    static File commonProgramsMenu;
    static File commonAutoStartMenu;
    static File commonTemplates;
    static File personalDesktop;
    static File personalFiles;
    static File personalStartMenu;
    static File personalProgramsMenu;
    static File personalAutoStartMenu;
    static File personalTemplates;
    static File personalSendTo;
    static File personalFavorites;

    public static native String getWindowsDirectory();

    public static native String getWindowsSystemDirectory();

    public static File getSpecialDirectory(int folder) {
        switch (folder) {
            case 0: {
                if (commonFiles == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
                    commonFiles = new File((String)reg.getValue("CommonFilesDir"));
                }
                return commonFiles;
            }
            case 1: {
                if (programFiles == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
                    programFiles = new File(reg.getStringValue("ProgramFilesDir"));
                }
                return programFiles;
            }
            case 3: {
                if (commonDesktop == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    commonDesktop = new File((String)reg.getValue("Common Desktop"));
                }
                return commonDesktop;
            }
            case 5: {
                if (commonDocuments == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    commonDocuments = new File((String)reg.getValue("Common Documents"));
                }
                return commonDocuments;
            }
            case 6: {
                if (commonStartMenu == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    commonStartMenu = new File((String)reg.getValue("Common Start Menu"));
                }
                return commonStartMenu;
            }
            case 7: {
                if (commonProgramsMenu == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    commonProgramsMenu = new File((String)reg.getValue("Common Programs"));
                }
                return commonProgramsMenu;
            }
            case 8: {
                if (commonAutoStartMenu == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    commonAutoStartMenu = new File((String)reg.getValue("Common Startup"));
                }
                return commonAutoStartMenu;
            }
            case 9: {
                if (commonTemplates == null) {
                    Registry reg = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    commonTemplates = new File((String)reg.getValue("Common Templates"));
                }
                return commonTemplates;
            }
            case 14: {
                if (personalAutoStartMenu == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalAutoStartMenu = new File((String)reg.getValue("Startup"));
                }
                return personalAutoStartMenu;
            }
            case 10: {
                if (personalDesktop == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalDesktop = new File((String)reg.getValue("Desktop"));
                }
                return personalDesktop;
            }
            case 11: {
                if (personalFiles == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalFiles = new File((String)reg.getValue("Personal"));
                }
                return personalFiles;
            }
            case 17: {
                if (personalFavorites == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalFavorites = new File((String)reg.getValue("Favorites"));
                }
                return personalFavorites;
            }
            case 13: {
                if (personalProgramsMenu == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalProgramsMenu = new File((String)reg.getValue("Programs"));
                }
                return personalProgramsMenu;
            }
            case 16: {
                if (personalSendTo == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalSendTo = new File((String)reg.getValue("SendTo"));
                }
                return personalSendTo;
            }
            case 12: {
                if (personalStartMenu == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalStartMenu = new File((String)reg.getValue("Start Menu"));
                }
                return personalStartMenu;
            }
            case 15: {
                if (personalTemplates == null) {
                    Registry reg = new Registry(-2147483647, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    personalTemplates = new File((String)reg.getValue("Templates"));
                }
                return personalTemplates;
            }
        }
        throw new Win32Exception("getSpecialFolder failed : folder id " + folder + " is unknown");
    }

    public static void main(String[] args) {
        System.out.println("program files = " + Win32.getSpecialDirectory(1));
        System.out.println("common files = " + Win32.getSpecialDirectory(0));
        System.out.println("common desktop = " + Win32.getSpecialDirectory(3));
        System.out.println("common documents = " + Win32.getSpecialDirectory(5));
        System.out.println("common start menu = " + Win32.getSpecialDirectory(6));
        System.out.println("common program menu = " + Win32.getSpecialDirectory(7));
        System.out.println("common autostart menu = " + Win32.getSpecialDirectory(8));
        System.out.println("common templates = " + Win32.getSpecialDirectory(9));
        System.out.println("personal autostart menu = " + Win32.getSpecialDirectory(14));
        System.out.println("personal desktop = " + Win32.getSpecialDirectory(10));
        System.out.println("personal documents = " + Win32.getSpecialDirectory(11));
        System.out.println("perswonal favorites = " + Win32.getSpecialDirectory(17));
        System.out.println("personal programs menu = " + Win32.getSpecialDirectory(13));
        System.out.println("personal sent to = " + Win32.getSpecialDirectory(16));
        System.out.println("personal start menu = " + Win32.getSpecialDirectory(12));
        System.out.println("personal templates = " + Win32.getSpecialDirectory(15));
        System.out.println("windows directory= " + Win32.getWindowsDirectory());
        System.out.println("windows directory= " + Win32.getWindowsSystemDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File file = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "roxes-win32-" + VERSION + ".dll");
        if (!file.exists()) {
            try {
                System.out.println("Install native library " + file.getAbsolutePath());
                InputStream in = Registry.class.getResourceAsStream("win32.dll");
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                InputStream inputStream = in;
                synchronized (inputStream) {
                    FileOutputStream fileOutputStream = out;
                    synchronized (fileOutputStream) {
                        int read;
                        while ((read = in.read(buffer)) > -1) {
                            ((OutputStream)out).write(buffer, 0, read);
                        }
                    }
                }
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                throw new Win32Exception("Unable to copy win32-1.0.1.dll to JAVA_HOME" + File.separator + "bin.");
            }
        }
        if (System.getProperty("roxes.native.win32.1.0.1") == null) {
            System.load(file.getAbsolutePath());
            System.setProperty("roxes.native.win32.1.0.1", "loaded");
        }
        commonFiles = null;
        programFiles = null;
        commonDesktop = null;
        commonDocuments = null;
        commonStartMenu = null;
        commonProgramsMenu = null;
        commonAutoStartMenu = null;
        commonTemplates = null;
        personalDesktop = null;
        personalFiles = null;
        personalStartMenu = null;
        personalProgramsMenu = null;
        personalAutoStartMenu = null;
        personalTemplates = null;
        personalSendTo = null;
        personalFavorites = null;
    }
}

