/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.win32;

import com.roxes.win32.Win32Exception;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;

public class Registry {
    static final String VERSION = "1.0.4";
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 5;
    public static final int REG_DWORD_BIG_ENDIAN = 4;
    public static final int REG_MULTI_SZ = 7;
    private final int hKey;
    private final String subKey;

    public int getHKey() {
        return this.hKey;
    }

    public void deleteSubKey(String subKeyName) {
        this.openSubKey(subKeyName).delete();
    }

    public String getSubKey() {
        return this.subKey;
    }

    public Registry(int hKey) {
        this(hKey, "");
    }

    public Registry(int hKey, String subKey) {
        this.hKey = hKey;
        this.subKey = subKey;
    }

    public Registry(Registry reg, String subKey) {
        this.hKey = reg.hKey;
        this.subKey = reg.subKey.length() > 0 ? reg.subKey + "\\" + subKey : subKey;
    }

    private native boolean exists(String var1, int var2);

    public boolean exists() {
        return this.exists(this.subKey, this.hKey);
    }

    private native void create(String var1, int var2) throws Win32Exception;

    public void create() throws Win32Exception {
        this.create(this.subKey, this.hKey);
    }

    private native void delete(String var1, int var2) throws Win32Exception;

    public void delete() throws Win32Exception {
        this.delete(this.subKey, this.hKey);
    }

    private native boolean hasSubKeys(String var1, int var2) throws Win32Exception;

    public boolean hasSubKeys() throws Win32Exception {
        return this.hasSubKeys(this.subKey, this.hKey);
    }

    private native boolean hasValues(String var1, int var2) throws Win32Exception;

    public boolean hasValues() throws Win32Exception {
        return this.hasValues(this.subKey, this.hKey);
    }

    private native boolean hasValue(String var1, int var2, String var3) throws Win32Exception;

    public boolean hasValue(String name) throws Win32Exception {
        return this.hasValue(this.subKey, this.hKey, name);
    }

    private native void deleteValue(String var1, int var2, String var3) throws Win32Exception;

    public void deleteValue(String name) throws Win32Exception {
        this.deleteValue(this.subKey, this.hKey, name);
    }

    public void setValue(String name, int value) throws Win32Exception {
        this.setValue(this.subKey, this.hKey, name, new Integer(value), 4);
    }

    public int getIntValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to int");
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to int");
    }

    public void setValue(String name, short value) throws Win32Exception {
        this.setValue(this.subKey, this.hKey, name, new Short(value), 4);
    }

    public short getShortValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to short");
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to short");
    }

    public void setValue(String name, long value) throws Win32Exception {
        this.setValue(this.subKey, this.hKey, name, new Long(value), 4);
    }

    public long getLongValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to long");
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to long");
    }

    public void setValue(String name, boolean value) throws Win32Exception {
        this.setValue(this.subKey, this.hKey, name, new Integer(value ? 1 : 0), 4);
    }

    public boolean getBooleanValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to boolean");
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to boolean");
    }

    public void setValue(String name, float value) throws Win32Exception {
        this.setValue(name, new Float(value));
    }

    public float getFloatValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to float");
        }
        if (value.getClass().getName().equals("[B")) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream((byte[])value));
                Object o = ois.readObject();
                if (o instanceof Number) {
                    return ((Number)o).floatValue();
                }
                throw new Win32Exception("deserialized object is not of type number");
            }
            catch (IOException ex) {
                throw new Win32Exception(ex);
            }
            catch (ClassNotFoundException ex) {
                throw new Win32Exception(ex);
            }
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to float");
    }

    public void setValue(String name, double value) throws Win32Exception {
        this.setValue(name, new Double(value));
    }

    public double getDoubleValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to float");
        }
        if (value.getClass().getName().equals("[B")) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream((byte[])value));
                Object o = ois.readObject();
                if (o instanceof Number) {
                    return ((Number)o).doubleValue();
                }
                throw new Win32Exception("deserialized object is not of type number");
            }
            catch (IOException ex) {
                throw new Win32Exception(ex);
            }
            catch (ClassNotFoundException ex) {
                throw new Win32Exception(ex);
            }
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to double");
    }

    public void setValue(String name, byte[] value) throws Win32Exception {
        this.setValue(this.subKey, this.hKey, name, value, 3);
    }

    public void setValue(String name, byte value) throws Win32Exception {
        this.setValue(this.subKey, this.hKey, name, new Integer(value), 4);
    }

    public Byte getByteValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to Byte");
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue());
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to Byte");
    }

    public byte[] getByteArrayValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to byte array");
        }
        if (value.getClass().getName().equals("[B")) {
            return (byte[])value;
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to byte array");
    }

    public BigDecimal getBigDecimalValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to BigDecimal");
        }
        if (value instanceof String) {
            return new BigDecimal(value.toString());
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to BigDecimal");
    }

    public BigInteger getBigIntegerValue(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            throw new Win32Exception("Cannot convert null to BigInteger");
        }
        if (value instanceof String) {
            return new BigInteger(value.toString());
        }
        throw new Win32Exception("Cannot convert " + value.getClass().getName() + " to BigInteger");
    }

    public void setValue(String name, Object value) throws Win32Exception {
        int type = -1;
        if (value == null) {
            throw new Win32Exception("Cannot set null value in registry");
        }
        Class<?> clazz = value.getClass();
        if (clazz.getName().equals("[B")) {
            type = 3;
        } else if (clazz.equals(Byte.class)) {
            type = 4;
            value = new Integer(((Byte)value).intValue());
        } else if (clazz.equals(Boolean.class)) {
            type = 4;
            value = new Integer((Boolean)value != false ? 1 : 0);
        } else if (clazz.equals(Float.class)) {
            try {
                type = 3;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
                value = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new Win32Exception(ex);
            }
        } else if (clazz.equals(Double.class)) {
            try {
                type = 3;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
                value = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new Win32Exception(ex);
            }
        } else if (clazz.equals(BigInteger.class)) {
            type = 1;
            value = value.toString();
        } else if (clazz.equals(BigDecimal.class)) {
            type = 1;
            value = value.toString();
        } else {
            type = Number.class.isAssignableFrom(clazz) ? 4 : 1;
        }
        this.setValue(this.subKey, this.hKey, name, value, type);
    }

    private native void setValue(String var1, int var2, String var3, Object var4, int var5) throws Win32Exception;

    public boolean hasSubKey(String name) {
        Registry reg = new Registry(this, name);
        return reg.exists();
    }

    public Iterator valueNames() {
        return this.values(this.subKey, this.hKey).iterator();
    }

    private native List values(String var1, int var2);

    public Iterator subKeyNames() {
        return this.subKeys(this.subKey, this.hKey).iterator();
    }

    public Iterator subKeys() {
        return new SubKeyIterator(this.subKeys(this.subKey, this.hKey));
    }

    private native Object getValue(String var1, int var2, String var3);

    public Object getValue(String name) {
        return this.getValue(this.subKey, this.hKey, name);
    }

    private native int getValueType(String var1, int var2, String var3);

    public int getValueType(String name) {
        return this.getValueType(this.subKey, this.hKey, name);
    }

    public static String getValueTypeName(int valueType) {
        switch (valueType) {
            case 3: {
                return "REG_BINARY";
            }
            case 4: {
                return "REG_DWORD";
            }
            case 5: {
                return "REG_DWORD_LITTLE_ENDIAN";
            }
            case 2: {
                return "REG_EXPAND_SZ";
            }
            case 7: {
                return "REG_MULTI_SZ";
            }
            case 0: {
                return "REG_NONE";
            }
            case 1: {
                return "REG_SZ";
            }
        }
        throw new Win32Exception("valueType " + valueType + " is unknown.");
    }

    public static int parseValueTypeName(String name) {
        if (name.equals("REG_BINARY")) {
            return 3;
        }
        if (name.equals("REG_DWORD")) {
            return 4;
        }
        if (name.equals("REG_DWORD_BIG_ENDIAN")) {
            return 4;
        }
        if (name.equals("REG_DWORD_LITTLE_ENDIAN")) {
            return 5;
        }
        if (name.equals("REG_EXPAND_SZ")) {
            return 2;
        }
        if (name.equals("REG_MULTI_SZ")) {
            return 7;
        }
        if (name.equals("REG_NONE")) {
            return 0;
        }
        if (name.equals("REG_SZ")) {
            return 1;
        }
        throw new Win32Exception("Parsing valueType failed : valueType " + name + " is unknown.");
    }

    public static String getHKeyName(int hKey) {
        switch (hKey) {
            case -2147483648: {
                return "HKEY_CLASSES_ROOT";
            }
            case -2147483647: {
                return "HKEY_CURRENT_USER";
            }
            case -2147483646: {
                return "HKEY_LOCAL_MACHINE";
            }
            case -2147483645: {
                return "HKEY_USERS";
            }
        }
        throw new Win32Exception("hKey " + hKey + " is unknown.");
    }

    public static int parseHKeyName(String name) {
        if (name.equals("HKEY_CLASSES_ROOT")) {
            return Integer.MIN_VALUE;
        }
        if (name.equals("HKEY_CURRENT_USER")) {
            return -2147483647;
        }
        if (name.equals("HKEY_LOCAL_MACHINE")) {
            return -2147483646;
        }
        if (name.equals("HKEY_USERS")) {
            return -2147483645;
        }
        throw new Win32Exception("Parsing hKey failed : hKey " + name + " is unknown.");
    }

    private native List subKeys(String var1, int var2);

    public String toString() {
        StringBuffer sb = new StringBuffer(Registry.getHKeyName(this.hKey));
        if (this.subKey.length() > 0) {
            sb.append('\\').append(this.subKey);
        }
        return sb.toString();
    }

    public String getStringValue(String name) {
        return this.getValue(name).toString();
    }

    public Registry createSubKey(String subKeyName) throws Win32Exception {
        Registry result = new Registry(this.getHKey(), this.getSubKey() + "\\" + subKeyName);
        result.create();
        return result;
    }

    public Registry openSubKey(String subKeyName) throws Win32Exception {
        Registry result = new Registry(this.getHKey(), this.getSubKey() + "\\" + subKeyName);
        if (result.exists()) {
            return result;
        }
        throw new Win32Exception("No such subKey: " + result.toString());
    }

    public boolean equals(Object other) {
        if (other instanceof Registry) {
            Registry otherRegistry = (Registry)other;
            return this.getHKey() == otherRegistry.getHKey() && this.getSubKey().equals(otherRegistry.getSubKey());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File file = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "roxes-registry-" + VERSION + ".dll");
        if (!file.exists()) {
            try {
                System.out.println("Install native library " + file.getAbsolutePath());
                InputStream in = Registry.class.getResourceAsStream("registry.dll");
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                InputStream inputStream = in;
                synchronized (inputStream) {
                    FileOutputStream fileOutputStream = out;
                    synchronized (fileOutputStream) {
                        int read;
                        while ((read = in.read(buffer)) > -1) {
                            ((OutputStream)out).write(buffer, 0, read);
                        }
                    }
                }
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                throw new Win32Exception("Unable to copy registry-1.0.4.dll to JAVA_HOME" + File.separator + "bin.");
            }
        }
        if (System.getProperty("roxes.native.registry.1.0.4") == null) {
            System.load(file.getAbsolutePath());
            System.setProperty("roxes.native.registry.1.0.4", "loaded");
        }
    }

    public class SubKeyIterator
    implements Iterator {
        private final List list;
        private int subKeyIndex = 0;

        public SubKeyIterator(List list) {
            this.list = list;
        }

        public boolean hasNext() {
            return this.subKeyIndex < this.list.size();
        }

        public Object next() {
            return Registry.this.openSubKey((String)this.list.get(this.subKeyIndex++));
        }

        public void remove() {
            Registry.this.deleteSubKey((String)this.list.get(this.subKeyIndex));
            this.list.remove(this.subKeyIndex);
        }
    }
}

