/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.logging.log4j;

import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.LogLevel;
import lu.luxtrust.logging.Logger;
import lu.luxtrust.logging.jre.JRELogger;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class LOG4JLogger
extends Logger
implements Log {
    private static final String FQCN;
    private final LogLevel LEVEL_INFO = new LogLevel(1);
    private final LogLevel LEVEL_DEBUG = new LogLevel(2);
    private final LogLevel LEVEL_WARN = new LogLevel(3);
    private final LogLevel LEVEL_ERROR = new LogLevel(4);
    private final LogLevel LEVEL_CONF = new LogLevel(5);
    private org.apache.log4j.Logger logger = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("lu.luxtrust.logging.log4j.LOG4JLogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FQCN = clazz.getName();
    }

    public static Log getLogger(Class clazz) {
        return JRELogger.getLogger(clazz.getName());
    }

    public static Log getLogger(String className) {
        LOG4JLogger log4jLogger = new LOG4JLogger(className);
        return log4jLogger;
    }

    public LOG4JLogger(String className) {
        String customConfigFile = System.getProperty("lu.luxtrust.logging.conf.custom");
        if (customConfigFile != null && !customConfigFile.equals("")) {
            PropertyConfigurator.configure((String)customConfigFile);
        }
        this.logger = LogManager.getLogger((String)className);
    }

    public void conf(Error e, int errorCode) {
        this.log(this.LEVEL_CONF, e, errorCode);
    }

    public void conf(Exception e, int errorCode) {
        this.log(this.LEVEL_CONF, e, errorCode);
    }

    public void conf(String message) {
        this.log(this.LEVEL_CONF, message, 0);
    }

    public void conf(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_CONF, message, t, errorCode);
    }

    public void conf(Throwable t, int errorCode) {
        this.log(this.LEVEL_CONF, t, errorCode);
    }

    public void debug(Error e, int errorCode) {
        this.log(this.LEVEL_DEBUG, e, errorCode);
    }

    public void debug(Exception e, int errorCode) {
        this.log(this.LEVEL_DEBUG, e, errorCode);
    }

    public void debug(String message) {
        this.log(this.LEVEL_DEBUG, message, 0);
    }

    public void debug(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_DEBUG, message, t, errorCode);
    }

    public void debug(Throwable t, int errorCode) {
        this.log(this.LEVEL_DEBUG, t, errorCode);
    }

    public void error(Error e, int errorCode) {
        this.log(this.LEVEL_ERROR, e, errorCode);
    }

    public void error(Exception e, int errorCode) {
        this.log(this.LEVEL_ERROR, e, errorCode);
    }

    public void error(String message, int errorCode) {
        this.log(this.LEVEL_ERROR, message, errorCode);
    }

    public void error(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_ERROR, message, t, errorCode);
    }

    public void error(Throwable t, int errorCode) {
        this.log(this.LEVEL_ERROR, t, errorCode);
    }

    public void info(Error e, int errorCode) {
        this.log(this.LEVEL_INFO, e, errorCode);
    }

    public void info(Exception e, int errorCode) {
        this.log(this.LEVEL_INFO, e, errorCode);
    }

    public void info(String message) {
        this.log(this.LEVEL_INFO, message, 0);
    }

    public void info(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_INFO, message, t, errorCode);
    }

    public void info(Throwable t, int errorCode) {
        this.log(this.LEVEL_INFO, t, errorCode);
    }

    public void log(LogLevel level, Error e, int errorCode) {
        this.log(level, null, e, errorCode);
    }

    public void log(LogLevel level, Exception e, int errorCode) {
        this.log(level, null, e, errorCode);
    }

    public void log(LogLevel level, String message, int errorCode) {
        this.log(level, message, null, errorCode);
    }

    public void log(LogLevel level, String message, Throwable t, int errorCode) {
        Priority _level = null;
        switch (level.getLevel()) {
            case 5: {
                _level = Priority.INFO;
                break;
            }
            case 2: {
                _level = Priority.DEBUG;
                break;
            }
            case 4: {
                _level = Priority.ERROR;
                break;
            }
            case 1: {
                _level = Priority.INFO;
                break;
            }
            case 3: {
                _level = Priority.WARN;
            }
        }
        if (errorCode != 0) {
            String _msg = "LTEC:" + String.valueOf(errorCode) + (message == null || message.equals("") ? "" : ":" + message) + (t == null ? "" : ":" + t.getMessage());
            this.logger.log(FQCN, _level, (Object)_msg, null);
        } else {
            this.logger.log(FQCN, _level, (Object)message, t);
        }
    }

    public void log(LogLevel level, Throwable t, int errorCode) {
        this.log(level, null, t, errorCode);
    }

    public void warn(Error e, int errorCode) {
        this.log(this.LEVEL_WARN, e, errorCode);
    }

    public void warn(Exception e, int errorCode) {
        this.log(this.LEVEL_WARN, e, errorCode);
    }

    public void warn(String message, int errorCode) {
        this.log(this.LEVEL_WARN, message, errorCode);
    }

    public void warn(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_WARN, message, t, errorCode);
    }

    public void warn(Throwable t, int errorCode) {
        this.log(this.LEVEL_WARN, t, errorCode);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebuggingEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isConfigEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }
}

