/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.logging.jre;

import java.util.logging.Level;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.LogLevel;
import lu.luxtrust.logging.Logger;

public class JRELogger
extends Logger
implements Log {
    private final LogLevel LEVEL_INFO = new LogLevel(1);
    private final LogLevel LEVEL_DEBUG = new LogLevel(2);
    private final LogLevel LEVEL_WARN = new LogLevel(3);
    private final LogLevel LEVEL_ERROR = new LogLevel(4);
    private final LogLevel LEVEL_CONF = new LogLevel(5);
    private java.util.logging.Logger logger = null;

    public static Log getLogger(Class clazz) {
        return JRELogger.getLogger(clazz.getName());
    }

    public static Log getLogger(String className) {
        JRELogger jreLogger = new JRELogger(className);
        return jreLogger;
    }

    public JRELogger(String className) {
        String customConfigFile = System.getProperty("lu.luxtrust.logging.conf.custom");
        if (customConfigFile != null && !customConfigFile.equals("")) {
            System.setProperty("java.util.logging.config.file", customConfigFile);
        }
        this.logger = java.util.logging.Logger.getLogger(className);
    }

    public void conf(Error e, int errorCode) {
        this.log(this.LEVEL_CONF, e, errorCode);
    }

    public void conf(Exception e, int errorCode) {
        this.log(this.LEVEL_CONF, e, errorCode);
    }

    public void conf(String message) {
        this.log(this.LEVEL_CONF, message, 0);
    }

    public void conf(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_CONF, message, t, errorCode);
    }

    public void conf(Throwable t, int errorCode) {
        this.log(this.LEVEL_CONF, t, errorCode);
    }

    public void debug(Error e, int errorCode) {
        this.log(this.LEVEL_DEBUG, e, errorCode);
    }

    public void debug(Exception e, int errorCode) {
        this.log(this.LEVEL_DEBUG, e, errorCode);
    }

    public void debug(String message) {
        this.log(this.LEVEL_DEBUG, message, 0);
    }

    public void debug(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_DEBUG, message, t, errorCode);
    }

    public void debug(Throwable t, int errorCode) {
        this.log(this.LEVEL_DEBUG, t, errorCode);
    }

    public void error(Error e, int errorCode) {
        this.log(this.LEVEL_ERROR, e, errorCode);
    }

    public void error(Exception e, int errorCode) {
        this.log(this.LEVEL_ERROR, e, errorCode);
    }

    public void error(String message, int errorCode) {
        this.log(this.LEVEL_ERROR, message, errorCode);
    }

    public void error(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_ERROR, t, errorCode);
    }

    public void error(Throwable t, int errorCode) {
        this.log(this.LEVEL_ERROR, t, errorCode);
    }

    public void info(Error e, int errorCode) {
        this.log(this.LEVEL_INFO, e, errorCode);
    }

    public void info(Exception e, int errorCode) {
        this.log(this.LEVEL_INFO, e, errorCode);
    }

    public void info(String message) {
        this.log(this.LEVEL_INFO, message, null, 0);
    }

    public void info(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_INFO, message, t, errorCode);
    }

    public void info(Throwable t, int errorCode) {
        this.log(this.LEVEL_INFO, t, errorCode);
    }

    public void log(LogLevel level, Error e, int errorCode) {
        this.log(level, null, e, errorCode);
    }

    public void log(LogLevel level, Exception e, int errorCode) {
        this.log(level, null, e, errorCode);
    }

    public void log(LogLevel level, String message, int errorCode) {
        this.log(level, message, null, errorCode);
    }

    public void log(LogLevel level, String message, Throwable t, int errorCode) {
        Level _level = null;
        switch (level.getLevel()) {
            case 5: {
                _level = Level.CONFIG;
                break;
            }
            case 2: {
                _level = Level.FINE;
                break;
            }
            case 4: {
                _level = Level.SEVERE;
                break;
            }
            case 1: {
                _level = Level.INFO;
                break;
            }
            case 3: {
                _level = Level.WARNING;
            }
        }
        if (errorCode != 0) {
            String _msg = "LTEC:" + String.valueOf(errorCode) + (message == null || message.equals("") ? "" : ":" + message) + (t == null ? "" : ":" + t.getMessage());
            this.logger.log(_level, _msg);
        } else {
            this.logger.log(_level, message, t);
        }
    }

    public void log(LogLevel level, Throwable t, int errorCode) {
        this.log(level, null, t, errorCode);
    }

    public void warn(Error e, int errorCode) {
        this.log(this.LEVEL_WARN, e, errorCode);
    }

    public void warn(Exception e, int errorCode) {
        this.log(this.LEVEL_WARN, e, errorCode);
    }

    public void warn(String message, int errorCode) {
        this.log(this.LEVEL_WARN, message, errorCode);
    }

    public void warn(String message, Throwable t, int errorCode) {
        this.log(this.LEVEL_WARN, message, t, errorCode);
    }

    public void warn(Throwable t, int errorCode) {
        this.log(this.LEVEL_WARN, t, errorCode);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isDebuggingEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isConfigEnabled() {
        return this.logger.isLoggable(Level.CONFIG);
    }

    public boolean isWarningEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }
}

