/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.util.Map;
import org.artofsolving.jodconverter.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeUtils {
    public static final String SERVICE_DESKTOP = "com.sun.star.frame.Desktop";

    private OfficeUtils() {
        throw new AssertionError((Object)"utility class must not be instantiated");
    }

    public static <T> T cast(Class<T> type, Object object) {
        return (T)UnoRuntime.queryInterface(type, (Object)object);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = name;
        propertyValue.Value = value;
        return propertyValue;
    }

    public static PropertyValue[] toUnoProperties(Map<String, ?> properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = OfficeUtils.toUnoProperties(subProperties);
            }
            propertyValues[i++] = OfficeUtils.property(entry.getKey(), value);
        }
        return propertyValues;
    }

    public static String toUrl(File file) {
        String path = file.toURI().getRawPath();
        String url = path.startsWith("//") ? "file:" + path : "file://" + path;
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static File getDefaultOfficeHome() {
        if (System.getProperty("office.home") != null) {
            return new File(System.getProperty("office.home"));
        }
        if (PlatformUtils.isWindows()) {
            String programFiles = System.getenv("ProgramFiles(x86)");
            if (programFiles == null) {
                programFiles = System.getenv("ProgramFiles");
            }
            return OfficeUtils.findOfficeHome(String.valueOf(programFiles) + File.separator + "OpenOffice.org 3", String.valueOf(programFiles) + File.separator + "LibreOffice 3");
        }
        if (PlatformUtils.isMac()) {
            return OfficeUtils.findOfficeHome("/Applications/OpenOffice.org.app/Contents", "/Applications/LibreOffice.app/Contents");
        }
        return OfficeUtils.findOfficeHome("/opt/openoffice.org3", "/opt/libreoffice", "/usr/lib/openoffice", "/usr/lib/libreoffice");
    }

    private static File findOfficeHome(String ... knownPaths) {
        String[] stringArray = knownPaths;
        int n = knownPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File home = new File(path);
            if (OfficeUtils.getOfficeExecutable(home).isFile()) {
                return home;
            }
            ++n2;
        }
        return null;
    }

    public static File getOfficeExecutable(File officeHome) {
        if (PlatformUtils.isMac()) {
            return new File(officeHome, "MacOS/soffice.bin");
        }
        return new File(officeHome, "program/soffice.bin");
    }
}

