/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheet;
import com.l2fprod.common.swing.ObjectTableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PropertySheetTableModel
extends AbstractTableModel
implements PropertyChangeListener,
PropertySheet,
ObjectTableModel {
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int NUM_COLUMNS = 2;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List model = new ArrayList();
    private List publishedModel = new ArrayList();
    private List properties = new ArrayList();
    private int mode = 0;
    private boolean sortingCategories = false;
    private boolean sortingProperties = false;
    private Comparator categorySortingComparator;
    private Comparator propertySortingComparator;
    private static final Comparator STRING_COMPARATOR = new NaturalOrderStringComparator();

    public void setProperties(Property[] newProperties) {
        int i;
        Property[] subProp;
        Property prop;
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            prop = (Property)iter.next();
            prop.removePropertyChangeListener(this);
            subProp = prop.getSubProperties();
            if (subProp == null) continue;
            for (i = 0; i < subProp.length; ++i) {
                subProp[i].removePropertyChangeListener(this);
            }
        }
        this.properties.clear();
        this.properties.addAll(Arrays.asList(newProperties));
        iter = this.properties.iterator();
        while (iter.hasNext()) {
            prop = (Property)iter.next();
            prop.addPropertyChangeListener(this);
            subProp = prop.getSubProperties();
            if (subProp == null) continue;
            for (i = 0; i < subProp.length; ++i) {
                subProp[i].addPropertyChangeListener(this);
            }
        }
        this.buildModel();
    }

    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
        property.addPropertyChangeListener(this);
        this.buildModel();
    }

    public void addProperty(int index, Property property) {
        this.properties.add(index, property);
        property.addPropertyChangeListener(this);
        this.buildModel();
    }

    public void removeProperty(Property property) {
        this.properties.remove(property);
        property.removePropertyChangeListener(this);
        this.buildModel();
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Iterator propertyIterator() {
        return this.properties.iterator();
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.buildModel();
    }

    public int getMode() {
        return this.mode;
    }

    public Class getColumnClass(int columnIndex) {
        return super.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.publishedModel.size();
    }

    public Object getObject(int rowIndex) {
        return this.getPropertySheetElement(rowIndex);
    }

    public Item getPropertySheetElement(int rowIndex) {
        return (Item)this.publishedModel.get(rowIndex);
    }

    public boolean isSortingCategories() {
        return this.sortingCategories;
    }

    public void setSortingCategories(boolean value) {
        boolean old = this.sortingCategories;
        this.sortingCategories = value;
        if (this.sortingCategories != old) {
            this.buildModel();
        }
    }

    public boolean isSortingProperties() {
        return this.sortingProperties;
    }

    public void setSortingProperties(boolean value) {
        boolean old = this.sortingProperties;
        this.sortingProperties = value;
        if (this.sortingProperties != old) {
            this.buildModel();
        }
    }

    public void setCategorySortingComparator(Comparator comp) {
        Comparator old = this.categorySortingComparator;
        this.categorySortingComparator = comp;
        if (this.categorySortingComparator != old) {
            this.buildModel();
        }
    }

    public void setPropertySortingComparator(Comparator comp) {
        Comparator old = this.propertySortingComparator;
        this.propertySortingComparator = comp;
        if (this.propertySortingComparator != old) {
            this.buildModel();
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        Item item = this.getPropertySheetElement(rowIndex);
        if (item.isProperty()) {
            switch (columnIndex) {
                case 0: {
                    result = item;
                    break;
                }
                case 1: {
                    try {
                        result = item.getProperty().getValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        } else {
            result = item;
        }
        return result;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Item item = this.getPropertySheetElement(rowIndex);
        if (item.isProperty() && columnIndex == 1) {
            try {
                item.getProperty().setValue(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.listeners.firePropertyChange(evt);
    }

    protected void visibilityChanged() {
        this.publishedModel.clear();
        Iterator iter = this.model.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            Item parent = item.getParent();
            if (parent != null && !parent.isVisible()) continue;
            this.publishedModel.add(item);
        }
        this.fireTableDataChanged();
    }

    private void buildModel() {
        this.model.clear();
        this.publishedModel.clear();
        if (this.properties != null && this.properties.size() > 0) {
            List sortedProperties = this.sortProperties(this.properties);
            switch (this.mode) {
                case 0: {
                    this.addPropertiesToModel(sortedProperties, null);
                    break;
                }
                case 1: {
                    List categories = this.sortCategories(this.getPropertyCategories(sortedProperties));
                    Iterator iter = categories.iterator();
                    while (iter.hasNext()) {
                        String category = (String)iter.next();
                        Item categoryItem = new Item(category, null);
                        this.model.add(categoryItem);
                        this.addPropertiesToModel(this.sortProperties(this.getPropertiesForCategory(this.properties, category)), categoryItem);
                    }
                    break;
                }
            }
        }
        this.visibilityChanged();
        this.fireTableDataChanged();
    }

    protected List sortProperties(List localProperties) {
        ArrayList sortedProperties = new ArrayList(localProperties);
        if (this.sortingProperties) {
            if (this.propertySortingComparator == null) {
                this.propertySortingComparator = new PropertyComparator();
            }
            Collections.sort(sortedProperties, this.propertySortingComparator);
        }
        return sortedProperties;
    }

    protected List sortCategories(List localCategories) {
        ArrayList sortedCategories = new ArrayList(localCategories);
        if (this.sortingCategories) {
            if (this.categorySortingComparator == null) {
                this.categorySortingComparator = STRING_COMPARATOR;
            }
            Collections.sort(sortedCategories, this.categorySortingComparator);
        }
        return sortedCategories;
    }

    protected List getPropertyCategories(List localProperties) {
        ArrayList<String> categories = new ArrayList<String>();
        Iterator iter = localProperties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (categories.contains(property.getCategory())) continue;
            categories.add(property.getCategory());
        }
        return categories;
    }

    private void addPropertiesToModel(List localProperties, Item parent) {
        Iterator iter = localProperties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            Item propertyItem = new Item(property, parent);
            this.model.add(propertyItem);
            Property[] subProperties = property.getSubProperties();
            if (subProperties == null || subProperties.length <= 0) continue;
            this.addPropertiesToModel(Arrays.asList(subProperties), propertyItem);
        }
    }

    private List getPropertiesForCategory(List localProperties, String category) {
        ArrayList<Property> categoryProperties = new ArrayList<Property>();
        Iterator iter = localProperties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (category != property.getCategory() && (category == null || !category.equals(property.getCategory()))) continue;
            categoryProperties.add(property);
        }
        return categoryProperties;
    }

    public static class NaturalOrderStringComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    public static class PropertyComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Property && o2 instanceof Property) {
                Property prop1 = (Property)o1;
                Property prop2 = (Property)o2;
                if (prop1 == null) {
                    return prop2 == null ? 0 : -1;
                }
                return STRING_COMPARATOR.compare(prop1.getDisplayName() == null ? null : prop1.getDisplayName().toLowerCase(), prop2.getDisplayName() == null ? null : prop2.getDisplayName().toLowerCase());
            }
            return 0;
        }
    }

    public class Item {
        private String name;
        private Property property;
        private Item parent;
        private boolean hasToggle = true;
        private boolean visible = true;

        private Item(String name, Item parent) {
            this.name = name;
            this.parent = parent;
            this.hasToggle = true;
        }

        private Item(Property property, Item parent) {
            this.name = property.getDisplayName();
            this.property = property;
            this.parent = parent;
            this.visible = property == null;
            Property[] subProperties = property.getSubProperties();
            this.hasToggle = subProperties != null && subProperties.length > 0;
        }

        public String getName() {
            return this.name;
        }

        public boolean isProperty() {
            return this.property != null;
        }

        public Property getProperty() {
            return this.property;
        }

        public Item getParent() {
            return this.parent;
        }

        public int getDepth() {
            int depth = 0;
            if (this.parent != null) {
                depth = this.parent.getDepth();
                if (this.parent.isProperty()) {
                    ++depth;
                }
            }
            return depth;
        }

        public boolean hasToggle() {
            return this.hasToggle;
        }

        public void toggle() {
            if (this.hasToggle()) {
                this.visible = !this.visible;
                PropertySheetTableModel.this.visibilityChanged();
            }
        }

        public boolean isVisible() {
            return !(this.parent != null && !this.parent.isVisible() || this.hasToggle && !this.visible);
        }
    }
}

